/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.model.factory.impl.AbstractOrcidProfileSectionFactory;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.orcid.jaxb.model.v3.release.common.Country;
import org.orcid.jaxb.model.v3.release.common.Url;
import org.orcid.jaxb.model.v3.release.record.Address;
import org.orcid.jaxb.model.v3.release.record.Keyword;
import org.orcid.jaxb.model.v3.release.record.OtherName;
import org.orcid.jaxb.model.v3.release.record.ResearcherUrl;

public class OrcidSimpleValueObjectFactory
extends AbstractOrcidProfileSectionFactory {
    private List<String> metadataFields = new ArrayList<String>();

    public OrcidSimpleValueObjectFactory(OrcidProfileSectionType sectionType, OrcidProfileSyncPreference preference) {
        super(sectionType, preference);
    }

    @Override
    public List<OrcidProfileSectionType> getSupportedTypes() {
        return List.of(OrcidProfileSectionType.COUNTRY, OrcidProfileSectionType.KEYWORDS, OrcidProfileSectionType.OTHER_NAMES, OrcidProfileSectionType.RESEARCHER_URLS);
    }

    @Override
    public Object create(Context context, List<MetadataValue> metadataValues) {
        if (CollectionUtils.isEmpty(metadataValues)) {
            throw new IllegalArgumentException("No metadata values provided to create ORCID object with simple value");
        }
        if (metadataValues.size() > 1) {
            throw new IllegalArgumentException("Multiple metadata values not supported: " + metadataValues);
        }
        MetadataValue metadataValue = metadataValues.get(0);
        String currentMetadataField = metadataValue.getMetadataField().toString('.');
        if (!this.metadataFields.contains(currentMetadataField)) {
            throw new IllegalArgumentException("Metadata field not supported: " + currentMetadataField);
        }
        return this.create(context, metadataValue);
    }

    @Override
    public List<String> getMetadataSignatures(Context context, Item item) {
        return this.metadataFields.stream().flatMap(metadataField -> this.getMetadataValues(item, (String)metadataField).stream()).map(metadataValue -> this.metadataSignatureGenerator.generate(context, List.of(metadataValue))).collect(Collectors.toList());
    }

    @Override
    public String getDescription(Context context, Item item, String signature) {
        List<MetadataValue> metadataValues = this.metadataSignatureGenerator.findBySignature(context, item, signature);
        return CollectionUtils.isNotEmpty(metadataValues) ? metadataValues.get(0).getValue() : null;
    }

    protected Object create(Context context, MetadataValue metadataValue) {
        switch (this.getProfileSectionType()) {
            case COUNTRY: {
                return this.createAddress(context, metadataValue);
            }
            case KEYWORDS: {
                return this.createKeyword(metadataValue);
            }
            case OTHER_NAMES: {
                return this.createOtherName(metadataValue);
            }
            case RESEARCHER_URLS: {
                return this.createResearcherUrl(metadataValue);
            }
        }
        throw new IllegalStateException("OrcidSimpleValueObjectFactory does not support type " + this.getProfileSectionType());
    }

    private ResearcherUrl createResearcherUrl(MetadataValue metadataValue) {
        ResearcherUrl researcherUrl = new ResearcherUrl();
        researcherUrl.setUrl(new Url(metadataValue.getValue()));
        return researcherUrl;
    }

    private OtherName createOtherName(MetadataValue metadataValue) {
        OtherName otherName = new OtherName();
        otherName.setContent(metadataValue.getValue());
        return otherName;
    }

    private Keyword createKeyword(MetadataValue metadataValue) {
        Keyword keyword = new Keyword();
        keyword.setContent(metadataValue.getValue());
        return keyword;
    }

    private Address createAddress(Context context, MetadataValue metadataValue) {
        return this.orcidCommonObjectFactory.createCountry(context, metadataValue).map(this::createAddress).orElseThrow(() -> new IllegalArgumentException("No address creatable from value " + metadataValue.getValue()));
    }

    private Address createAddress(Country country) {
        Address address = new Address();
        address.setCountry(country);
        return address;
    }

    public void setMetadataFields(String metadataFields) {
        this.metadataFields = metadataFields != null ? Arrays.asList(metadataFields.split(",")) : Collections.emptyList();
    }

    @Override
    public List<String> getMetadataFields() {
        return this.metadataFields;
    }
}

