/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.ProcessStatus;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hibernate.annotations.Type;

@Entity
@Table(name="process")
public class Process
implements ReloadableEntity<Integer> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="process_id_seq")
    @SequenceGenerator(name="process_id_seq", sequenceName="process_id_seq", allocationSize=1)
    @Column(name="process_id", unique=true, nullable=false)
    private Integer processId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private EPerson ePerson;
    @Column(name="start_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startTime;
    @Column(name="finished_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date finishedTime;
    @Column(name="script", nullable=false)
    private String name;
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private ProcessStatus processStatus;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="parameters")
    private String parameters;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="process2bitstream", joinColumns={@JoinColumn(name="process_id")}, inverseJoinColumns={@JoinColumn(name="bitstream_id")})
    private List<Bitstream> bitstreams;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinTable(name="process2group", joinColumns={@JoinColumn(name="process_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private List<Group> groups;
    @Column(name="creation_time", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationTime;
    public static final String BITSTREAM_TYPE_METADATAFIELD = "dspace.process.filetype";
    public static final String OUTPUT_TYPE = "script_output";

    protected Process() {
    }

    @Override
    public Integer getID() {
        return this.processId;
    }

    public void setProcessId(Integer processId) {
        this.processId = processId;
    }

    public EPerson getEPerson() {
        return this.ePerson;
    }

    public void setEPerson(EPerson ePerson) {
        this.ePerson = ePerson;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessStatus getProcessStatus() {
        return this.processStatus;
    }

    public void setProcessStatus(ProcessStatus processStatus) {
        this.processStatus = processStatus;
    }

    protected String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public List<Bitstream> getBitstreams() {
        if (this.bitstreams == null) {
            this.bitstreams = new ArrayList<Bitstream>();
        }
        return this.bitstreams;
    }

    public void setBitstreams(List<Bitstream> bitstreams) {
        this.bitstreams = bitstreams;
    }

    public void removeBitstream(Bitstream bitstream) {
        this.getBitstreams().remove(bitstream);
    }

    public void addBitstream(Bitstream bitstream) {
        this.getBitstreams().add(bitstream);
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public boolean equals(Object other) {
        return other instanceof Process && new EqualsBuilder().append((Object)this.getID(), (Object)((Process)other).getID()).append((Object)this.getName(), (Object)((Process)other).getName()).append(this.getBitstreams(), ((Process)other).getBitstreams()).append((Object)this.getProcessStatus(), (Object)((Process)other).getProcessStatus()).append((Object)this.getFinishedTime(), (Object)((Process)other).getFinishedTime()).append((Object)this.getStartTime(), (Object)((Process)other).getStartTime()).append((Object)this.getParameters(), (Object)((Process)other).getParameters()).append((Object)this.getCreationTime(), (Object)((Process)other).getCreationTime()).append((Object)this.getEPerson(), (Object)((Process)other).getEPerson()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getID()).append((Object)this.getName()).append(this.getBitstreams()).append((Object)this.getProcessStatus()).append((Object)this.getFinishedTime()).append((Object)this.getStartTime()).append((Object)this.getParameters()).append((Object)this.getCreationTime()).append((Object)this.getEPerson()).toHashCode();
    }
}

