/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.listener;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.dspace.submit.listener.MetadataListener;

public class SimpleMetadataListener
implements MetadataListener {
    private Map<String, List<ExternalDataProvider>> externalDataProvidersMap;
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public Map<String, List<ExternalDataProvider>> getExternalDataProvidersMap() {
        return this.externalDataProvidersMap;
    }

    public void setExternalDataProvidersMap(Map<String, List<ExternalDataProvider>> externalDataProvidersMap) {
        this.externalDataProvidersMap = externalDataProvidersMap;
    }

    @Override
    public Set<String> getMetadataToListen() {
        return this.externalDataProvidersMap.keySet();
    }

    @Override
    public ExternalDataObject getExternalDataObject(Context context, Item item, Set<String> changedMetadata) {
        for (String m : changedMetadata) {
            List<ExternalDataProvider> providers = this.externalDataProvidersMap.get(m);
            for (ExternalDataProvider prov : providers) {
                Optional<ExternalDataObject> result;
                String id = this.generateExternalId(context, prov, item, changedMetadata, m);
                if (!StringUtils.isNotBlank((CharSequence)id) || !(result = prov.getExternalDataObject(id)).isPresent()) continue;
                return result.get();
            }
        }
        return null;
    }

    protected String generateExternalId(Context context, ExternalDataProvider prov, Item item, Set<String> changedMetadata, String m) {
        List<MetadataValue> metadataByMetadataString = this.itemService.getMetadataByMetadataString(item, m);
        if (metadataByMetadataString != null && metadataByMetadataString.size() == 1) {
            return metadataByMetadataString.get(0).getValue();
        }
        return null;
    }
}

