/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.subscriptions;

import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.FrequencyType;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.subscriptions.SubscriptionEmailNotificationConfiguration;
import org.dspace.subscriptions.SubscriptionEmailNotificationService;
import org.dspace.subscriptions.SubscriptionEmailNotificationServiceImpl;
import org.dspace.utils.DSpace;

public class SubscriptionEmailNotification
extends DSpaceRunnable<SubscriptionEmailNotificationConfiguration<SubscriptionEmailNotification>> {
    private Context context;
    private SubscriptionEmailNotificationService subscriptionEmailNotificationService;

    @Override
    public SubscriptionEmailNotificationConfiguration<SubscriptionEmailNotification> getScriptConfiguration() {
        return (SubscriptionEmailNotificationConfiguration)new DSpace().getServiceManager().getServiceByName("subscription-send", SubscriptionEmailNotificationConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.subscriptionEmailNotificationService = (SubscriptionEmailNotificationService)new DSpace().getServiceManager().getServiceByName(SubscriptionEmailNotificationServiceImpl.class.getName(), SubscriptionEmailNotificationServiceImpl.class);
    }

    @Override
    public void internalRun() throws Exception {
        this.assignCurrentUserInContext();
        this.assignSpecialGroupsInContext();
        String frequencyOption = this.commandLine.getOptionValue("f");
        if (StringUtils.isBlank((CharSequence)frequencyOption)) {
            throw new IllegalArgumentException("Option --frequency (-f) must be set");
        }
        if (!FrequencyType.isSupportedFrequencyType(frequencyOption)) {
            throw new IllegalArgumentException("Option f must be one of following values D(Day), W(Week) or M(Month)");
        }
        this.subscriptionEmailNotificationService.perform(this.getContext(), this.handler, "content", frequencyOption);
    }

    private void assignCurrentUserInContext() throws SQLException {
        this.context = new Context();
        UUID uuid = this.getEpersonIdentifier();
        if (Objects.nonNull(uuid)) {
            EPerson ePerson = (EPerson)EPersonServiceFactory.getInstance().getEPersonService().find(this.context, uuid);
            this.context.setCurrentUser(ePerson);
        }
    }

    private void assignSpecialGroupsInContext() throws SQLException {
        for (UUID uuid : this.handler.getSpecialGroups()) {
            this.context.setSpecialGroup(uuid);
        }
    }

    public SubscriptionEmailNotificationService getSubscriptionEmailNotificationService() {
        return this.subscriptionEmailNotificationService;
    }

    public void setSubscriptionEmailNotificationService(SubscriptionEmailNotificationService notificationService) {
        this.subscriptionEmailNotificationService = notificationService;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

