/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.client;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.app.client.DSpaceProxyRoutePlanner;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DSpaceHttpClientFactoryTest {
    @InjectMocks
    private DSpaceHttpClientFactory httpClientFactory;
    @Mock
    private ConfigurationService configurationService;
    private MockWebServer mockProxy;
    private MockWebServer mockServer;

    @Before
    public void init() {
        this.httpClientFactory.setProxyRoutePlanner(new DSpaceProxyRoutePlanner(this.configurationService));
        this.mockProxy = new MockWebServer();
        this.mockProxy.enqueue(new MockResponse().setResponseCode(200).addHeader("From", (Object)"Proxy"));
        this.mockServer = new MockWebServer();
        this.mockServer.enqueue(new MockResponse().setResponseCode(200).addHeader("From", (Object)"Server"));
    }

    @Test
    public void testBuildWithProxyConfigured() throws Exception {
        this.setHttpProxyOnConfigurationService(new String[0]);
        CloseableHttpClient httpClient = this.httpClientFactory.build();
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From"), (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From")[0].getValue(), (Matcher)Matchers.is((Object)"Proxy"));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        RecordedRequest request = this.mockProxy.takeRequest(100L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)request, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)request.getRequestUrl(), (Matcher)Matchers.is((Object)this.mockProxy.url("")));
        MatcherAssert.assertThat((Object)request.getRequestLine(), (Matcher)Matchers.is((Object)("GET " + this.mockServer.url("").toString() + " HTTP/1.1")));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.host");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.port");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getArrayProperty("http.proxy.hosts-to-ignore");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationService});
    }

    @Test
    public void testBuildWithProxyConfiguredAndHostToIgnoreSet() throws Exception {
        this.setHttpProxyOnConfigurationService(this.mockServer.getHostName());
        CloseableHttpClient httpClient = this.httpClientFactory.build();
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From"), (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From")[0].getValue(), (Matcher)Matchers.is((Object)"Server"));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)1));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getArrayProperty("http.proxy.hosts-to-ignore");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationService});
    }

    @Test
    public void testBuildWithProxyConfiguredAndHostPrefixToIgnoreSet() throws Exception {
        InetAddress address = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        String hostname = address.getHostName();
        String hostnamePrefix = hostname.substring(0, 4);
        this.setHttpProxyOnConfigurationService(hostnamePrefix + "*", "www.test.com");
        CloseableHttpClient httpClient = this.httpClientFactory.build();
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From"), (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From")[0].getValue(), (Matcher)Matchers.is((Object)"Server"));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)1));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getArrayProperty("http.proxy.hosts-to-ignore");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationService});
    }

    @Test
    public void testBuildWithProxyConfiguredAndHostSuffixToIgnoreSet() throws Exception {
        InetAddress address = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        String hostname = address.getHostName();
        String hostnameSuffix = hostname.substring(hostname.length() - 4);
        this.setHttpProxyOnConfigurationService("www.test.com", "*" + hostnameSuffix);
        CloseableHttpClient httpClient = this.httpClientFactory.build();
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From"), (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From")[0].getValue(), (Matcher)Matchers.is((Object)"Server"));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)1));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getArrayProperty("http.proxy.hosts-to-ignore");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationService});
    }

    @Test
    public void testBuildWithoutConfiguredProxy() throws Exception {
        CloseableHttpClient httpClient = this.httpClientFactory.build();
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From"), (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From")[0].getValue(), (Matcher)Matchers.is((Object)"Server"));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)1));
        RecordedRequest request = this.mockServer.takeRequest(100L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)request, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)request.getRequestUrl(), (Matcher)Matchers.is((Object)this.mockServer.url("")));
        MatcherAssert.assertThat((Object)request.getRequestLine(), (Matcher)Matchers.is((Object)"GET / HTTP/1.1"));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.host");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.port");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getArrayProperty("http.proxy.hosts-to-ignore");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationService});
    }

    @Test
    public void testBuildWithoutProxy() throws Exception {
        CloseableHttpClient httpClient = this.httpClientFactory.buildWithoutProxy();
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        RecordedRequest request = this.mockServer.takeRequest(100L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)request, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)request.getRequestUrl(), (Matcher)Matchers.is((Object)this.mockServer.url("")));
        MatcherAssert.assertThat((Object)request.getRequestLine(), (Matcher)Matchers.is((Object)"GET / HTTP/1.1"));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.configurationService});
    }

    @Test
    public void testBuildWithoutAutomaticRetries() throws Exception {
        this.setHttpProxyOnConfigurationService("www.test.com");
        CloseableHttpClient httpClient = this.httpClientFactory.buildWithoutAutomaticRetries(10);
        httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        RecordedRequest request = this.mockProxy.takeRequest(100L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)request, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)request.getRequestUrl(), (Matcher)Matchers.is((Object)this.mockProxy.url("")));
        MatcherAssert.assertThat((Object)request.getRequestLine(), (Matcher)Matchers.is((Object)("GET " + this.mockServer.url("").toString() + " HTTP/1.1")));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.host");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.port");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getArrayProperty("http.proxy.hosts-to-ignore");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationService});
    }

    @Test
    public void testBuildWithHttpRequestInterceptor() throws Exception {
        this.setHttpProxyOnConfigurationService("*test.com", "www.dspace.com");
        AtomicReference contextReference = new AtomicReference();
        HttpRequestInterceptor interceptor = (request, context) -> contextReference.set(context);
        this.httpClientFactory.setRequestInterceptors(List.of(interceptor));
        CloseableHttpClient httpClient = this.httpClientFactory.build();
        httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        HttpContext httpContext = (HttpContext)contextReference.get();
        MatcherAssert.assertThat((Object)httpContext, (Matcher)Matchers.notNullValue());
        Object httpRouteObj = httpContext.getAttribute("http.route");
        MatcherAssert.assertThat((Object)httpRouteObj, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)httpRouteObj, (Matcher)Matchers.instanceOf(HttpRoute.class));
        HttpRoute httpRoute = (HttpRoute)httpRouteObj;
        MatcherAssert.assertThat((Object)httpRoute.getHopCount(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)httpRoute.getHopTarget(0).getPort(), (Matcher)Matchers.is((Object)this.mockProxy.getPort()));
        MatcherAssert.assertThat((Object)httpRoute.getHopTarget(1).getPort(), (Matcher)Matchers.is((Object)this.mockServer.getPort()));
    }

    @Test
    public void testBuildWithHttpResponseInterceptor() throws Exception {
        AtomicReference responseReference = new AtomicReference();
        HttpResponseInterceptor responseInterceptor = (response, context) -> responseReference.set(response);
        this.httpClientFactory.setResponseInterceptors(List.of(responseInterceptor));
        CloseableHttpClient httpClient = this.httpClientFactory.build();
        httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)1));
        HttpResponse httpResponse = (HttpResponse)responseReference.get();
        MatcherAssert.assertThat((Object)httpResponse, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From"), (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)httpResponse.getHeaders("From")[0].getValue(), (Matcher)Matchers.is((Object)"Server"));
    }

    @Test
    public void testBuildWithRequestConfig() throws Exception {
        this.setHttpProxyOnConfigurationService(new String[0]);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2500).build();
        AtomicReference contextReference = new AtomicReference();
        HttpRequestInterceptor interceptor = (request, context) -> contextReference.set(context);
        this.httpClientFactory.setRequestInterceptors(List.of(interceptor));
        CloseableHttpClient httpClient = this.httpClientFactory.buildWithRequestConfig(requestConfig);
        httpClient.execute((HttpUriRequest)new HttpGet(this.mockServer.url("").toString()));
        MatcherAssert.assertThat((Object)this.mockProxy.getRequestCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.mockServer.getRequestCount(), (Matcher)Matchers.is((Object)0));
        HttpContext httpContext = (HttpContext)contextReference.get();
        MatcherAssert.assertThat((Object)httpContext, (Matcher)Matchers.notNullValue());
        Object httpRequestConfigObj = httpContext.getAttribute("http.request-config");
        MatcherAssert.assertThat((Object)httpRequestConfigObj, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)httpRequestConfigObj, (Matcher)Matchers.instanceOf(RequestConfig.class));
        MatcherAssert.assertThat((Object)((RequestConfig)httpRequestConfigObj).getConnectTimeout(), (Matcher)Matchers.is((Object)2500));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.host");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getProperty("http.proxy.port");
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).getArrayProperty("http.proxy.hosts-to-ignore");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationService});
    }

    private void setHttpProxyOnConfigurationService(String ... hostsToIgnore) {
        Mockito.when((Object)this.configurationService.getProperty("http.proxy.host")).thenReturn((Object)this.mockProxy.getHostName());
        Mockito.when((Object)this.configurationService.getProperty("http.proxy.port")).thenReturn((Object)String.valueOf(this.mockProxy.getPort()));
        Mockito.when((Object)this.configurationService.getArrayProperty("http.proxy.hosts-to-ignore")).thenReturn((Object)hostsToIgnore);
    }
}

