/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid;

import java.io.InputStream;
import org.dspace.authority.orcid.Orcidv3SolrAuthorityImpl;
import org.dspace.external.OrcidRestConnector;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockOrcid
extends Orcidv3SolrAuthorityImpl {
    OrcidRestConnector orcidRestConnector;

    public void init() {
        this.initializeAccessToken();
        this.orcidRestConnector = (OrcidRestConnector)Mockito.mock(OrcidRestConnector.class);
    }

    public void setupNoResultsSearch() {
        Mockito.when((Object)this.orcidRestConnector.get(ArgumentMatchers.startsWith((String)"search?"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocation) {
                return this.getClass().getResourceAsStream("orcid-search-noresults.xml");
            }
        });
    }

    public void setupSingleSearch() {
        Mockito.when((Object)this.orcidRestConnector.get(ArgumentMatchers.startsWith((String)"search?q=Bollini"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocation) {
                return this.getClass().getResourceAsStream("orcid-search.xml");
            }
        });
    }

    public void setupSearchWithResults() {
        Mockito.when((Object)this.orcidRestConnector.get(ArgumentMatchers.endsWith((String)"/person"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocation) {
                return this.getClass().getResourceAsStream("orcid-person-record.xml");
            }
        });
        this.setOrcidRestConnector(this.orcidRestConnector);
    }

    public void initializeAccessToken() {
        if (this.getAccessToken() == null) {
            this.setAccessToken("mock-access-token");
        }
    }
}

