/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class CommunityTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = LogManager.getLogger(CommunityTest.class);
    private Community c;
    private AuthorizeService authorizeServiceSpy;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.c = this.communityService.create(null, this.context);
            this.dspaceObject = this.c;
            this.context.restoreAuthSystemState();
            this.authorizeServiceSpy = (AuthorizeService)Mockito.spy((Object)this.authorizeService);
            ReflectionTestUtils.setField((Object)this.communityService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)this.collectionService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)this.itemService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)AuthorizeServiceFactory.getInstance(), (String)"authorizeService", (Object)this.authorizeServiceSpy);
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.communityService.delete(this.context, (DSpaceObject)this.c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.restoreAuthSystemState();
        this.c = null;
        super.destroy();
    }

    @Test
    public void testCommunityFind() throws Exception {
        UUID id = this.c.getID();
        Community found = (Community)this.communityService.find(this.context, id);
        MatcherAssert.assertThat((String)"testCommunityFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCommunityFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        MatcherAssert.assertThat((String)"testCommunityFind 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testCreateAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.authorizeActionBoolean(this.context, (DSpaceObject)this.c, 3)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)false);
        Community sub = this.communityService.create(this.c, this.context);
        MatcherAssert.assertThat((String)"testCreate 2", (Object)sub, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreate 3", (Object)sub.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertTrue((String)"testCreate 4", (this.communityService.getAllParents(this.context, sub).size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testCreate 5", (Object)((Community)this.communityService.getAllParents(this.context, sub).get(0)), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testCreateAuth2() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context, this.eperson)).thenReturn((Object)true);
        Community created = this.communityService.create(null, this.context);
        MatcherAssert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Community son = this.communityService.create(created, this.context);
        MatcherAssert.assertThat((String)"testCreate 2", (Object)son, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreate 3", (Object)son.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertTrue((String)"testCreate 4", (this.communityService.getAllParents(this.context, son).size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testCreate 5", (Object)((Community)this.communityService.getAllParents(this.context, son).get(0)), (Matcher)CoreMatchers.equalTo((Object)created));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)false);
        this.communityService.create(null, this.context);
        Assert.fail((String)"Exception expected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithValidHandle() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        ((AuthorizeService)Mockito.doReturn((Object)true).when((Object)this.authorizeServiceSpy)).isAdmin((Context)ArgumentMatchers.eq((Object)this.context), (EPerson)ArgumentMatchers.any(EPerson.class));
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        String handleAdditionalPrefixes = configurationService.getProperty("handle.additional.prefixes");
        try {
            configurationService.setProperty("handle.additional.prefixes", (Object)"987654321");
            Community created = this.communityService.create(null, this.context, "987654321/100c");
            MatcherAssert.assertThat((String)"testCreateWithValidHandle 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((String)"testCreateWithValidHandle 1", (Object)created.getHandle(), (Matcher)CoreMatchers.equalTo((Object)"987654321/100c"));
        }
        finally {
            configurationService.setProperty("handle.additional.prefixes", (Object)handleAdditionalPrefixes);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateWithInvalidHandle() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String inUseHandle = this.c.getHandle();
        this.communityService.create(null, this.context, inUseHandle);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindAll() throws Exception {
        List all = this.communityService.findAll(this.context);
        MatcherAssert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (all.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Community cm : all) {
            if (!cm.equals((Object)this.c)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testFindAllTop() throws Exception {
        List all = this.communityService.findAllTop(this.context);
        MatcherAssert.assertThat((String)"testFindAllTop 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAllTop 1", (all.size() >= 1 ? 1 : 0) != 0);
        for (Community cm : all) {
            MatcherAssert.assertThat((String)"testFindAllTop for", (Object)this.communityService.getAllParents(this.context, cm).size(), (Matcher)CoreMatchers.equalTo((Object)0));
        }
        boolean added = false;
        for (Community cm : all) {
            if (!cm.equals((Object)this.c)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAllTop 2", (boolean)added);
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.c.getID() != null ? 1 : 0) != 0);
    }

    @Test
    public void testLegacyID() {
        Assert.assertTrue((String)"testGetLegacyID 0", (this.c.getLegacyId() == null ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertTrue((String)"testGetHandle 0", (boolean)this.c.getHandle().contains("123456789/"));
    }

    @Test
    public void testSetMetadata() throws SQLException {
        String name = "name";
        String sdesc = "short description";
        String itext = "introductory text";
        String copy = "copyright declaration";
        String sidebar = "side bar text";
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)this.c, CommunityService.MD_NAME, null, name);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)this.c, CommunityService.MD_SHORT_DESCRIPTION, null, sdesc);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)this.c, CommunityService.MD_INTRODUCTORY_TEXT, null, itext);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)this.c, CommunityService.MD_COPYRIGHT_TEXT, null, copy);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)this.c, CommunityService.MD_SIDEBAR_TEXT, null, sidebar);
        Assert.assertEquals((String)"Name not set properly.", (Object)name, (Object)this.communityService.getMetadataFirstValue((DSpaceObject)this.c, CommunityService.MD_NAME, "*"));
        Assert.assertEquals((String)"Short description not set properly.", (Object)sdesc, (Object)this.communityService.getMetadataFirstValue((DSpaceObject)this.c, CommunityService.MD_SHORT_DESCRIPTION, "*"));
        Assert.assertEquals((String)"Introductory text not set properly.", (Object)itext, (Object)this.communityService.getMetadataFirstValue((DSpaceObject)this.c, CommunityService.MD_INTRODUCTORY_TEXT, "*"));
        Assert.assertEquals((String)"Copyright text not set properly.", (Object)copy, (Object)this.communityService.getMetadataFirstValue((DSpaceObject)this.c, CommunityService.MD_COPYRIGHT_TEXT, "*"));
        Assert.assertEquals((String)"Sidebar text not set properly.", (Object)sidebar, (Object)this.communityService.getMetadataFirstValue((DSpaceObject)this.c, CommunityService.MD_SIDEBAR_TEXT, "*"));
    }

    @Override
    @Test
    public void testGetName() {
        MatcherAssert.assertThat((String)"testGetName 0", (Object)this.c.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testGetLogo() {
        MatcherAssert.assertThat((String)"testGetLogo 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.communityService.setLogo(this.context, this.c, (InputStream)new FileInputStream(f));
        MatcherAssert.assertThat((String)"testSetLogoAuth 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        MatcherAssert.assertThat((String)"testSetLogoAuth 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testSetLogoNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        File f = new File(testProps.get("test.bitstream").toString());
        this.communityService.setLogo(this.context, this.c, (InputStream)new FileInputStream(f));
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        this.communityService.update(this.context, (DSpaceObject)this.c);
        Assert.fail((String)"Exception must be thrown");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        this.communityService.update(this.context, (DSpaceObject)this.c);
    }

    @Test
    public void testCreateAdministratorsAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 11);
        Group result = this.communityService.createAdministrators(this.context, this.c);
        MatcherAssert.assertThat((String)"testCreateAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreateAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateAdministratorsNoAuth() throws Exception {
        this.communityService.createAdministrators(this.context, this.c);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testRemoveAdministratorsAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        this.context.turnOffAuthorisationSystem();
        Group result = this.communityService.createAdministrators(this.context, this.c);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testRemoveAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
        this.communityService.removeAdministrators(this.context, this.c);
        MatcherAssert.assertThat((String)"testRemoveAdministratorsAuth 2", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveAdministratorsNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 11);
        this.context.turnOffAuthorisationSystem();
        Group result = this.communityService.createAdministrators(this.context, this.c);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testRemoveAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
        this.communityService.removeAdministrators(this.context, this.c);
        Assert.fail((String)"Should have thrown exception");
    }

    @Test
    public void testGetAdministrators() {
        MatcherAssert.assertThat((String)"testGetAdministrators 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetCollections() throws Exception {
        MatcherAssert.assertThat((String)"testGetCollections 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCollections 1", (this.c.getCollections().size() == 0 ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        Collection collection = this.collectionService.create(this.context, this.c);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, MetadataSchemaEnum.DC.getName(), "title", null, "*", "collection B");
        collection = this.collectionService.create(this.context, this.c);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, MetadataSchemaEnum.DC.getName(), "title", null, "*", "collection C");
        collection = this.collectionService.create(this.context, this.c);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, MetadataSchemaEnum.DC.getName(), "title", null, "*", "collection A");
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testGetCollections 2", (boolean)((Collection)this.c.getCollections().get(0)).getName().equals("collection A"));
        Assert.assertTrue((String)"testGetCollections 3", (boolean)((Collection)this.c.getCollections().get(1)).getName().equals("collection B"));
        Assert.assertTrue((String)"testGetCollections 4", (boolean)((Collection)this.c.getCollections().get(2)).getName().equals("collection C"));
    }

    @Test
    public void testGetSubcommunities() throws Exception {
        MatcherAssert.assertThat((String)"testGetSubcommunities 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSubcommunities 1", (this.c.getSubcommunities().size() == 0 ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        Community community = this.communityService.create(this.c, this.context);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)community, MetadataSchemaEnum.DC.getName(), "title", null, "*", "subcommunity B");
        community = this.communityService.create(this.c, this.context);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)community, MetadataSchemaEnum.DC.getName(), "title", null, "*", "subcommunity A");
        community = this.communityService.create(this.c, this.context);
        this.communityService.setMetadataSingleValue(this.context, (DSpaceObject)community, MetadataSchemaEnum.DC.getName(), "title", null, "*", "subcommunity C");
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testGetCollections 2", (boolean)((Community)this.c.getSubcommunities().get(0)).getName().equals("subcommunity A"));
        Assert.assertTrue((String)"testGetCollections 3", (boolean)((Community)this.c.getSubcommunities().get(1)).getName().equals("subcommunity B"));
        Assert.assertTrue((String)"testGetCollections 4", (boolean)((Community)this.c.getSubcommunities().get(2)).getName().equals("subcommunity C"));
    }

    @Test
    public void testGetParentCommunity() throws Exception {
        MatcherAssert.assertThat((String)"testGetParentCommunity 0", (Object)this.c.getParentCommunities().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.context.turnOffAuthorisationSystem();
        Community son = this.communityService.create(this.c, this.context);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testGetParentCommunity 1", (Object)son.getParentCommunities().size(), (Matcher)CoreMatchers.not((Object)0));
        MatcherAssert.assertThat((String)"testGetParentCommunity 2", (Object)((Community)son.getParentCommunities().get(0)), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testGetAllParents() throws Exception {
        MatcherAssert.assertThat((String)"testGetAllParents 0", (Object)this.communityService.getAllParents(this.context, this.c), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllParents 1", (this.communityService.getAllParents(this.context, this.c).size() == 0 ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        Community son = this.communityService.create(this.c, this.context);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testGetAllParents 2", (Object)this.communityService.getAllParents(this.context, son), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllParents 3", (this.communityService.getAllParents(this.context, son).size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testGetAllParents 4", (Object)((Community)this.communityService.getAllParents(this.context, son).get(0)), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testGetAllCollections() throws Exception {
        MatcherAssert.assertThat((String)"testGetAllCollections 0", (Object)this.communityService.getAllCollections(this.context, this.c), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllCollections 1", (boolean)this.communityService.getAllCollections(this.context, this.c).isEmpty());
        this.context.turnOffAuthorisationSystem();
        Collection collOfC = this.collectionService.create(this.context, this.c);
        Community sub = this.communityService.create(this.c, this.context);
        Collection collOfSub = this.collectionService.create(this.context, sub);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testGetAllCollections 2", (Object)this.communityService.getAllCollections(this.context, this.c), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllCollections 3", (this.communityService.getAllCollections(this.context, this.c).size() == 2 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testGetAllCollections 4", (Object)((Collection)this.communityService.getAllCollections(this.context, this.c).get(0)), (Matcher)CoreMatchers.equalTo((Object)collOfSub));
        MatcherAssert.assertThat((String)"testGetAllCollections 5", (Object)((Collection)this.communityService.getAllCollections(this.context, this.c).get(1)), (Matcher)CoreMatchers.equalTo((Object)collOfC));
    }

    @Test
    public void testCreateCollectionAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3, true);
        Collection result = this.collectionService.create(this.context, this.c);
        MatcherAssert.assertThat((String)"testCreateCollectionAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreateCollectionAuth 1", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreateCollectionAuth 2", (Object)((Collection)this.c.getCollections().get(0)), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateCollectionNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3);
        this.collectionService.create(this.context, this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddCollectionAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3, true);
        Collection col = this.collectionService.create(this.context, this.c);
        this.c.addCollection(col);
        MatcherAssert.assertThat((String)"testAddCollectionAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testAddCollectionAuth 1", (Object)((Collection)this.c.getCollections().get(0)), (Matcher)CoreMatchers.equalTo((Object)col));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddCollectionNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3);
        Collection col = this.collectionService.create(this.context, this.c);
        this.c.addCollection(col);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSubcommunityAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3);
        Mockito.when((Object)this.authorizeServiceSpy.authorizeActionBoolean(this.context, (DSpaceObject)this.c, 3)).thenReturn((Object)true);
        Community result = this.communityService.createSubcommunity(this.context, this.c);
        MatcherAssert.assertThat((String)"testCreateSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreateSubcommunityAuth 1", (this.c.getSubcommunities().size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testCreateSubcommunityAuth 2", (Object)((Community)this.c.getSubcommunities().get(0)), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSubcommunityNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3);
        this.communityService.createSubcommunity(this.context, this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddSubcommunityAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 3);
        this.context.turnOffAuthorisationSystem();
        Community result = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        this.communityService.addSubcommunity(this.context, this.c, result);
        MatcherAssert.assertThat((String)"testAddSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddSubcommunityAuth 1", (this.c.getSubcommunities().size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddSubcommunityAuth 2", (Object)((Community)this.c.getSubcommunities().get(0)), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddSubcommunityNoAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community result = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        this.communityService.addSubcommunity(this.context, this.c, result);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveCollectionAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col = this.collectionService.create(this.context, this.c);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testRemoveCollectionAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionAuth 1", (this.c.getCollections().size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testRemoveCollectionAuth 2", (Object)((Collection)this.c.getCollections().get(0)), (Matcher)CoreMatchers.equalTo((Object)col));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 4);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)col, 1, true);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)col, 11);
        this.communityService.removeCollection(this.context, this.c, col);
        MatcherAssert.assertThat((String)"testRemoveCollectionAuth 3", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionAuth 4", (this.c.getCollections().size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveCollectionNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 4);
        this.context.turnOffAuthorisationSystem();
        Collection col = this.collectionService.create(this.context, this.c);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testRemoveCollectionNoAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionNoAuth 1", (this.c.getCollections().size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testRemoveCollectionNoAuth 2", (Object)((Collection)this.c.getCollections().get(0)), (Matcher)CoreMatchers.equalTo((Object)col));
        this.communityService.removeCollection(this.context, this.c, col);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveSubcommunityAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)3), ArgumentMatchers.eq((boolean)true));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)4), ArgumentMatchers.eq((boolean)true));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((boolean)true));
        this.context.turnOffAuthorisationSystem();
        Community com = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        this.communityService.addSubcommunity(this.context, this.c, com);
        MatcherAssert.assertThat((String)"testRemoveSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveSubcommunityAuth 1", (this.c.getSubcommunities().size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testRemoveSubcommunityAuth 2", (Object)((Community)this.c.getSubcommunities().get(0)), (Matcher)CoreMatchers.equalTo((Object)com));
        this.communityService.removeSubcommunity(this.context, this.c, com);
        MatcherAssert.assertThat((String)"testRemoveSubcommunityAuth 3", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveSubcommunityAuth 4", (this.c.getSubcommunities().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)1));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)2));
        this.context.turnOffAuthorisationSystem();
        Community todelete = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        UUID id = todelete.getID();
        this.communityService.delete(this.context, (DSpaceObject)todelete);
        Community found = (Community)this.communityService.find(this.context, id);
        MatcherAssert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteAuth2() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)1));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)2));
        this.context.turnOffAuthorisationSystem();
        Community todelete = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        UUID id = todelete.getID();
        this.communityService.delete(this.context, (DSpaceObject)todelete);
        Community found = (Community)this.communityService.find(this.context, id);
        MatcherAssert.assertThat((String)"testDeleteAuth2 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteHierachyAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((boolean)true));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)4), ArgumentMatchers.eq((boolean)true));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Collection.class), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((boolean)true));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Collection.class), ArgumentMatchers.eq((int)11));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Item.class), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((boolean)true));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Item.class), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((boolean)true));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Item.class), ArgumentMatchers.eq((int)4), ArgumentMatchers.eq((boolean)true));
        this.context.turnOffAuthorisationSystem();
        Community parent = this.communityService.create(null, this.context);
        Community child = this.communityService.createSubcommunity(this.context, parent);
        Community grandchild = this.communityService.createSubcommunity(this.context, child);
        Collection childCol = this.collectionService.create(this.context, child);
        Collection grandchildCol = this.collectionService.create(this.context, grandchild);
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, childCol, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        wsItem = this.workspaceItemService.create(this.context, grandchildCol, false);
        Item item2 = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        this.context.restoreAuthSystemState();
        UUID parentId = parent.getID();
        UUID childId = child.getID();
        UUID grandchildId = grandchild.getID();
        UUID childColId = childCol.getID();
        UUID grandchildColId = grandchildCol.getID();
        UUID itemId = item.getID();
        UUID item2Id = item2.getID();
        this.communityService.delete(this.context, (DSpaceObject)parent);
        MatcherAssert.assertThat((String)"top-level Community not deleted", (Object)((Community)this.communityService.find(this.context, parentId)), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"child Community not deleted", (Object)((Community)this.communityService.find(this.context, childId)), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"grandchild Community not deleted", (Object)((Community)this.communityService.find(this.context, grandchildId)), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Collection of child Community not deleted", (Object)((Collection)this.collectionService.find(this.context, childColId)), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Collection of grandchild Community not deleted", (Object)((Collection)this.collectionService.find(this.context, grandchildColId)), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Item not deleted", (Object)((Item)this.itemService.find(this.context, itemId)), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Item not deleted", (Object)((Item)this.itemService.find(this.context, item2Id)), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Community.class), ArgumentMatchers.eq((int)2));
        this.communityService.delete(this.context, (DSpaceObject)this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException {
        ((AuthorizeService)Mockito.doReturn((Object)true).when((Object)this.authorizeServiceSpy)).isAdmin((Context)ArgumentMatchers.eq((Object)this.context));
        ((AuthorizeService)Mockito.doReturn((Object)true).when((Object)this.authorizeServiceSpy)).isAdmin((Context)ArgumentMatchers.eq((Object)this.context), (EPerson)ArgumentMatchers.any(EPerson.class));
        Assert.assertFalse((String)"testEquals 0", (boolean)this.c.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)this.c.equals((Object)this.communityService.create(null, this.context)));
        Assert.assertTrue((String)"testEquals 2", (boolean)this.c.equals((Object)this.c));
    }

    @Override
    @Test
    public void testGetType() {
        MatcherAssert.assertThat((String)"testGetType 0", (Object)this.c.getType(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.communityService.canEditBoolean(this.context, this.c));
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.communityService.canEditBoolean(this.context, this.c));
    }

    @Test
    public void testCanEditAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        this.communityService.canEdit(this.context, this.c);
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth() throws Exception {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.c, 1);
        this.communityService.canEdit(this.context, this.c);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCountItems() throws Exception {
        Assert.assertTrue((String)"testCountItems 0", (this.itemService.countItems(this.context, this.c) == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        MatcherAssert.assertThat((String)"testGetAdminObject 0", (Object)((Community)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 4)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        MatcherAssert.assertThat((String)"testGetAdminObject 1", (Object)((Community)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 3)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        MatcherAssert.assertThat((String)"testGetAdminObject 2", (Object)((Community)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 2)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        MatcherAssert.assertThat((String)"testGetAdminObject 3", (Object)((Community)this.communityService.getAdminObject(this.context, (DSpaceObject)this.c, 11)), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        try {
            MatcherAssert.assertThat((String)"testGetParentObject 0", (Object)this.communityService.getParentObject(this.context, (DSpaceObject)this.c), (Matcher)CoreMatchers.nullValue());
            this.context.turnOffAuthorisationSystem();
            Community son = this.communityService.createSubcommunity(this.context, this.c);
            this.context.restoreAuthSystemState();
            MatcherAssert.assertThat((String)"testGetParentObject 1", (Object)this.communityService.getParentObject(this.context, (DSpaceObject)son), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((String)"testGetParentObject 2", (Object)((Community)this.communityService.getParentObject(this.context, (DSpaceObject)son)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        }
        catch (AuthorizeException ex) {
            throw new AssertionError("AuthorizeException occurred", ex);
        }
    }
}

