/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Thumbnail;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThumbnailTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(ThumbnailTest.class);
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private Bitstream thumb;
    private Bitstream orig;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            File f = new File(testProps.get("test.bitstream").toString());
            this.thumb = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
            this.orig = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
            Thumbnail t = new Thumbnail(this.thumb, this.orig);
            Assert.assertEquals((Object)this.orig, (Object)t.getOriginal());
            Assert.assertEquals((Object)this.thumb, (Object)t.getThumb());
        }
        catch (IOException ex) {
            log.error("IO Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.bitstreamService.delete(this.context, (DSpaceObject)this.thumb);
            this.bitstreamService.delete(this.context, (DSpaceObject)this.orig);
            this.context.restoreAuthSystemState();
            this.thumb = null;
            this.orig = null;
        }
        catch (Exception e) {
            throw new AssertionError("Error in destroy()", e);
        }
        super.destroy();
    }

    @Test
    public void testDummy() {
        Assert.assertTrue((boolean)true);
    }
}

