/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.logic.DefaultFilter;
import org.dspace.content.logic.LogicalStatement;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.logic.condition.BitstreamCountCondition;
import org.dspace.content.logic.condition.InCollectionCondition;
import org.dspace.content.logic.condition.InCommunityCondition;
import org.dspace.content.logic.condition.IsWithdrawnCondition;
import org.dspace.content.logic.condition.MetadataValueMatchCondition;
import org.dspace.content.logic.condition.MetadataValuesMatchCondition;
import org.dspace.content.logic.condition.ReadableByGroupCondition;
import org.dspace.content.logic.operator.And;
import org.dspace.content.logic.operator.Nand;
import org.dspace.content.logic.operator.Nor;
import org.dspace.content.logic.operator.Not;
import org.dspace.content.logic.operator.Or;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogicalFilterTest
extends AbstractUnitTest {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    private MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    private AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private static final Logger log = LogManager.getLogger(LogicalFilterTest.class);
    Community communityOne;
    Community communityTwo;
    Collection collectionOne;
    Collection collectionTwo;
    Item itemOne;
    Item itemTwo;
    Item itemThree;
    List<LogicalStatement> trueStatements;
    List<LogicalStatement> trueFalseStatements;
    List<LogicalStatement> falseStatements;
    LogicalStatement trueStatementOne;
    LogicalStatement falseStatementOne;
    String element = "title";
    String qualifier = null;
    MetadataField metadataField;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.setUpStatements();
            this.communityOne = this.communityService.create(null, this.context);
            this.collectionOne = this.collectionService.create(this.context, this.communityOne);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collectionOne, false);
            this.itemOne = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            this.bundleService.addBitstream(this.context, this.bundleService.create(this.context, this.itemOne, "THUMBNAIL"), this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Item 1 Thumbnail 1".getBytes(StandardCharsets.UTF_8))));
            this.communityTwo = this.communityService.create(null, this.context);
            this.collectionTwo = this.collectionService.create(this.context, this.communityTwo);
            workspaceItem = this.workspaceItemService.create(this.context, this.collectionTwo, false);
            this.itemTwo = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            Bundle bundleTwo = this.bundleService.create(this.context, this.itemTwo, "ORIGINAL");
            this.bundleService.addBitstream(this.context, bundleTwo, this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Item 2 Bitstream 1".getBytes(StandardCharsets.UTF_8))));
            this.bundleService.addBitstream(this.context, bundleTwo, this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Item 2 Bitstream 2".getBytes(StandardCharsets.UTF_8))));
            workspaceItem = this.workspaceItemService.create(this.context, this.collectionTwo, false);
            this.itemThree = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            Bundle bundleThree = this.bundleService.create(this.context, this.itemThree, "ORIGINAL");
            this.bundleService.addBitstream(this.context, bundleThree, this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Item 3 Bitstream 1".getBytes(StandardCharsets.UTF_8))));
            this.bundleService.addBitstream(this.context, bundleThree, this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Item 3 Bitstream 2".getBytes(StandardCharsets.UTF_8))));
            this.bundleService.addBitstream(this.context, bundleThree, this.bitstreamService.create(this.context, (InputStream)new ByteArrayInputStream("Item 3 Bitstream 2".getBytes(StandardCharsets.UTF_8))));
            this.itemService.withdraw(this.context, this.itemTwo);
            this.metadataField = this.metadataFieldService.findByElement(this.context, MetadataSchemaEnum.DC.getName(), this.element, this.qualifier);
            this.context.restoreAuthSystemState();
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.error("Error encountered during init", e);
            Assert.fail((String)("Error encountered during init: " + e.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.itemService.delete(this.context, (DSpaceObject)this.itemOne);
            this.itemService.delete(this.context, (DSpaceObject)this.itemTwo);
            this.itemService.delete(this.context, (DSpaceObject)this.itemThree);
            this.collectionService.delete(this.context, (DSpaceObject)this.collectionOne);
            this.collectionService.delete(this.context, (DSpaceObject)this.collectionTwo);
            this.communityService.delete(this.context, (DSpaceObject)this.communityOne);
            this.communityService.delete(this.context, (DSpaceObject)this.communityTwo);
        }
        catch (Exception e) {
            log.error("Error cleaning up test resources: " + e.getMessage());
        }
        this.context.restoreAuthSystemState();
        this.communityOne = null;
        this.communityTwo = null;
        this.collectionOne = null;
        this.collectionTwo = null;
        this.itemOne = null;
        this.itemTwo = null;
        this.itemThree = null;
        this.trueStatements = null;
        this.trueFalseStatements = null;
        this.falseStatements = null;
        this.trueStatementOne = null;
        this.falseStatementOne = null;
        this.element = null;
        this.qualifier = null;
        this.metadataField = null;
        super.destroy();
    }

    @Test
    public void testAndOperator() {
        And and = new And();
        try {
            and.setStatements(this.trueStatements);
            Assert.assertTrue((String)"AND operator did not return true for a list of true statements", (boolean)and.getResult(this.context, this.itemOne));
            and.setStatements(this.trueFalseStatements);
            Assert.assertFalse((String)"AND operator did not return false for a list of statements with at least one false", (boolean)and.getResult(this.context, this.itemOne));
            and.setStatements(this.falseStatements);
            Assert.assertFalse((String)"AND operator did not return false for a list of false statements", (boolean)and.getResult(this.context, this.itemOne));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the AND operator" + e.getMessage()));
        }
    }

    @Test
    public void testOrOperator() {
        Or or = new Or();
        try {
            or.setStatements(this.trueStatements);
            Assert.assertTrue((String)"OR operator did not return true for a list of true statements", (boolean)or.getResult(this.context, this.itemOne));
            or.setStatements(this.trueFalseStatements);
            Assert.assertTrue((String)"OR operator did not return true for a list of statements with at least one false", (boolean)or.getResult(this.context, this.itemOne));
            or.setStatements(this.falseStatements);
            Assert.assertFalse((String)"OR operator did not return false for a list of false statements", (boolean)or.getResult(this.context, this.itemOne));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the OR operator" + e.getMessage()));
        }
    }

    @Test
    public void testNandOperator() {
        Nand nand = new Nand();
        try {
            nand.setStatements(this.trueStatements);
            Assert.assertFalse((String)"NAND operator did not return false for a list of true statements", (boolean)nand.getResult(this.context, this.itemOne));
            nand.setStatements(this.trueFalseStatements);
            Assert.assertTrue((String)"NAND operator did not return true for a list of statements with at least one false", (boolean)nand.getResult(this.context, this.itemOne));
            nand.setStatements(this.falseStatements);
            Assert.assertTrue((String)"NAND operator did not return true for a list of false statements", (boolean)nand.getResult(this.context, this.itemOne));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the NAND operator" + e.getMessage()));
        }
    }

    @Test
    public void testNorOperator() {
        Nor nor = new Nor();
        try {
            nor.setStatements(this.trueStatements);
            Assert.assertFalse((String)"NOR operator did not return false for a list of true statements", (boolean)nor.getResult(this.context, this.itemOne));
            nor.setStatements(this.trueFalseStatements);
            Assert.assertFalse((String)"NOR operator did not return false for a list of statements with a true and a false", (boolean)nor.getResult(this.context, this.itemOne));
            nor.setStatements(this.falseStatements);
            Assert.assertTrue((String)"NOR operator did not return true for a list of false statements", (boolean)nor.getResult(this.context, this.itemOne));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the NOR operator" + e.getMessage()));
        }
    }

    @Test
    public void testNotOperator() {
        Not not = new Not();
        try {
            not.setStatements(this.trueStatementOne);
            Assert.assertFalse((String)"NOT operator did not return false for a true statement", (boolean)not.getResult(this.context, this.itemOne));
            not.setStatements(this.falseStatementOne);
            Assert.assertTrue((String)"NOT operator did not return true for a false statement", (boolean)not.getResult(this.context, this.itemOne));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the NOT operator" + e.getMessage()));
        }
    }

    @Test
    public void testMetadataValueMatchCondition() {
        try {
            MetadataValue metadataValueOne = this.metadataValueService.create(this.context, (DSpaceObject)this.itemOne, this.metadataField);
            MetadataValue metadataValueTwo = this.metadataValueService.create(this.context, (DSpaceObject)this.itemTwo, this.metadataField);
            metadataValueOne.setValue("TEST title should match the condition");
            metadataValueTwo.setValue("This title should not match the condition");
        }
        catch (SQLException e) {
            Assert.fail((String)("Encountered SQL error creating metadata value on item: " + e.getMessage()));
        }
        DefaultFilter filter = new DefaultFilter();
        MetadataValueMatchCondition condition = new MetadataValueMatchCondition();
        condition.setItemService(ContentServiceFactory.getInstance().getItemService());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("field", "dc.title");
        parameters.put("pattern", "^TEST");
        try {
            condition.setParameters(parameters);
            filter.setStatement((LogicalStatement)condition);
            Assert.assertTrue((String)"itemOne unexpectedly did not match the 'dc.title starts with TEST' test", (boolean)filter.getResult(this.context, this.itemOne));
            Assert.assertFalse((String)"itemTwo unexpectedly matched the 'dc.title starts with TEST' test", (boolean)filter.getResult(this.context, this.itemTwo));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the MetadataValueMatchCondition filter" + e.getMessage()));
        }
    }

    @Test
    public void testMetadataValuesMatchCondition() {
        try {
            MetadataValue metadataValueOne = this.metadataValueService.create(this.context, (DSpaceObject)this.itemOne, this.metadataField);
            MetadataValue metadataValueTwo = this.metadataValueService.create(this.context, (DSpaceObject)this.itemTwo, this.metadataField);
            MetadataValue metadataValueThree = this.metadataValueService.create(this.context, (DSpaceObject)this.itemThree, this.metadataField);
            metadataValueOne.setValue("TEST this title should match the condition");
            metadataValueTwo.setValue("This title should match the condition, yEs");
            metadataValueThree.setValue("This title should not match the condition");
        }
        catch (SQLException e) {
            Assert.fail((String)("Encountered SQL error creating metadata value on item: " + e.getMessage()));
        }
        DefaultFilter filter = new DefaultFilter();
        MetadataValuesMatchCondition condition = new MetadataValuesMatchCondition();
        condition.setItemService(ContentServiceFactory.getInstance().getItemService());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("field", "dc.title");
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("^TEST");
        patterns.add("(?i)yes$");
        parameters.put("patterns", patterns);
        HashMap<String, Object> missingParameters = new HashMap<String, Object>();
        missingParameters.put("field", "dc.subject");
        missingParameters.put("patterns", new ArrayList<String>().add("TEST"));
        try {
            condition.setParameters(parameters);
            filter.setStatement((LogicalStatement)condition);
            Assert.assertTrue((String)"itemOne unexpectedly did not match the 'dc.title starts with TEST or ends with yes' test", (boolean)filter.getResult(this.context, this.itemOne));
            Assert.assertTrue((String)"itemTwo unexpectedly did not match the 'dc.title starts with TEST or ends with yes' test", (boolean)filter.getResult(this.context, this.itemTwo));
            Assert.assertFalse((String)"itemThree unexpectedly matched the 'dc.title starts with TEST or ends with yes' test", (boolean)filter.getResult(this.context, this.itemThree));
            condition.setParameters(missingParameters);
            filter.setStatement((LogicalStatement)condition);
            Assert.assertFalse((String)"itemOne unexpectedly matched the 'dc.subject contains TEST' test(it has no dc.subject metadata value)", (boolean)filter.getResult(this.context, this.itemOne));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the MetadataValuesMatchCondition filter" + e.getMessage()));
        }
    }

    @Test
    public void testInCollectionCondition() {
        DefaultFilter filter = new DefaultFilter();
        InCollectionCondition condition = new InCollectionCondition();
        condition.setItemService(ContentServiceFactory.getInstance().getItemService());
        HashMap parameters = new HashMap();
        ArrayList<String> collections = new ArrayList<String>();
        collections.add(this.collectionOne.getHandle());
        parameters.put("collections", collections);
        try {
            condition.setParameters(parameters);
            filter.setStatement((LogicalStatement)condition);
            Assert.assertTrue((String)"itemOne unexpectedly did not match the 'item in collectionOne' test", (boolean)filter.getResult(this.context, this.itemOne));
            Assert.assertFalse((String)"itemTwo unexpectedly matched the 'item in collectionOne' test", (boolean)filter.getResult(this.context, this.itemTwo));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the InCollectionCondition filter" + e.getMessage()));
        }
    }

    @Test
    public void testInCommunityCondition() {
        DefaultFilter filter = new DefaultFilter();
        InCommunityCondition condition = new InCommunityCondition();
        condition.setItemService(ContentServiceFactory.getInstance().getItemService());
        HashMap parameters = new HashMap();
        ArrayList<String> communities = new ArrayList<String>();
        communities.add(this.communityOne.getHandle());
        parameters.put("communities", communities);
        try {
            condition.setParameters(parameters);
            filter.setStatement((LogicalStatement)condition);
            Assert.assertTrue((String)"itemOne unexpectedly did not match the 'item in communityOne' test", (boolean)filter.getResult(this.context, this.itemOne));
            Assert.assertFalse((String)"itemTwo unexpectedly matched the 'item in communityOne' test", (boolean)filter.getResult(this.context, this.itemTwo));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the InCommunityCondition filter" + e.getMessage()));
        }
    }

    @Test
    public void testIsWithdrawnCondition() {
        DefaultFilter filter = new DefaultFilter();
        IsWithdrawnCondition condition = new IsWithdrawnCondition();
        try {
            condition.setItemService(ContentServiceFactory.getInstance().getItemService());
            condition.setParameters(new HashMap());
            filter.setStatement((LogicalStatement)condition);
            Assert.assertFalse((String)"itemOne unexpectedly matched the 'item is withdrawn' test", (boolean)filter.getResult(this.context, this.itemOne));
            Assert.assertTrue((String)"itemTwo unexpectedly did NOT match the 'item is withdrawn' test", (boolean)filter.getResult(this.context, this.itemTwo));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the IsWithdrawnCondition filter" + e.getMessage()));
        }
    }

    @Test
    public void testBitstreamCountCondition() {
        DefaultFilter filter = new DefaultFilter();
        BitstreamCountCondition condition = new BitstreamCountCondition();
        try {
            condition.setItemService(ContentServiceFactory.getInstance().getItemService());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("bundle", "ORIGINAL");
            parameters.put("min", String.valueOf(1));
            parameters.put("max", String.valueOf(2));
            condition.setParameters(parameters);
            filter.setStatement((LogicalStatement)condition);
            Assert.assertFalse((String)"itemOne unexpectedly matched the '>=1 and <=2 ORIGINAL bitstreams' test (it has zero ORIGINAL bitstreams)", (boolean)filter.getResult(this.context, this.itemOne));
            Assert.assertTrue((String)"itemTwo unexpectedly did NOT match the '>=1 and <=2 ORIGINAL bitstreams' test (it has 2 ORIGINAL bitstreams)", (boolean)filter.getResult(this.context, this.itemTwo));
            Assert.assertFalse((String)"itemThree unexpectedly did NOT match the '>=1 and <=2 ORIGINAL bitstreams' test (it has 3 ORIGINAL bitstreams)", (boolean)filter.getResult(this.context, this.itemThree));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the IsWithdrawnCondition filter: " + e.getMessage()));
        }
    }

    @Test
    public void testReadableByGroupCondition() {
        DefaultFilter filter = new DefaultFilter();
        ReadableByGroupCondition condition = new ReadableByGroupCondition();
        try {
            condition.setItemService(ContentServiceFactory.getInstance().getItemService());
            try {
                this.context.turnOffAuthorisationSystem();
                Group g = this.groupService.create(this.context);
                this.groupService.setName(g, "Test Group");
                this.groupService.update(this.context, (DSpaceObject)g);
                this.authorizeService.addPolicy(this.context, (DSpaceObject)this.itemOne, 0, g);
                this.context.restoreAuthSystemState();
            }
            catch (SQLException | AuthorizeException e) {
                Assert.fail((String)("Exception thrown adding group READ policy to item: " + this.itemOne + ": " + e.getMessage()));
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("group", "Test Group");
            parameters.put("action", "READ");
            condition.setParameters(parameters);
            filter.setStatement((LogicalStatement)condition);
            Assert.assertTrue((String)"itemOne unexpectedly did not match the 'is readable by Test Group' test", (boolean)filter.getResult(this.context, this.itemOne));
            Assert.assertFalse((String)"itemTwo unexpectedly matched the 'is readable by Test Group' test", (boolean)filter.getResult(this.context, this.itemTwo));
        }
        catch (LogicalStatementException e) {
            log.error(e.getMessage());
            Assert.fail((String)("LogicalStatementException thrown testing the ReadableByGroup filter" + e.getMessage()));
        }
    }

    private void setUpStatements() {
        this.trueStatementOne = (context, item) -> true;
        LogicalStatement trueStatementTwo = (context, item) -> true;
        this.falseStatementOne = (context, item) -> false;
        LogicalStatement falseStatementTwo = (context, item) -> false;
        this.trueStatements = new ArrayList<LogicalStatement>();
        this.trueStatements.add(this.trueStatementOne);
        this.trueStatements.add(trueStatementTwo);
        this.trueFalseStatements = new ArrayList<LogicalStatement>();
        this.trueFalseStatements.add(this.trueStatementOne);
        this.trueFalseStatements.add(this.falseStatementOne);
        this.falseStatements = new ArrayList<LogicalStatement>();
        this.falseStatements.add(this.falseStatementOne);
        this.falseStatements.add(falseStatementTwo);
    }
}

