/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import org.apache.solr.common.SolrInputDocument;
import org.dspace.AbstractUnitTest;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.discovery.indexobject.IndexableMetadataField;
import org.dspace.discovery.indexobject.MetadataFieldIndexFactoryImpl;
import org.junit.Assert;
import org.junit.Test;

public class MetadataFieldIndexFactoryImplTest
extends AbstractUnitTest {
    private MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    private MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private String schemaName = "schema1";
    private String elemName1 = "elem1";
    private String elemName2 = "elem2";
    private String qualName1 = "qual1";
    private MetadataSchema schema;
    private MetadataField field1;
    private MetadataField field2;

    @Test
    public void test_buildDocument_withQualifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.schema = this.metadataSchemaService.create(this.context, this.schemaName, "htpp://test/schema/");
        this.field1 = this.metadataFieldService.create(this.context, this.schema, this.elemName1, this.qualName1, "note 1");
        MetadataFieldIndexFactoryImpl fieldIndexFactory = new MetadataFieldIndexFactoryImpl();
        IndexableMetadataField indexableMetadataField = new IndexableMetadataField(this.field1);
        SolrInputDocument solrInputDocument = fieldIndexFactory.buildDocument(this.context, indexableMetadataField);
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("schema_keyword").contains(this.field1.getMetadataSchema().getName()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("element_keyword").contains(this.field1.getElement()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("qualifier_keyword").contains(this.field1.getQualifier()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("fieldName_keyword").contains(this.field1.getQualifier()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("fieldName_keyword").contains(this.field1.getElement() + "." + this.field1.getQualifier()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("fieldName_keyword").contains(this.field1.toString('.')));
        this.metadataSchemaService.delete(this.context, this.schema);
        this.metadataFieldService.delete(this.context, this.field1);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void test_buildDocument_noQualifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.schema = this.metadataSchemaService.create(this.context, this.schemaName, "htpp://test/schema/");
        this.field2 = this.metadataFieldService.create(this.context, this.schema, this.elemName2, null, "note 2");
        MetadataFieldIndexFactoryImpl fieldIndexFactory = new MetadataFieldIndexFactoryImpl();
        IndexableMetadataField indexableMetadataField = new IndexableMetadataField(this.field2);
        SolrInputDocument solrInputDocument = fieldIndexFactory.buildDocument(this.context, indexableMetadataField);
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("schema_keyword").contains(this.field2.getMetadataSchema().getName()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("element_keyword").contains(this.field2.getElement()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("fieldName_keyword").contains(this.field2.getElement()));
        Assert.assertTrue((boolean)solrInputDocument.getFieldValues("fieldName_keyword").contains(this.field2.toString('.')));
        this.metadataSchemaService.delete(this.context, this.schema);
        this.metadataFieldService.delete(this.context, this.field2);
        this.context.restoreAuthSystemState();
    }
}

