/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.SubscribeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.SubscriptionParameter;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.matcher.SubscribeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SubscribeServiceIT
extends AbstractIntegrationTestWithDatabase {
    private final SubscribeService subscribeService = ContentServiceFactory.getInstance().getSubscribeService();
    private Collection firstCollection;
    private Collection secondCollection;

    @Before
    public void init() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parentCommunity = CommunityBuilder.createCommunity(this.context).build();
        this.firstCollection = CollectionBuilder.createCollection(this.context, parentCommunity).withName("First Collection").build();
        this.secondCollection = CollectionBuilder.createCollection(this.context, parentCommunity).withName("Second Collection").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllWithoutAndWithLimit() throws Exception {
        String resourceType = "Collection";
        EPerson subscribingUser = this.context.getCurrentUser();
        this.createSubscription("content", (DSpaceObject)this.firstCollection, subscribingUser, SubscribeServiceIT.weekly());
        this.createSubscription("content", (DSpaceObject)this.secondCollection, subscribingUser, SubscribeServiceIT.daily(), SubscribeServiceIT.annual());
        List subscriptions = this.subscribeService.findAll(this.context, resourceType, Integer.valueOf(10), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)subscriptions, (Matcher)Matchers.containsInAnyOrder(Arrays.asList(new Matcher[]{SubscribeMatcher.matches((DSpaceObject)this.firstCollection, subscribingUser, "content", Collections.singletonList(SubscribeServiceIT.weekly())), SubscribeMatcher.matches((DSpaceObject)this.secondCollection, subscribingUser, "content", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.annual()))})));
        subscriptions = this.subscribeService.findAll(this.context, resourceType, Integer.valueOf(1), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)subscriptions, (Matcher)Matchers.containsInAnyOrder(Collections.singletonList(SubscribeMatcher.matches((DSpaceObject)this.firstCollection, subscribingUser, "content", Collections.singletonList(SubscribeServiceIT.weekly())))));
        subscriptions = this.subscribeService.findAll(this.context, resourceType, Integer.valueOf(100), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)subscriptions, (Matcher)Matchers.containsInAnyOrder(Collections.singletonList(SubscribeMatcher.matches((DSpaceObject)this.secondCollection, subscribingUser, "content", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.annual())))));
        subscriptions = this.subscribeService.findAll(this.context, "", Integer.valueOf(100), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)subscriptions, (Matcher)Matchers.containsInAnyOrder(Arrays.asList(new Matcher[]{SubscribeMatcher.matches((DSpaceObject)this.firstCollection, subscribingUser, "content", Collections.singletonList(SubscribeServiceIT.weekly())), SubscribeMatcher.matches((DSpaceObject)this.secondCollection, subscribingUser, "content", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.annual()))})));
    }

    private static SubscriptionParameter annual() {
        return SubscribeServiceIT.createSubscriptionParameter("frequency", "A");
    }

    private static SubscriptionParameter daily() {
        return SubscribeServiceIT.createSubscriptionParameter("frequency", "D");
    }

    @Test(expected=Exception.class)
    public void findAllWithInvalidResource() throws Exception {
        String resourceType = "INVALID";
        Integer limit = 10;
        Integer offset = 0;
        this.createSubscription("content", (DSpaceObject)this.firstCollection, this.context.getCurrentUser(), SubscribeServiceIT.weekly());
        this.subscribeService.findAll(this.context, resourceType, limit, offset);
    }

    @Test
    public void newSubscriptionCreatedByAdmin() throws Exception {
        SubscriptionParameter monthly = SubscribeServiceIT.createSubscriptionParameter("frequency", "M");
        List<SubscriptionParameter> parameters = Collections.singletonList(monthly);
        EPerson currentUser = this.context.getCurrentUser();
        this.context.setCurrentUser(this.admin);
        Subscription subscription = this.subscribeService.subscribe(this.context, this.eperson, (DSpaceObject)this.firstCollection, parameters, "content");
        MatcherAssert.assertThat((Object)subscription, (Matcher)Matchers.is((Matcher)SubscribeMatcher.matches((DSpaceObject)this.firstCollection, this.eperson, "content", Collections.singletonList(monthly))));
        SubscribeBuilder.deleteSubscription(subscription.getID());
        this.context.setCurrentUser(currentUser);
    }

    @Test
    public void newSubscriptionCreatedByCurrentUser() throws Exception {
        EPerson currentUser = this.context.getCurrentUser();
        Subscription subscription = this.subscribeService.subscribe(this.context, currentUser, (DSpaceObject)this.secondCollection, Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.weekly()), "content");
        MatcherAssert.assertThat((Object)subscription, (Matcher)SubscribeMatcher.matches((DSpaceObject)this.secondCollection, currentUser, "content", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.weekly())));
        SubscribeBuilder.deleteSubscription(subscription.getID());
    }

    @Test(expected=AuthorizeException.class)
    public void nonAdminDifferentUserTriesToSubscribe() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson notAdmin = EPersonBuilder.createEPerson(this.context).withEmail("not-admin@example.com").build();
        this.context.restoreAuthSystemState();
        EPerson currentUser = this.context.getCurrentUser();
        this.context.setCurrentUser(notAdmin);
        try {
            this.subscribeService.subscribe(this.context, this.admin, (DSpaceObject)this.firstCollection, Collections.singletonList(SubscribeServiceIT.daily()), "content");
        }
        finally {
            this.context.setCurrentUser(currentUser);
        }
    }

    @Test
    public void unsubscribeByAdmin() throws Exception {
        EPerson subscribingUser = this.context.getCurrentUser();
        this.createSubscription("content", (DSpaceObject)this.secondCollection, subscribingUser, SubscribeServiceIT.weekly());
        List subscriptions = this.subscribeService.findSubscriptionsByEPersonAndDso(this.context, subscribingUser, (DSpaceObject)this.secondCollection, Integer.valueOf(100), Integer.valueOf(0));
        Assert.assertEquals((long)subscriptions.size(), (long)1L);
        this.context.setCurrentUser(this.admin);
        this.subscribeService.unsubscribe(this.context, subscribingUser, (DSpaceObject)this.secondCollection);
        this.context.setCurrentUser(subscribingUser);
        subscriptions = this.subscribeService.findSubscriptionsByEPersonAndDso(this.context, subscribingUser, (DSpaceObject)this.secondCollection, Integer.valueOf(100), Integer.valueOf(0));
        Assert.assertEquals((long)subscriptions.size(), (long)0L);
    }

    @Test
    public void subscribingUserUnsubscribesTheirSubscription() throws Exception {
        EPerson subscribingUser = this.context.getCurrentUser();
        this.createSubscription("content", (DSpaceObject)this.secondCollection, subscribingUser, SubscribeServiceIT.weekly());
        List subscriptions = this.subscribeService.findSubscriptionsByEPersonAndDso(this.context, subscribingUser, (DSpaceObject)this.secondCollection, Integer.valueOf(100), Integer.valueOf(0));
        Assert.assertEquals((long)subscriptions.size(), (long)1L);
        MatcherAssert.assertThat((Object)this.subscribeService.isSubscribed(this.context, subscribingUser, (DSpaceObject)this.secondCollection), (Matcher)Matchers.is((Object)true));
        this.subscribeService.unsubscribe(this.context, subscribingUser, (DSpaceObject)this.secondCollection);
        subscriptions = this.subscribeService.findSubscriptionsByEPersonAndDso(this.context, subscribingUser, (DSpaceObject)this.secondCollection, Integer.valueOf(100), Integer.valueOf(0));
        Assert.assertEquals((long)subscriptions.size(), (long)0L);
        MatcherAssert.assertThat((Object)this.subscribeService.isSubscribed(this.context, subscribingUser, (DSpaceObject)this.secondCollection), (Matcher)Matchers.is((Object)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=AuthorizeException.class)
    public void nonAdminDifferentUserTriesToUnSubscribeAnotherUser() throws Exception {
        EPerson subscribingUser = this.context.getCurrentUser();
        Subscription subscription = this.createSubscription("content", (DSpaceObject)this.secondCollection, subscribingUser, SubscribeServiceIT.weekly());
        this.context.turnOffAuthorisationSystem();
        EPerson nonAdmin = EPersonBuilder.createEPerson(this.context).build();
        this.context.restoreAuthSystemState();
        try {
            this.context.setCurrentUser(nonAdmin);
            this.subscribeService.unsubscribe(this.context, subscribingUser, (DSpaceObject)this.secondCollection);
        }
        finally {
            this.context.setCurrentUser(subscribingUser);
            SubscribeBuilder.deleteSubscription(subscription.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateSubscription() throws Exception {
        EPerson currentUser = this.context.getCurrentUser();
        Subscription subscription = this.createSubscription("original", (DSpaceObject)this.firstCollection, currentUser, SubscribeServiceIT.createSubscriptionParameter("frequency", "M"));
        String updatedType = "updated";
        List<SubscriptionParameter> updatedParameters = Collections.singletonList(SubscribeServiceIT.annual());
        try {
            Subscription updated = this.subscribeService.updateSubscription(this.context, subscription.getID(), updatedType, updatedParameters);
            MatcherAssert.assertThat((Object)updated, (Matcher)Matchers.is((Matcher)SubscribeMatcher.matches((DSpaceObject)this.firstCollection, currentUser, updatedType, updatedParameters)));
            List subscriptions = this.subscribeService.findSubscriptionsByEPersonAndDso(this.context, currentUser, (DSpaceObject)this.firstCollection, Integer.valueOf(10), Integer.valueOf(0));
            MatcherAssert.assertThat((Object)subscriptions, (Matcher)Matchers.contains((Matcher)SubscribeMatcher.matches((DSpaceObject)this.firstCollection, currentUser, updatedType, updatedParameters)));
        }
        finally {
            SubscribeBuilder.deleteSubscription(subscription.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void parametersAdditionAndRemoval() throws Exception {
        SubscriptionParameter firstParameter = SubscribeServiceIT.createSubscriptionParameter("key1", "value1");
        SubscriptionParameter secondParameter = SubscribeServiceIT.createSubscriptionParameter("key2", "value2");
        EPerson currentUser = this.context.getCurrentUser();
        Subscription subscription = this.createSubscription("type", (DSpaceObject)this.secondCollection, currentUser, firstParameter, secondParameter);
        int subscriptionId = subscription.getID();
        SubscriptionParameter addedParameter = SubscribeServiceIT.createSubscriptionParameter("added", "add");
        try {
            Subscription updatedSubscription = this.subscribeService.addSubscriptionParameter(this.context, Integer.valueOf(subscriptionId), addedParameter);
            MatcherAssert.assertThat((Object)updatedSubscription, (Matcher)Matchers.is((Matcher)SubscribeMatcher.matches((DSpaceObject)this.secondCollection, currentUser, "type", Arrays.asList(firstParameter, secondParameter, addedParameter))));
            updatedSubscription = this.subscribeService.removeSubscriptionParameter(this.context, Integer.valueOf(subscriptionId), secondParameter);
            MatcherAssert.assertThat((Object)updatedSubscription, (Matcher)Matchers.is((Matcher)SubscribeMatcher.matches((DSpaceObject)this.secondCollection, currentUser, "type", Arrays.asList(firstParameter, addedParameter))));
        }
        finally {
            SubscribeBuilder.deleteSubscription(subscriptionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findersAndDeletionsTest() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        EPerson firstSubscriber = EPersonBuilder.createEPerson(this.context).withEmail("first-user@example.com").build();
        EPerson secondSubscriber = EPersonBuilder.createEPerson(this.context).withEmail("second-user@example.com").build();
        EPerson thirdSubscriber = EPersonBuilder.createEPerson(this.context).withEmail("third-user@example.com").build();
        this.context.restoreAuthSystemState();
        EPerson currentUser = this.context.getCurrentUser();
        try {
            this.context.setCurrentUser(firstSubscriber);
            this.createSubscription("type1", (DSpaceObject)this.firstCollection, firstSubscriber, SubscribeServiceIT.daily(), SubscribeServiceIT.weekly());
            this.createSubscription("type1", (DSpaceObject)this.secondCollection, firstSubscriber, SubscribeServiceIT.daily(), SubscribeServiceIT.annual());
            this.createSubscription("type2", (DSpaceObject)this.secondCollection, firstSubscriber, SubscribeServiceIT.daily());
            this.context.setCurrentUser(secondSubscriber);
            this.createSubscription("type1", (DSpaceObject)this.firstCollection, secondSubscriber, SubscribeServiceIT.daily());
            this.createSubscription("type1", (DSpaceObject)this.secondCollection, secondSubscriber, SubscribeServiceIT.daily(), SubscribeServiceIT.annual());
            this.context.setCurrentUser(thirdSubscriber);
            this.createSubscription("type1", (DSpaceObject)this.firstCollection, thirdSubscriber, SubscribeServiceIT.daily());
            this.createSubscription("type1", (DSpaceObject)this.secondCollection, thirdSubscriber, SubscribeServiceIT.daily(), SubscribeServiceIT.annual());
        }
        finally {
            this.context.setCurrentUser(currentUser);
        }
        List firstUserSubscriptions = this.subscribeService.findSubscriptionsByEPerson(this.context, firstSubscriber, Integer.valueOf(100), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)firstUserSubscriptions, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubscribeMatcher.matches((DSpaceObject)this.firstCollection, firstSubscriber, "type1", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.weekly())), SubscribeMatcher.matches((DSpaceObject)this.secondCollection, firstSubscriber, "type1", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.annual())), SubscribeMatcher.matches((DSpaceObject)this.secondCollection, firstSubscriber, "type2", Collections.singletonList(SubscribeServiceIT.daily()))}));
        List firstUserSubscriptionsLimited = this.subscribeService.findSubscriptionsByEPerson(this.context, firstSubscriber, Integer.valueOf(1), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)firstUserSubscriptionsLimited.size(), (Matcher)Matchers.is((Object)1));
        List firstUserSubscriptionsWithOffset = this.subscribeService.findSubscriptionsByEPerson(this.context, firstSubscriber, Integer.valueOf(100), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)firstUserSubscriptionsWithOffset.size(), (Matcher)Matchers.is((Object)2));
        this.subscribeService.deleteByEPerson(this.context, firstSubscriber);
        MatcherAssert.assertThat((Object)this.subscribeService.findSubscriptionsByEPerson(this.context, firstSubscriber, Integer.valueOf(100), Integer.valueOf(0)), (Matcher)Matchers.is(List.of()));
        List secondSubscriberSecondCollectionSubscriptions = this.subscribeService.findSubscriptionsByEPersonAndDso(this.context, secondSubscriber, (DSpaceObject)this.firstCollection, Integer.valueOf(10), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)secondSubscriberSecondCollectionSubscriptions, (Matcher)Matchers.contains((Matcher)SubscribeMatcher.matches((DSpaceObject)this.firstCollection, secondSubscriber, "type1", Collections.singletonList(SubscribeServiceIT.daily()))));
        List byTypeAndFrequency = this.subscribeService.findAllSubscriptionsBySubscriptionTypeAndFrequency(this.context, "type1", "D");
        MatcherAssert.assertThat((Object)byTypeAndFrequency, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubscribeMatcher.matches((DSpaceObject)this.firstCollection, secondSubscriber, "type1", Collections.singletonList(SubscribeServiceIT.daily())), SubscribeMatcher.matches((DSpaceObject)this.secondCollection, secondSubscriber, "type1", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.annual())), SubscribeMatcher.matches((DSpaceObject)this.firstCollection, thirdSubscriber, "type1", Collections.singletonList(SubscribeServiceIT.daily())), SubscribeMatcher.matches((DSpaceObject)this.secondCollection, thirdSubscriber, "type1", Arrays.asList(SubscribeServiceIT.daily(), SubscribeServiceIT.annual()))}));
        MatcherAssert.assertThat((Object)this.subscribeService.countAll(this.context), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)this.subscribeService.countByEPersonAndDSO(this.context, secondSubscriber, (DSpaceObject)this.secondCollection), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)this.subscribeService.countSubscriptionsByEPerson(this.context, thirdSubscriber), (Matcher)Matchers.is((Object)2L));
    }

    private static SubscriptionParameter weekly() {
        return SubscribeServiceIT.createSubscriptionParameter("frequency", "W");
    }

    private Subscription createSubscription(String type, DSpaceObject dso, EPerson ePerson, SubscriptionParameter ... parameters) {
        return SubscribeBuilder.subscribeBuilder(this.context, type, dso, ePerson, Arrays.stream(parameters).collect(Collectors.toList())).build();
    }

    private static SubscriptionParameter createSubscriptionParameter(String name, String value) {
        SubscriptionParameter parameter = new SubscriptionParameter();
        parameter.setName(name);
        parameter.setValue(value);
        return parameter;
    }
}

