/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.InputStream;
import java.util.List;
import org.dspace.AbstractDSpaceTest;
import org.dspace.external.OrcidRestConnector;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.impl.OrcidV3AuthorDataProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.AllOf;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class OrcidV3AuthorDataProviderTest
extends AbstractDSpaceTest {
    private static final String SEARCH_XML_PATH = "org/dspace/external/provider/orcid-v3-author/search.xml";
    private static final String PERSON1_XML_PATH = "org/dspace/external/provider/orcid-v3-author/person1.xml";
    private static final String PERSON2_XML_PATH = "org/dspace/external/provider/orcid-v3-author/person2.xml";
    private static final String PERSON3_XML_PATH = "org/dspace/external/provider/orcid-v3-author/person3.xml";
    public static final String ORCID_SEARCH_QUERY = "search?q=0000-0000-0000-0000";
    private OrcidV3AuthorDataProvider dataProvider;

    @Before
    public void setup() throws Exception {
        this.dataProvider = new OrcidV3AuthorDataProvider();
        OrcidRestConnector mockRestConnector = (OrcidRestConnector)Mockito.mock(OrcidRestConnector.class);
        this.dataProvider.setOrcidRestConnector(mockRestConnector);
        this.dataProvider.setSourceIdentifier("orcid");
        this.dataProvider.setOrcidUrl("https://orcid.org");
        this.dataProvider.setClientId("client-id");
        this.dataProvider.setClientSecret("client-secret");
        this.dataProvider.setOAUTHUrl("https://orcid.org/oauth");
        InputStream searchXmlStream = this.getClass().getClassLoader().getResourceAsStream(SEARCH_XML_PATH);
        InputStream person1XmlStream = this.getClass().getClassLoader().getResourceAsStream(PERSON1_XML_PATH);
        InputStream person2XmlStream = this.getClass().getClassLoader().getResourceAsStream(PERSON2_XML_PATH);
        InputStream person3XmlStream = this.getClass().getClassLoader().getResourceAsStream(PERSON3_XML_PATH);
        Mockito.when((Object)mockRestConnector.get("search?q=search%3Fq%3D0000-0000-0000-0000&start=0&rows=10", null)).thenReturn((Object)searchXmlStream);
        Mockito.when((Object)mockRestConnector.get("0000-0000-0000-0001/person", null)).thenReturn((Object)person1XmlStream);
        Mockito.when((Object)mockRestConnector.get("0000-0000-0000-0002/person", null)).thenReturn((Object)person2XmlStream);
        Mockito.when((Object)mockRestConnector.get("0000-0000-0000-0003/person", null)).thenReturn((Object)person3XmlStream);
    }

    @Test
    public void testGetExternalDataObjectSizeIsCorrect() {
        List optional = this.dataProvider.searchExternalDataObjects(ORCID_SEARCH_QUERY, 0, 10);
        MatcherAssert.assertThat((Object)optional, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    public void testGetExternalDataObjectGetPersonWithAllFieldsPopulated() {
        List optional = this.dataProvider.searchExternalDataObjects(ORCID_SEARCH_QUERY, 0, 10);
        MatcherAssert.assertThat((Object)optional, (Matcher)IsCollectionWithSize.hasSize((int)3));
        ExternalDataObject externalDataObject1 = (ExternalDataObject)optional.get(0);
        MatcherAssert.assertThat((Object)externalDataObject1.getId(), (Matcher)CoreMatchers.equalTo((Object)"0000-0000-0000-0001"));
        MatcherAssert.assertThat((Object)externalDataObject1.getValue(), (Matcher)CoreMatchers.equalTo((Object)"FamilyName1, GivenNames1"));
        MatcherAssert.assertThat((Object)externalDataObject1.getSource(), (Matcher)CoreMatchers.equalTo((Object)"orcid"));
        MatcherAssert.assertThat((Object)externalDataObject1.getDisplayValue(), (Matcher)CoreMatchers.equalTo((Object)"FamilyName1, GivenNames1"));
        MatcherAssert.assertThat((Object)externalDataObject1.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"familyName")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"FamilyName1"))})));
        MatcherAssert.assertThat((Object)externalDataObject1.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"givenName")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"GivenNames1"))})));
        MatcherAssert.assertThat((Object)externalDataObject1.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"email")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"person1@email.com"))})));
        MatcherAssert.assertThat((Object)externalDataObject1.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"identifier")), HasPropertyWithValue.hasProperty((String)"qualifier", (Matcher)CoreMatchers.equalTo((Object)"orcid")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"0000-0000-0000-0001"))})));
        MatcherAssert.assertThat((Object)externalDataObject1.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"dc")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"identifier")), HasPropertyWithValue.hasProperty((String)"qualifier", (Matcher)CoreMatchers.equalTo((Object)"uri")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"https://orcid.org/0000-0000-0000-0001"))})));
    }

    @Test
    public void testGetExternalDataObjectGetPrimaryEmailFromPersonWithTwoEmails() {
        List optional = this.dataProvider.searchExternalDataObjects(ORCID_SEARCH_QUERY, 0, 10);
        MatcherAssert.assertThat((Object)optional, (Matcher)IsCollectionWithSize.hasSize((int)3));
        ExternalDataObject externalDataObject2 = (ExternalDataObject)optional.get(1);
        MatcherAssert.assertThat((Object)externalDataObject2.getId(), (Matcher)CoreMatchers.equalTo((Object)"0000-0000-0000-0002"));
        MatcherAssert.assertThat((Object)externalDataObject2.getValue(), (Matcher)CoreMatchers.equalTo((Object)"FamilyName2, GivenNames2"));
        MatcherAssert.assertThat((Object)externalDataObject2.getSource(), (Matcher)CoreMatchers.equalTo((Object)"orcid"));
        MatcherAssert.assertThat((Object)externalDataObject2.getDisplayValue(), (Matcher)CoreMatchers.equalTo((Object)"FamilyName2, GivenNames2"));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"familyName")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"FamilyName2"))})));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"givenName")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"GivenNames2"))})));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"email")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"person2primary@email.com"))})));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"identifier")), HasPropertyWithValue.hasProperty((String)"qualifier", (Matcher)CoreMatchers.equalTo((Object)"orcid")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"0000-0000-0000-0002"))})));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"dc")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"identifier")), HasPropertyWithValue.hasProperty((String)"qualifier", (Matcher)CoreMatchers.equalTo((Object)"uri")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"https://orcid.org/0000-0000-0000-0002"))})));
    }

    @Test
    public void testGetExternalDataObjectGetPersonOnlyWithNameFilled() {
        List optional = this.dataProvider.searchExternalDataObjects(ORCID_SEARCH_QUERY, 0, 10);
        MatcherAssert.assertThat((Object)optional, (Matcher)IsCollectionWithSize.hasSize((int)3));
        ExternalDataObject externalDataObject2 = (ExternalDataObject)optional.get(2);
        MatcherAssert.assertThat((Object)externalDataObject2.getId(), (Matcher)CoreMatchers.equalTo((Object)"0000-0000-0000-0003"));
        MatcherAssert.assertThat((Object)externalDataObject2.getValue(), (Matcher)CoreMatchers.equalTo((Object)"FamilyName3, GivenNames3"));
        MatcherAssert.assertThat((Object)externalDataObject2.getSource(), (Matcher)CoreMatchers.equalTo((Object)"orcid"));
        MatcherAssert.assertThat((Object)externalDataObject2.getDisplayValue(), (Matcher)CoreMatchers.equalTo((Object)"FamilyName3, GivenNames3"));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"familyName")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"FamilyName3"))})));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"givenName")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"GivenNames3"))})));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"person")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"identifier")), HasPropertyWithValue.hasProperty((String)"qualifier", (Matcher)CoreMatchers.equalTo((Object)"orcid")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"0000-0000-0000-0003"))})));
        MatcherAssert.assertThat((Object)externalDataObject2.getMetadata(), (Matcher)CoreMatchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"schema", (Matcher)CoreMatchers.equalTo((Object)"dc")), HasPropertyWithValue.hasProperty((String)"element", (Matcher)CoreMatchers.equalTo((Object)"identifier")), HasPropertyWithValue.hasProperty((String)"qualifier", (Matcher)CoreMatchers.equalTo((Object)"uri")), HasPropertyWithValue.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"https://orcid.org/0000-0000-0000-0003"))})));
    }
}

