/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google.client;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.google.client.UniversalAnalyticsClientRequestBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UniversalAnalyticsClientRequestBuilderTest {
    private UniversalAnalyticsClientRequestBuilder requestBuilder;

    @Before
    public void setup() {
        this.requestBuilder = new UniversalAnalyticsClientRequestBuilder("https://google-analytics/test");
    }

    @Test
    public void testGetEndpointUrl() {
        String endpointUrl = this.requestBuilder.getEndpointUrl("UA-12345");
        MatcherAssert.assertThat((Object)endpointUrl, (Matcher)Matchers.is((Object)"https://google-analytics/test"));
    }

    @Test
    public void testComposeRequestBodiesWithoutEvents() {
        List requestsBody = this.requestBuilder.composeRequestsBody("UA-12345", List.of());
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.empty());
    }

    @Test
    public void testComposeRequestBodiesWithNotSupportedKey() {
        GoogleAnalyticsEvent event = this.buildEvent("123", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        Assert.assertThrows((String)"Only keys with G- prefix are supported", IllegalArgumentException.class, () -> this.requestBuilder.composeRequestsBody("G-12345", List.of(event)));
    }

    @Test
    public void testComposeRequestBodiesWithSingleEvent() {
        GoogleAnalyticsEvent event = this.buildEvent("123", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        List requestsBody = this.requestBuilder.composeRequestsBody("UA-12345", List.of(event));
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.hasSize((int)1));
        String requestBody = (String)requestsBody.get(0);
        MatcherAssert.assertThat((Object)StringUtils.countMatches((String)requestBody, (String)"&qt="), (Matcher)Matchers.is((Object)1));
        String requestBodyWithoutTime = this.removeAllTimeSections(requestBody);
        String expectedRequestBodyWithoutTime = "v=1&tid=UA-12345&cid=123&t=event&uip=192.168.1.25&ua=Chrome&dr=REF&dp=%2Fapi%2Fdocuments%2F123&dt=Test+publication&ec=bitstream&ea=download&el=item";
        MatcherAssert.assertThat((Object)requestBodyWithoutTime, (Matcher)Matchers.is((Object)expectedRequestBodyWithoutTime));
    }

    @Test
    public void testComposeRequestBodiesWithManyEventsWithSameClientId() {
        GoogleAnalyticsEvent event1 = this.buildEvent("123", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        GoogleAnalyticsEvent event2 = this.buildEvent("123", "192.168.1.25", "Mozilla Firefox", "REF-2", "/api/documents/12345", "Test publication 2");
        List requestsBody = this.requestBuilder.composeRequestsBody("UA-12345", List.of(event1, event2));
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.hasSize((int)1));
        String requestBody = (String)requestsBody.get(0);
        MatcherAssert.assertThat((Object)StringUtils.countMatches((String)requestBody, (String)"&qt="), (Matcher)Matchers.is((Object)2));
        String requestBodyWithoutTime = this.removeAllTimeSections(requestBody);
        String expectedRequestBodyWithoutTime = "v=1&tid=UA-12345&cid=123&t=event&uip=192.168.1.25&ua=Chrome&dr=REF&dp=%2Fapi%2Fdocuments%2F123&dt=Test+publication&ec=bitstream&ea=download&el=item\nv=1&tid=UA-12345&cid=123&t=event&uip=192.168.1.25&ua=Mozilla+Firefox&dr=REF-2&dp=%2Fapi%2Fdocuments%2F12345&dt=Test+publication+2&ec=bitstream&ea=download&el=item";
        MatcherAssert.assertThat((Object)requestBodyWithoutTime, (Matcher)Matchers.is((Object)expectedRequestBodyWithoutTime));
    }

    @Test
    public void testComposeRequestBodiesWithManyEventsWithDifferentClientId() {
        GoogleAnalyticsEvent event1 = this.buildEvent("123", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        GoogleAnalyticsEvent event2 = this.buildEvent("123", "192.168.1.25", "Mozilla Firefox", "REF-2", "/api/documents/12345", "Test publication 2");
        GoogleAnalyticsEvent event3 = this.buildEvent("987", "192.168.1.13", "Postman", null, "/api/documents/654", "Test publication 3");
        List requestsBody = this.requestBuilder.composeRequestsBody("UA-12345", List.of(event1, event2, event3));
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.hasSize((int)1));
        String requestBody = (String)requestsBody.get(0);
        MatcherAssert.assertThat((Object)StringUtils.countMatches((String)requestBody, (String)"&qt="), (Matcher)Matchers.is((Object)3));
        String requestBodyWithoutTime = this.removeAllTimeSections(requestBody);
        String expectedRequestBodyWithoutTime = "v=1&tid=UA-12345&cid=123&t=event&uip=192.168.1.25&ua=Chrome&dr=REF&dp=%2Fapi%2Fdocuments%2F123&dt=Test+publication&ec=bitstream&ea=download&el=item\nv=1&tid=UA-12345&cid=123&t=event&uip=192.168.1.25&ua=Mozilla+Firefox&dr=REF-2&dp=%2Fapi%2Fdocuments%2F12345&dt=Test+publication+2&ec=bitstream&ea=download&el=item\nv=1&tid=UA-12345&cid=987&t=event&uip=192.168.1.13&ua=Postman&dr=&dp=%2Fapi%2Fdocuments%2F654&dt=Test+publication+3&ec=bitstream&ea=download&el=item";
        MatcherAssert.assertThat((Object)requestBodyWithoutTime, (Matcher)Matchers.is((Object)expectedRequestBodyWithoutTime));
    }

    private String removeAllTimeSections(String requestBody) {
        return requestBody.replaceAll("&qt=\\d+", "");
    }

    private GoogleAnalyticsEvent buildEvent(String clientId, String userIp, String userAgent, String documentReferrer, String documentPath, String documentTitle) {
        return new GoogleAnalyticsEvent(clientId, userIp, userAgent, documentReferrer, documentPath, documentTitle);
    }
}

