/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import org.dspace.AbstractUnitTest;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HandleServiceTest
extends AbstractUnitTest {
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected ConfigurationService configurationService = new DSpace().getConfigurationService();

    @Override
    @Before
    public void init() {
        super.init();
        this.configurationService.setProperty("handle.prefix", (Object)"123456789");
        this.configurationService.setProperty("handle.canonical.prefix", (Object)"https://fake.canonical.prefix");
        this.configurationService.setProperty("handle.additional.prefixes", (Object)"987654321, 654321987");
    }

    @Test
    public void testParseHandleInvalid() {
        Assert.assertNull((Object)this.handleService.parseHandle(null));
        Assert.assertNull((Object)this.handleService.parseHandle("123456789"));
        Assert.assertNull((Object)this.handleService.parseHandle("/123456789"));
        Assert.assertNull((Object)this.handleService.parseHandle("https://duraspace.org/dspace/"));
        Assert.assertNull((Object)this.handleService.parseHandle("10.70131/test_doi_5d2be995d35b6"));
        Assert.assertNull((Object)this.handleService.parseHandle("not a handle"));
    }

    @Test
    public void testParseHandleByPrefix() {
        Assert.assertEquals((Object)"123456789/111", (Object)this.handleService.parseHandle("123456789/111"));
    }

    @Test
    public void testParseHandleByCanonicalPrefix() {
        Assert.assertEquals((Object)"111222333/111", (Object)this.handleService.parseHandle("https://fake.canonical.prefix/111222333/111"));
    }

    @Test
    public void testParseHandleByAdditionalPrefix() {
        Assert.assertEquals((Object)"987654321/111", (Object)this.handleService.parseHandle("987654321/111"));
        Assert.assertEquals((Object)"654321987/111", (Object)this.handleService.parseHandle("654321987/111"));
    }

    @Test
    public void testParseHandleByPattern() {
        Assert.assertEquals((Object)"111222333/111", (Object)this.handleService.parseHandle("hdl:111222333/111"));
        Assert.assertEquals((Object)"111222333/111", (Object)this.handleService.parseHandle("info:hdl/111222333/111"));
        Assert.assertEquals((Object)"111222333/111", (Object)this.handleService.parseHandle("https://hdl.handle.net/111222333/111"));
        Assert.assertEquals((Object)"111222333/111", (Object)this.handleService.parseHandle("http://hdl.handle.net/111222333/111"));
        Assert.assertEquals((Object)"111222333/111", (Object)this.handleService.parseHandle("https://whatever/handle/111222333/111"));
        Assert.assertEquals((Object)"111222333/111", (Object)this.handleService.parseHandle("http://whatever/handle/111222333/111"));
    }
}

