/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.VersionBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.identifier.AbstractIdentifierProviderIT;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersionedHandleIdentifierProviderIT
extends AbstractIdentifierProviderIT {
    private String firstHandle;
    private String dspaceUrl;
    private Collection collection;
    private Item itemV1;
    private Item itemV2;
    private Item itemV3;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.dspaceUrl = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.ui.url");
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").build();
        this.context.restoreAuthSystemState();
    }

    private void createVersions() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.itemV1 = ItemBuilder.createItem(this.context, this.collection).withTitle("First version").build();
        this.firstHandle = this.itemV1.getHandle();
        this.itemV2 = VersionBuilder.createVersion(this.context, this.itemV1, "Second version").build().getItem();
        this.itemV3 = VersionBuilder.createVersion(this.context, this.itemV1, "Third version").build().getItem();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testDefaultVersionedHandleProvider() throws Exception {
        this.createVersions();
        Assert.assertEquals((Object)this.firstHandle, (Object)this.itemV1.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV1.getHandles().size());
        Assert.assertEquals((Object)(this.firstHandle + ".2"), (Object)this.itemV2.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV2.getHandles().size());
        Assert.assertEquals((Object)(this.firstHandle + ".3"), (Object)this.itemV3.getHandle());
        Assert.assertEquals((long)1L, (long)this.itemV3.getHandles().size());
    }

    @Test
    public void testCollectionHandleMetadata() {
        this.context.turnOffAuthorisationSystem();
        Community testCommunity = CommunityBuilder.createCommunity(this.context).withName("Test community").build();
        Collection testCollection = CollectionBuilder.createCollection(this.context, testCommunity).withName("Test Collection").build();
        this.context.restoreAuthSystemState();
        List metadata = ContentServiceFactory.getInstance().getDSpaceObjectService((DSpaceObject)testCollection).getMetadata((DSpaceObject)testCollection, "dc", "identifier", "uri", "*");
        Assert.assertEquals((long)1L, (long)metadata.size());
        Assert.assertEquals((Object)(this.dspaceUrl + "/handle/" + testCollection.getHandle()), (Object)((MetadataValue)metadata.get(0)).getValue());
    }

    @Test
    public void testCommunityHandleMetadata() {
        this.context.turnOffAuthorisationSystem();
        Community testCommunity = CommunityBuilder.createCommunity(this.context).withName("Test community").build();
        this.context.restoreAuthSystemState();
        List metadata = ContentServiceFactory.getInstance().getDSpaceObjectService((DSpaceObject)testCommunity).getMetadata((DSpaceObject)testCommunity, "dc", "identifier", "uri", "*");
        Assert.assertEquals((long)1L, (long)metadata.size());
        Assert.assertEquals((Object)(this.dspaceUrl + "/handle/" + testCommunity.getHandle()), (Object)((MetadataValue)metadata.get(0)).getValue());
    }
}

