/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.processor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.CharEncoding;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.export.processor.ItemEventProcessor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class ExportEventProcessorIT
extends AbstractIntegrationTestWithDatabase {
    @Mock
    private final HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private EntityType publication;
    private EntityType otherEntity;
    private final String excluded_type = "Excluded type";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("irus.statistics.tracker.urlversion", (Object)"Z39.88-2004");
        this.configurationService.setProperty("irus.statistics.tracker.enabled", (Object)true);
        this.configurationService.setProperty("irus.statistics.tracker.type-field", (Object)"dc.type");
        this.configurationService.setProperty("irus.statistics.tracker.type-value", (Object)"Excluded type");
        this.context.turnOffAuthorisationSystem();
        this.publication = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        this.otherEntity = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Other").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGetBaseParameters() throws UnsupportedEncodingException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        String encodedHandle = URLEncoder.encode(item.getHandle(), CharEncoding.UTF_8);
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        Mockito.when((Object)this.request.getRemoteAddr()).thenReturn((Object)"test-client-ip");
        Mockito.when((Object)this.request.getHeader("USER-AGENT")).thenReturn((Object)"test-user-agent");
        Mockito.when((Object)this.request.getHeader("referer")).thenReturn((Object)"test-referer");
        String result = exportEventProcessor.getBaseParameters(item);
        String expected = "url_ver=Z39.88-2004&req_id=test-client-ip&req_dat=test-user-agent&rft.artnum=oai%3Alocalhost%3A" + encodedHandle + "&rfr_dat=test-referer&rfr_id=localhost&url_tim=";
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.startsWith((String)expected));
    }

    @Test
    public void testShouldProcessItemWhenNull() throws SQLException {
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, null);
        boolean result = exportEventProcessor.shouldProcessItem(null);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void testShouldProcessItemWhenNotArchived() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, workspaceItem.getItem());
        boolean result = exportEventProcessor.shouldProcessItem(workspaceItem.getItem());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testShouldProcessItemWhenCanEdit() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withEntityType(this.otherEntity.getLabel()).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(this.admin);
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessItem(item);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testShouldProcessItemWhenShouldNotProcessType() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withEntityType(this.publication.getLabel()).build();
        Item item = ItemBuilder.createItem(this.context, collection).withType("Excluded type").build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessItem(item);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testShouldProcessItemWhenShouldNotProcessEntity() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withEntityType(this.otherEntity.getLabel()).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessItem(item);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testShouldProcessItem() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withEntityType(this.publication.getLabel()).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessItem(item);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testShouldProcessEntityType() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withEntityType(this.publication.getLabel()).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessEntityType(item);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testShouldProcessEntityTypeWhenNotInList() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withEntityType(this.otherEntity.getLabel()).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessEntityType(item);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testShouldProcessEntityTypeWhenNotPresent() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessEntityType(item);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testShouldProcessItemTypeInExcludeTrackerTypeList() {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withType("Excluded type").build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessItemType(item);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testShouldProcessItemTypeNotInExcludeTrackerTypeList() {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withType("Not excluded type").build();
        this.context.restoreAuthSystemState();
        ItemEventProcessor exportEventProcessor = new ItemEventProcessor(this.context, this.request, item);
        boolean result = exportEventProcessor.shouldProcessItemType(item);
        Assert.assertTrue((boolean)result);
    }
}

