/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.dspace.importer.external.service.DoiCheck;
import org.junit.Assert;
import org.junit.Test;

public class DoiCheckTest {
    @Test
    public void checkDOIsTest() throws ParseException {
        for (String doi : this.DOIsToTest()) {
            Assert.assertTrue((String)("The: " + doi + "  is a doi!"), (boolean)DoiCheck.isDoi((String)doi));
        }
    }

    @Test
    public void checkWrongDOIsTest() throws ParseException {
        for (String key : this.wrongDOIsToTest()) {
            Assert.assertFalse((String)("This : " + key + "  isn't a doi!"), (boolean)DoiCheck.isDoi((String)key));
        }
    }

    private List<String> DOIsToTest() {
        return Arrays.asList("10.1430/8105", "10.1038/nphys1170", "10.1002/0470841559.ch1", "10.1594/PANGAEA.726855", "10.1594/GFZ.GEOFON.gfz2009kciu", "10.3866/PKU.WHXB201112303", "10.11467/isss2003.7.1_11", "10.3972/water973.0145.db");
    }

    private List<String> wrongDOIsToTest() {
        return Arrays.asList("", "123456789", "nphys1170/10.1038", "10.", "10", "10.1038/");
    }
}

