/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.IPMatcher;
import org.dspace.authenticate.IPMatcherException;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.service.ClientInfoService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class IPAuthentication
implements AuthenticationMethod {
    private static Logger log = LogManager.getLogger(IPAuthentication.class);
    protected List<IPMatcher> ipMatchers = new ArrayList<IPMatcher>();
    protected List<IPMatcher> ipNegativeMatchers = new ArrayList<IPMatcher>();
    protected GroupService groupService;
    protected ClientInfoService clientInfoService;
    protected Map<IPMatcher, String> ipMatcherGroupNames;
    protected Map<IPMatcher, UUID> ipMatcherGroupIDs = new HashMap<IPMatcher, UUID>();

    public IPAuthentication() {
        this.ipMatcherGroupNames = new HashMap<IPMatcher, String>();
        this.groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.clientInfoService = CoreServiceFactory.getInstance().getClientInfoService();
        List propNames = DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyKeys("authentication-ip");
        for (String propName : propNames) {
            String[] nameParts = propName.split("\\.");
            if (nameParts.length == 2) {
                this.addMatchers(nameParts[1], DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty(propName));
                continue;
            }
            log.warn("Malformed configuration property name: " + propName);
        }
    }

    protected void addMatchers(String groupName, String[] ipRanges) {
        for (String entry : ipRanges) {
            try {
                IPMatcher ipm;
                if (entry.startsWith("-")) {
                    ipm = new IPMatcher(entry.substring(1));
                    this.ipNegativeMatchers.add(ipm);
                } else {
                    ipm = new IPMatcher(entry);
                    this.ipMatchers.add(ipm);
                }
                this.ipMatcherGroupNames.put(ipm, groupName);
                if (!log.isDebugEnabled()) continue;
                log.debug("Configured " + entry + " for special group " + groupName);
            }
            catch (IPMatcherException ipme) {
                log.warn("Malformed IP range specified for group " + groupName, (Throwable)ipme);
            }
        }
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return true;
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        Group group;
        String groupName;
        UUID g;
        if (request == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        String addr = this.clientInfoService.getClientIp(request);
        for (IPMatcher ipm : this.ipMatchers) {
            try {
                if (!ipm.match(addr)) continue;
                g = this.ipMatcherGroupIDs.get(ipm);
                if (g != null) {
                    groups.add((Group)this.groupService.find(context, g));
                    continue;
                }
                groupName = this.ipMatcherGroupNames.get(ipm);
                if (groupName == null) continue;
                group = this.groupService.findByName(context, groupName);
                if (group != null) {
                    this.ipMatcherGroupIDs.put(ipm, group.getID());
                    this.ipMatcherGroupNames.remove(ipm);
                    groups.add(group);
                    continue;
                }
                log.warn(LogHelper.getHeader(context, "configuration_error", "unknown_group=" + groupName));
            }
            catch (IPMatcherException ipme) {
                log.warn(LogHelper.getHeader(context, "configuration_error", "bad_ip=" + addr), (Throwable)ipme);
            }
        }
        for (IPMatcher ipm : this.ipNegativeMatchers) {
            try {
                if (!ipm.match(addr)) continue;
                g = this.ipMatcherGroupIDs.get(ipm);
                if (g != null) {
                    groups.remove(this.groupService.find(context, g));
                    continue;
                }
                groupName = this.ipMatcherGroupNames.get(ipm);
                if (groupName == null) continue;
                group = this.groupService.findByName(context, groupName);
                if (group != null) {
                    this.ipMatcherGroupIDs.put(ipm, group.getID());
                    this.ipMatcherGroupNames.remove(ipm);
                    groups.remove(group);
                    continue;
                }
                log.warn(LogHelper.getHeader(context, "configuration_error", "unknown_group=" + groupName));
            }
            catch (IPMatcherException ipme) {
                log.warn(LogHelper.getHeader(context, "configuration_error", "bad_ip=" + addr), (Throwable)ipme);
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder gsb = new StringBuilder();
            for (Group group2 : groups) {
                gsb.append(group2.getID()).append(", ");
            }
            log.debug(LogHelper.getHeader(context, "authenticated", "special_groups=" + gsb.toString() + " (by IP=" + addr + ")"));
        }
        return groups;
    }

    @Override
    public boolean areSpecialGroupsApplicable(Context context, HttpServletRequest request) {
        return true;
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        return 5;
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @Override
    public String getName() {
        return "ip";
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return false;
    }

    @Override
    public boolean canChangePassword(Context context, EPerson ePerson, String currentPassword) {
        return false;
    }
}

