/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.util.SolrUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class AuthorityValue {
    private String id;
    private String field;
    private String value;
    private Date creationDate;
    private boolean deleted;
    private Date lastModified;
    private static Logger log = LogManager.getLogger(AuthorityValue.class);

    public AuthorityValue() {
    }

    public AuthorityValue(SolrDocument document) {
        this.setValues(document);
    }

    public String getId() {
        return this.id;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = this.stringToDate(creationDate);
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = this.stringToDate(lastModified);
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    protected void updateLastModifiedDate() {
        this.lastModified = new Date();
    }

    public void update() {
        this.updateLastModifiedDate();
    }

    public void delete() {
        this.setDeleted(true);
        this.updateLastModifiedDate();
    }

    public SolrInputDocument getSolrInputDocument() {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        DateFormat solrDateFormatter = SolrUtils.getDateFormatter();
        doc.addField("id", (Object)this.getId());
        doc.addField("field", (Object)this.getField());
        doc.addField("value", (Object)this.getValue());
        doc.addField("deleted", (Object)this.isDeleted());
        doc.addField("creation_date", (Object)solrDateFormatter.format(this.getCreationDate()));
        doc.addField("last_modified_date", (Object)solrDateFormatter.format(this.getLastModified()));
        doc.addField("authority_type", (Object)this.getAuthorityType());
        return doc;
    }

    public void setValues(SolrDocument document) {
        this.id = String.valueOf(document.getFieldValue("id"));
        this.field = String.valueOf(document.getFieldValue("field"));
        this.value = String.valueOf(document.getFieldValue("value"));
        this.deleted = (Boolean)document.getFieldValue("deleted");
        this.creationDate = (Date)document.getFieldValue("creation_date");
        this.lastModified = (Date)document.getFieldValue("last_modified_date");
    }

    public void updateItem(Context context, Item currentItem, MetadataValue value) throws SQLException, AuthorizeException {
        value.setValue(this.getValue());
        value.setAuthority(this.getId());
        ContentServiceFactory.getInstance().getMetadataValueService().update(context, value, true);
    }

    public Map<String, String> choiceSelectMap() {
        return new HashMap<String, String>();
    }

    public List<DateTimeFormatter> getDateFormatters() {
        ArrayList<DateTimeFormatter> list = new ArrayList<DateTimeFormatter>();
        list.add(ISODateTimeFormat.dateTime());
        list.add(ISODateTimeFormat.dateTimeNoMillis());
        return list;
    }

    public Date stringToDate(String date) {
        Date result = null;
        if (StringUtils.isNotBlank((CharSequence)date)) {
            List<DateTimeFormatter> dateFormatters = this.getDateFormatters();
            boolean converted = false;
            int formatter = 0;
            while (!converted) {
                try {
                    DateTimeFormatter dateTimeFormatter = dateFormatters.get(formatter);
                    DateTime dateTime = dateTimeFormatter.parseDateTime(date);
                    result = dateTime.toDate();
                    converted = true;
                }
                catch (IllegalArgumentException e) {
                    if (++formatter > dateFormatters.size()) {
                        converted = true;
                    }
                    log.error("Could not find a valid date format for: \"" + date + "\"", (Throwable)e);
                }
            }
        }
        return result;
    }

    public String toString() {
        return "AuthorityValue{id='" + this.id + "', field='" + this.field + "', value='" + this.value + "', creationDate=" + this.creationDate + ", deleted=" + this.deleted + ", lastModified=" + this.lastModified + "}";
    }

    public String generateString() {
        return "will be generated::";
    }

    public AuthorityValue newInstance(String info) {
        return new AuthorityValue();
    }

    public String getAuthorityType() {
        return "internal";
    }

    public boolean hasTheSameInformationAs(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorityValue that = (AuthorityValue)o;
        if (this.deleted != that.deleted) {
            return false;
        }
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }
}

