/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.ProcessStatus;
import org.dspace.content.dao.ProcessDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.scripts.Process;
import org.dspace.scripts.ProcessQueryParameterContainer;
import org.dspace.scripts.Process_;

public class ProcessDAOImpl
extends AbstractHibernateDAO<Process>
implements ProcessDAO {
    @Override
    public List<Process> findAllSortByScript(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)processRoot.get(Process_.name))});
        return this.list(context, criteriaQuery, false, Process.class, -1, -1);
    }

    @Override
    public List<Process> findAllSortByStartTime(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)processRoot.get(Process_.startTime)), criteriaBuilder.desc((Expression)processRoot.get(Process_.processId))});
        return this.list(context, criteriaQuery, false, Process.class, -1, -1);
    }

    @Override
    public List<Process> findAll(Context context, int limit, int offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)processRoot.get(Process_.processId))});
        return this.list(context, criteriaQuery, false, Process.class, limit, offset);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        return this.count(context, criteriaQuery, criteriaBuilder, processRoot);
    }

    @Override
    public List<Process> search(Context context, ProcessQueryParameterContainer processQueryParameterContainer, int limit, int offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        this.handleProcessQueryParameters(processQueryParameterContainer, criteriaBuilder, criteriaQuery, (Root<Process>)processRoot);
        return this.list(context, criteriaQuery, false, Process.class, limit, offset);
    }

    private void handleProcessQueryParameters(ProcessQueryParameterContainer processQueryParameterContainer, CriteriaBuilder criteriaBuilder, CriteriaQuery criteriaQuery, Root<Process> processRoot) {
        this.addProcessQueryParameters(processQueryParameterContainer, criteriaBuilder, criteriaQuery, processRoot);
        if (StringUtils.equalsIgnoreCase((CharSequence)processQueryParameterContainer.getSortOrder(), (CharSequence)"asc")) {
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)processRoot.get(processQueryParameterContainer.getSortProperty()))});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)processQueryParameterContainer.getSortOrder(), (CharSequence)"desc")) {
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)processRoot.get(processQueryParameterContainer.getSortProperty()))});
        }
    }

    private void addProcessQueryParameters(ProcessQueryParameterContainer processQueryParameterContainer, CriteriaBuilder criteriaBuilder, CriteriaQuery criteriaQuery, Root<Process> processRoot) {
        LinkedList<Predicate> andPredicates = new LinkedList<Predicate>();
        for (Map.Entry<String, Object> entry : processQueryParameterContainer.getQueryParameterMap().entrySet()) {
            andPredicates.add(criteriaBuilder.equal((Expression)processRoot.get(entry.getKey()), entry.getValue()));
        }
        criteriaQuery.where((Expression)criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
    }

    @Override
    public int countTotalWithParameters(Context context, ProcessQueryParameterContainer processQueryParameterContainer) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        this.addProcessQueryParameters(processQueryParameterContainer, criteriaBuilder, criteriaQuery, (Root<Process>)processRoot);
        return this.count(context, criteriaQuery, criteriaBuilder, processRoot);
    }

    @Override
    public List<Process> findByStatusAndCreationTimeOlderThan(Context context, List<ProcessStatus> statuses, Date date) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        Predicate creationTimeLessThanGivenDate = criteriaBuilder.lessThan((Expression)processRoot.get("creationTime"), (Comparable)date);
        Predicate statusIn = processRoot.get("processStatus").in(statuses);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)creationTimeLessThanGivenDate, (Expression)statusIn));
        return this.list(context, criteriaQuery, false, Process.class, -1, -1);
    }

    @Override
    public List<Process> findByUser(Context context, EPerson user, int limit, int offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)processRoot.get("ePerson"), (Object)user));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)processRoot.get("processId")));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, Process.class, limit, offset);
    }

    @Override
    public int countByUser(Context context, EPerson user) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Process> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Process.class);
        Root processRoot = criteriaQuery.from(Process.class);
        criteriaQuery.select((Selection)processRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)processRoot.get("ePerson"), (Object)user));
        return this.count(context, criteriaQuery, criteriaBuilder, processRoot);
    }
}

