/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingUtils;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceIndexCollectionSubmittersPlugin
implements SolrServiceIndexPlugin {
    private static final Logger log = LogManager.getLogger(SolrServiceIndexCollectionSubmittersPlugin.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;

    @Override
    public void additionalIndex(Context context, IndexableObject idxObj, SolrInputDocument document) {
        Collection col;
        if (idxObj instanceof IndexableCollection && (col = (Collection)((IndexableCollection)idxObj).getIndexedObject()) != null) {
            try {
                for (UUID unprefixedId : IndexingUtils.findTransitiveAdminGroupIds(context, col)) {
                    document.addField("submit", (Object)("g" + unprefixedId));
                }
                List<String> prefixedIds = IndexingUtils.findDirectlyAuthorizedGroupAndEPersonPrefixedIds(this.authorizeService, context, col, new int[]{3, 11});
                for (String prefixedId : prefixedIds) {
                    document.addField("submit", (Object)prefixedId);
                }
            }
            catch (SQLException e) {
                log.error(LogHelper.getHeader(context, "Error while indexing resource policies", "Collection: (id " + col.getID() + " type " + col.getName() + ")"));
            }
        }
    }
}

