/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.health;

import java.sql.SQLException;
import java.util.Iterator;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.embargo.factory.EmbargoServiceFactory;
import org.dspace.embargo.service.EmbargoService;
import org.dspace.health.Check;
import org.dspace.health.ReportInfo;

public class EmbargoCheck
extends Check {
    private static final EmbargoService embargoService = EmbargoServiceFactory.getInstance().getEmbargoService();

    @Override
    public String run(ReportInfo ri) {
        Object ret = "";
        Context context = new Context();
        try {
            Iterator<Item> item_iter = null;
            try {
                item_iter = embargoService.findItemsByLiftMetadata(context);
            }
            catch (IllegalArgumentException e) {
                this.error(e, "No embargoed items found");
                ret = (String)ret + "Note: This check is for pre-3.0 embargo functionality.\n";
                ret = (String)ret + "If you aren't using it, you can ignore this error.\n";
            }
            catch (Exception e) {
                this.error(e);
            }
            while (item_iter != null && item_iter.hasNext()) {
                Item item = item_iter.next();
                String handle = item.getHandle();
                DCDate date = null;
                try {
                    date = embargoService.getEmbargoTermsAsDate(context, item);
                }
                catch (Exception e) {
                    this.error(e);
                }
                ret = (String)ret + String.format("%s embargoed till [%s]\n", handle, date != null ? date.toString() : "null");
            }
            context.complete();
        }
        catch (SQLException e) {
            this.error(e);
            try {
                context.abort();
            }
            catch (Exception e1) {
                this.error(e);
            }
        }
        return ret;
    }
}

