/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.ProcessStatus;
import org.dspace.scripts.Process;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ProcessService;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jdom2.Document;
import org.junit.Test;

public class ProcessCleanerIT
extends AbstractIntegrationTestWithDatabase {
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private ProcessService processService = ScriptServiceFactory.getInstance().getProcessService();

    @Test
    public void testWithoutProcessToDelete() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [COMPLETED]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 0 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testWithoutSpecifiedStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [COMPLETED]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 2 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testWithCompletedStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner", "-c"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [COMPLETED]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 2 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testWithRunningStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_8 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-9));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner", "-r"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [RUNNING]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 2 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_8.getID().intValue()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWithFailedStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_8 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-9));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner", "-f"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(testDSpaceRunnableHandler.getWarningMessages(), (Matcher)Matchers.empty());
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [FAILED]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 2 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_8.getID().intValue()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWithCompletedAndFailedStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_8 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-9));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner", "-c", "-f"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [COMPLETED, FAILED]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 4 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_8.getID().intValue()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWithCompletedAndRunningStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_8 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-9));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner", "-c", "-r"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [COMPLETED, RUNNING]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 4 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_8.getID().intValue()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWithFailedAndRunningStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_8 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-9));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner", "-f", "-r"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [FAILED, RUNNING]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 3 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_8.getID().intValue()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWithCompletedFailedAndRunningStatus() throws Exception {
        Process process_1 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-2));
        Process process_2 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-1));
        Process process_3 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-3));
        Process process_4 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-6));
        Process process_5 = this.buildProcess(ProcessStatus.COMPLETED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_6 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-7));
        Process process_7 = this.buildProcess(ProcessStatus.FAILED, DateUtils.addDays((Date)new Date(), (int)-8));
        Process process_8 = this.buildProcess(ProcessStatus.RUNNING, DateUtils.addDays((Date)new Date(), (int)-9));
        this.configurationService.setProperty("process-cleaner.days", (Object)5);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"process-cleaner", "-f", "-r", "-c"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        List<String> messages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Searching for processes with status: [COMPLETED, FAILED, RUNNING]"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Found 5 processes to be deleted"));
        MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem((Object)"Process cleanup completed"));
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_1.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_2.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_3.getID().intValue()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_4.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_5.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_6.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_7.getID().intValue()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.processService.find(this.context, process_8.getID().intValue()), (Matcher)Matchers.nullValue());
    }

    private Process buildProcess(ProcessStatus processStatus, Date creationTime) throws SQLException {
        return ProcessBuilder.createProcess(this.context, this.admin, "test", List.of()).withProcessStatus(processStatus).withCreationTime(creationTime).build();
    }
}

