/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.file.PathUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.itemimport.ItemImport;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemImportCLIIT
extends AbstractIntegrationTestWithDatabase {
    private static final String ZIP_NAME = "saf.zip";
    private static final String PDF_NAME = "test.pdf";
    private static final String publicationTitle = "A Tale of Two Cities";
    private static final String personTitle = "Person Test";
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private Collection collection;
    private Path tempDir;
    private Path workDir;
    private static final String TEMP_DIR = ItemImport.TEMP_DIR;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withEntityType("Publication").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publication, person, "isAuthorOfPublication", "isPublicationOfAuthor", 0, null, 0, null).withCopyToLeft(false).withCopyToRight(true).build();
        this.context.restoreAuthSystemState();
        this.tempDir = Files.createTempDirectory("safImportTest", new FileAttribute[0]);
        File file = new File(this.configurationService.getProperty("org.dspace.app.batchitemimport.work.dir"));
        if (!file.exists()) {
            Files.createDirectory(Path.of(file.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        this.workDir = Path.of(file.getAbsolutePath(), new String[0]);
    }

    @Override
    @After
    public void destroy() throws Exception {
        PathUtils.deleteDirectory((Path)this.tempDir);
        for (Path path : Files.list(this.workDir).collect(Collectors.toList())) {
            PathUtils.delete((Path)path);
        }
        super.destroy();
    }

    @Test
    public void importItemBySafWithMetadataOnly() throws Exception {
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        String[] args = new String[]{"import", "-a", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", this.tempDir.toString() + "/mapfile.out"};
        this.perfomImportScript(args);
        this.checkMetadata();
    }

    @Test
    public void importItemBySafWithBitstreams() throws Exception {
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Path contentsFile = Files.createFile(Path.of(itemDir.toString() + "/contents", new String[0]), new FileAttribute[0]);
        Files.writeString(contentsFile, (CharSequence)"file1.txt", new OpenOption[0]);
        Path bitstreamFile = Files.createFile(Path.of(itemDir.toString() + "/file1.txt", new String[0]), new FileAttribute[0]);
        Files.writeString(bitstreamFile, (CharSequence)"TEST TEST TEST", new OpenOption[0]);
        String[] args = new String[]{"import", "-a", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", this.tempDir.toString() + "/mapfile.out"};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkBitstream();
    }

    @Test
    public void importItemBySafWithAnotherMetadataSchema() throws Exception {
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Files.copy(this.getClass().getResourceAsStream("metadata_dcterms.xml"), Path.of(itemDir.toString() + "/metadata_dcterms.xml", new String[0]), new CopyOption[0]);
        String[] args = new String[]{"import", "-a", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", this.tempDir.toString() + "/mapfile.out"};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkMetadataWithAnotherSchema();
    }

    @Test
    public void importItemsBySafWithRelationships() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collectionPerson = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection Person").withEntityType("Person").build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path publicationDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.writeString(Path.of(publicationDir.toString() + "/collections", new String[0]), (CharSequence)this.collection.getID().toString(), new OpenOption[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(publicationDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Files.copy(this.getClass().getResourceAsStream("relationships"), Path.of(publicationDir.toString() + "/relationships", new String[0]), new CopyOption[0]);
        Path personDir = Files.createDirectory(Path.of(safDir.toString() + "/item_001", new String[0]), new FileAttribute[0]);
        Files.writeString(Path.of(personDir.toString() + "/collections", new String[0]), (CharSequence)collectionPerson.getID().toString(), new OpenOption[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core-person.xml"), Path.of(personDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        String[] args = new String[]{"import", "-a", "-p", "-e", this.admin.getEmail(), "-s", safDir.toString(), "-m", this.tempDir.toString() + "/mapfile.out"};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkRelationship();
    }

    @Test
    public void importItemsBySafWithRelationshipsByRelationSchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collectionPerson = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection Person").withEntityType("Person").build();
        Item person = ItemBuilder.createItem(this.context, collectionPerson).withTitle(personTitle).build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Files.writeString(Path.of(itemDir.toString() + "/metadata_relation.xml", new String[0]), (CharSequence)("<dublin_core schema=\"relation\">\n    <dcvalue element=\"isAuthorOfPublication\">" + person.getID() + "</dcvalue>\n</dublin_core>"), new OpenOption[0]);
        String[] args = new String[]{"import", "-a", "-p", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", this.tempDir.toString() + "/mapfile.out"};
        this.perfomImportScript(args);
        this.checkRelationship();
    }

    @Test
    public void importItemByZipSafWithBitstreams() throws Exception {
        Files.copy(this.getClass().getResourceAsStream("saf-bitstreams.zip"), Path.of(this.tempDir.toString() + "/saf.zip", new String[0]), new CopyOption[0]);
        String[] args = new String[]{"import", "-a", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", this.tempDir.toString(), "-z", ZIP_NAME, "-m", this.tempDir.toString() + "/mapfile.out"};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkMetadataWithAnotherSchema();
        this.checkBitstream();
        File workTempDir = new File(this.workDir + File.separator + TEMP_DIR);
        Assert.assertTrue((boolean)workTempDir.exists());
    }

    @Test
    public void importItemByZipSafWithRelationships() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collectionPerson = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection Person").withEntityType("Person").build();
        Item person = ItemBuilder.createItem(this.context, collectionPerson).withTitle(personTitle).build();
        this.context.restoreAuthSystemState();
        Files.copy(this.getClass().getResourceAsStream("saf-relationships.zip"), Path.of(this.tempDir.toString() + "/saf.zip", new String[0]), new CopyOption[0]);
        String[] args = new String[]{"import", "-a", "-p", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", this.tempDir.toString(), "-z", ZIP_NAME, "-m", this.tempDir.toString() + "/mapfile.out"};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkRelationship();
    }

    @Test
    public void importItemByZipSafInvalidMimetype() throws Exception {
        Files.copy(this.getClass().getResourceAsStream(PDF_NAME), Path.of(this.tempDir.toString() + "/test.pdf", new String[0]), new CopyOption[0]);
        String[] args = new String[]{"import", "-a", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", this.tempDir.toString(), "-z", PDF_NAME, "-m", this.tempDir.toString() + "/mapfile.out"};
        try {
            this.perfomImportScript(args);
        }
        catch (Exception e) {
            Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    @Test
    public void resumeImportItemBySafWithMetadataOnly() throws Exception {
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        String[] args = new String[]{"import", "-a", "-R", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
    }

    @Test
    public void resumeImportItemBySafWithBitstreams() throws Exception {
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Path contentsFile = Files.createFile(Path.of(itemDir.toString() + "/contents", new String[0]), new FileAttribute[0]);
        Files.writeString(contentsFile, (CharSequence)"file1.txt", new OpenOption[0]);
        Path bitstreamFile = Files.createFile(Path.of(itemDir.toString() + "/file1.txt", new String[0]), new FileAttribute[0]);
        Files.writeString(bitstreamFile, (CharSequence)"TEST TEST TEST", new OpenOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        String[] args = new String[]{"import", "-a", "-R", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkBitstream();
    }

    @Test
    public void resumeImportItemBySafWithAnotherMetadataSchema() throws Exception {
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Files.copy(this.getClass().getResourceAsStream("metadata_dcterms.xml"), Path.of(itemDir.toString() + "/metadata_dcterms.xml", new String[0]), new CopyOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        String[] args = new String[]{"import", "-a", "-R", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkMetadataWithAnotherSchema();
    }

    @Test
    public void resumeImportItemSkippingTheFirstOneBySafWithMetadataOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Another Title").build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_001", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        Files.writeString(mapFile, (CharSequence)("item_000 " + item.getHandle()), new OpenOption[0]);
        String[] args = new String[]{"import", "-a", "-R", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
    }

    @Test
    public void resumeImportItemSkippingTheFirstOneBySafWithBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Another Title").build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_001", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Path contentsFile = Files.createFile(Path.of(itemDir.toString() + "/contents", new String[0]), new FileAttribute[0]);
        Files.writeString(contentsFile, (CharSequence)"file1.txt", new OpenOption[0]);
        Path bitstreamFile = Files.createFile(Path.of(itemDir.toString() + "/file1.txt", new String[0]), new FileAttribute[0]);
        Files.writeString(bitstreamFile, (CharSequence)"TEST TEST TEST", new OpenOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        Files.writeString(mapFile, (CharSequence)("item_000 " + item.getHandle()), new OpenOption[0]);
        String[] args = new String[]{"import", "-a", "-R", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkBitstream();
    }

    @Test
    public void resumeImportItemSkippingTheFirstOneBySafWithAnotherMetadataSchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Another Title").build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_001", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Files.copy(this.getClass().getResourceAsStream("metadata_dcterms.xml"), Path.of(itemDir.toString() + "/metadata_dcterms.xml", new String[0]), new CopyOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        Files.writeString(mapFile, (CharSequence)("item_000 " + item.getHandle()), new OpenOption[0]);
        String[] args = new String[]{"import", "-a", "-R", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkMetadataWithAnotherSchema();
    }

    @Test
    public void replaceItemBySafWithMetadataOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Another Title").build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        Files.writeString(mapFile, (CharSequence)("item_000 " + item.getHandle()), new OpenOption[0]);
        String[] args = new String[]{"import", "-r", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
    }

    @Test
    public void replaceItemBySafWithBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Another Title").build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Path contentsFile = Files.createFile(Path.of(itemDir.toString() + "/contents", new String[0]), new FileAttribute[0]);
        Files.writeString(contentsFile, (CharSequence)"file1.txt", new OpenOption[0]);
        Path bitstreamFile = Files.createFile(Path.of(itemDir.toString() + "/file1.txt", new String[0]), new FileAttribute[0]);
        Files.writeString(bitstreamFile, (CharSequence)"TEST TEST TEST", new OpenOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        Files.writeString(mapFile, (CharSequence)("item_000 " + item.getHandle()), new OpenOption[0]);
        String[] args = new String[]{"import", "-r", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkBitstream();
    }

    @Test
    public void replaceItemBySafWithAnotherMetadataSchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Another Title").build();
        this.context.restoreAuthSystemState();
        Path safDir = Files.createDirectory(Path.of(this.tempDir.toString() + "/test", new String[0]), new FileAttribute[0]);
        Path itemDir = Files.createDirectory(Path.of(safDir.toString() + "/item_000", new String[0]), new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("dublin_core.xml"), Path.of(itemDir.toString() + "/dublin_core.xml", new String[0]), new CopyOption[0]);
        Files.copy(this.getClass().getResourceAsStream("metadata_dcterms.xml"), Path.of(itemDir.toString() + "/metadata_dcterms.xml", new String[0]), new CopyOption[0]);
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        Files.writeString(mapFile, (CharSequence)("item_000 " + item.getHandle()), new OpenOption[0]);
        String[] args = new String[]{"import", "-r", "-e", this.admin.getEmail(), "-c", this.collection.getID().toString(), "-s", safDir.toString(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkMetadata();
        this.checkMetadataWithAnotherSchema();
    }

    @Test
    public void deleteItemByMapFile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(publicationTitle).build();
        this.context.restoreAuthSystemState();
        Path mapFile = Files.createFile(Path.of(this.tempDir.toString() + "/mapfile.out", new String[0]), new FileAttribute[0]);
        Files.writeString(mapFile, (CharSequence)("item_000 " + item.getHandle()), new OpenOption[0]);
        String[] args = new String[]{"import", "-d", "-e", this.admin.getEmail(), "-m", mapFile.toString()};
        this.perfomImportScript(args);
        this.checkItemDeletion();
    }

    private void checkMetadata() throws Exception {
        Item item = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next();
        Assert.assertEquals((Object)item.getName(), (Object)publicationTitle);
        Assert.assertEquals((Object)this.itemService.getMetadata((DSpaceObject)item, "dc.date.issued"), (Object)"1990");
        Assert.assertEquals((Object)this.itemService.getMetadata((DSpaceObject)item, "dc.title.alternative"), (Object)"J'aime les Printemps");
    }

    private void checkMetadataWithAnotherSchema() throws Exception {
        Item item = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next();
        Assert.assertEquals((Object)item.getName(), (Object)publicationTitle);
        Assert.assertEquals((Object)this.itemService.getMetadata((DSpaceObject)item, "dcterms.title"), (Object)publicationTitle);
    }

    private void checkBitstream() throws Exception {
        Bitstream bitstream = (Bitstream)((Bundle)((Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next()).getBundles("ORIGINAL").get(0)).getBitstreams().get(0);
        Assert.assertEquals((Object)bitstream.getName(), (Object)"file1.txt");
    }

    private void checkItemDeletion() throws Exception {
        Iterator itemIterator = this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle);
        Assert.assertEquals((Object)itemIterator.hasNext(), (Object)false);
    }

    private void checkRelationship() throws Exception {
        Item item = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next();
        Item author = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, personTitle).next();
        List relationships = this.relationshipService.findByItem(this.context, item);
        Assert.assertEquals((long)1L, (long)relationships.size());
        Assert.assertEquals((Object)author.getID(), (Object)((Relationship)relationships.get(0)).getRightItem().getID());
        Assert.assertEquals((Object)item.getID(), (Object)((Relationship)relationships.get(0)).getLeftItem().getID());
    }

    private void perfomImportScript(String[] args) throws Exception {
        this.runDSpaceScript(args);
    }
}

