/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.MetadataFieldService;
import org.junit.Assert;
import org.junit.Test;

public class MetadataFieldPerformanceTest
extends AbstractUnitTest {
    private final MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    @Test
    public void testManyQueries() throws SQLException {
        long startTime = System.currentTimeMillis();
        int amount = 50000;
        for (int i = 0; i < amount; ++i) {
            this.metadataFieldService.findByElement(this.context, "dc", "description", null);
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        double maxDurationPerCall = 0.01;
        double maxDuration = maxDurationPerCall * (double)amount;
        Assert.assertTrue((String)("Duration (" + duration + ") should be smaller than " + maxDuration + " for " + amount + " tests. Max of " + maxDurationPerCall + " ms per operation exceeded: " + (double)duration / (double)amount + " ms."), ((double)duration < maxDuration ? 1 : 0) != 0);
    }

    @Test
    public void testManyMetadataAdds() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Community owningCommunity = this.communityService.create(null, this.context);
        Collection collection = this.collectionService.create(this.context, owningCommunity);
        this.context.restoreAuthSystemState();
        long startTime = System.currentTimeMillis();
        int amount = 5000;
        for (int i = 0; i < amount; ++i) {
            this.collectionService.addMetadata(this.context, (DSpaceObject)collection, "dc", "description", null, null, "Test " + i);
            this.collectionService.clearMetadata(this.context, (DSpaceObject)collection, "dc", "description", null, null);
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        double maxDurationPerCall = 0.4;
        double maxDuration = maxDurationPerCall * (double)amount;
        Assert.assertTrue((String)("Duration (" + duration + ") should be smaller than " + maxDuration + " for " + amount + " tests. Max of " + maxDurationPerCall + " ms per operation exceeded: " + (double)duration / (double)amount + " ms."), ((double)duration < maxDuration ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        try {
            this.collectionService.delete(this.context, (DSpaceObject)collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.communityService.delete(this.context, (DSpaceObject)owningCommunity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.restoreAuthSystemState();
    }
}

