/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import javax.servlet.http.HttpServletRequest;
import org.dspace.AbstractDSpaceTest;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.util.DummyHttpServletRequest;
import org.dspace.statistics.util.SpiderDetectorService;
import org.dspace.statistics.util.SpiderDetectorServiceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpiderDetectorServiceImplTest
extends AbstractDSpaceTest {
    private static final String NOT_A_BOT_ADDRESS = "192.168.0.1";
    private ConfigurationService configurationService;
    private ClientInfoService clientInfoService;
    private SpiderDetectorService spiderDetectorService;

    @Before
    public void init() {
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.clientInfoService = CoreServiceFactory.getInstance().getClientInfoService();
        this.spiderDetectorService = new SpiderDetectorServiceImpl(this.configurationService, this.clientInfoService);
    }

    @Test
    public void testReadPatterns() {
    }

    @Test
    public void testGetSpiderIpAddresses() {
    }

    @Test
    public void testCaseInsensitiveMatching() throws Exception {
        this.configurationService.setProperty("usage-statistics.bots.case-insensitive", (Object)true);
        this.spiderDetectorService = new SpiderDetectorServiceImpl(this.configurationService, this.clientInfoService);
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnboT Is WaTching you");
        Assert.assertTrue((String)"'msnbot' didn't match pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAgent("mozilla/5.0 (x11; linux x86_64; rv:91.0) gecko/20100101 firefox/91.0");
        Assert.assertFalse((String)"'Firefox' matched a pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        String candidate = "192.168.2.1";
        req.setAddress(candidate);
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAddress(NOT_A_BOT_ADDRESS);
        Assert.assertFalse((String)"192.168.0.1 matched IP patterns", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "baiduspiDer-dSPace-test.crawl.baIDu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " did match DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "wIki.dsPace.oRg";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
    }

    @Test
    public void testIsSpiderHttpServletRequest() {
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnbot is watching you");
        Assert.assertTrue((String)"'msnbot' did not match any pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAgent("Firefox");
        Assert.assertFalse((String)"'Firefox' matched a pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        String candidate = "192.168.2.1";
        req.setAddress(candidate);
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAddress(NOT_A_BOT_ADDRESS);
        Assert.assertFalse((String)"192.168.0.1 matched IP patterns", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "baiduspider-dspace-test.crawl.baidu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "wiki.dspace.org";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
    }

    @Test
    public void testIsSpiderStringStringStringString() {
        String candidate = "192.168.2.1";
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)this.spiderDetectorService.isSpider(candidate, null, null, null));
        candidate = NOT_A_BOT_ADDRESS;
        Assert.assertFalse((String)(candidate + " matched IP patterns"), (boolean)this.spiderDetectorService.isSpider(candidate, null, null, null));
        candidate = "baiduspider-dspace-test.crawl.baidu.com";
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)this.spiderDetectorService.isSpider(NOT_A_BOT_ADDRESS, null, candidate, null));
        candidate = "wiki.dspace.org";
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)this.spiderDetectorService.isSpider(NOT_A_BOT_ADDRESS, null, candidate, null));
        candidate = "msnbot is watching you";
        Assert.assertTrue((String)("'" + candidate + "' did not match agent patterns"), (boolean)this.spiderDetectorService.isSpider(NOT_A_BOT_ADDRESS, null, null, candidate));
        candidate = "Firefox";
        Assert.assertFalse((String)("'" + candidate + "' matched agent patterns"), (boolean)this.spiderDetectorService.isSpider(NOT_A_BOT_ADDRESS, null, null, candidate));
    }

    @Test
    public void testIsSpiderString() {
        String candidate = "192.168.2.1";
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)this.spiderDetectorService.isSpider(candidate, null, null, null));
        candidate = NOT_A_BOT_ADDRESS;
        Assert.assertFalse((String)(candidate + " matched IP patterns"), (boolean)this.spiderDetectorService.isSpider(candidate, null, null, null));
    }

    @Test
    public void testCaseSensitiveMatching() throws Exception {
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnboT Is WaTching you");
        Assert.assertFalse((String)"'msnbot' matched pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAgent("FirefOx");
        Assert.assertFalse((String)"'Firefox' matched a pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        String candidate = "192.168.2.1";
        req.setAddress(candidate);
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAddress(NOT_A_BOT_ADDRESS);
        Assert.assertFalse((String)"192.168.0.1 matched IP patterns", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "baiduspiDer-dSPace-test.crawl.baIDu.com";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " did match DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "wIki.dsPace.oRg";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
    }

    @Test
    public void testInsensitiveSensitiveDifference() {
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnbot is WaTching you");
        Assert.assertTrue((String)"'msnbot' didn't match pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAgent("MSNBOT Is WaTching you");
        Assert.assertFalse((String)"'msnbot' matched pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        String candidate = "baiduspider-dspace-test.crawl.baidu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "baiduspiDer-dSPace-test.crawl.baIDu.com";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
    }

    @Test
    public void testBothLowerAndUpperCaseGetMatched() {
        this.configurationService.setProperty("usage-statistics.bots.case-insensitive", (Object)true);
        this.spiderDetectorService = new SpiderDetectorServiceImpl(this.configurationService, this.clientInfoService);
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnbot is WaTching you");
        Assert.assertTrue((String)"'msnbot' didn't match pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAgent("MSNBOT Is WaTching you");
        Assert.assertTrue((String)"'msnbot' didn't match pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        String candidate = "baiduspider-dspace-test.crawl.baidu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "baiduspiDer-dSPace-test.crawl.baIDu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " didn't match DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
    }

    @Test
    public void testNonBooleanConfig() {
        this.configurationService.setProperty("usage-statistics.bots.case-insensitive", (Object)"RandomNonBooleanString");
        this.spiderDetectorService = new SpiderDetectorServiceImpl(this.configurationService, this.clientInfoService);
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnbot is WaTching you");
        Assert.assertTrue((String)"'msnbot' didn't match pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        req.setAgent("MSNBOT Is WaTching you");
        Assert.assertFalse((String)"'msnbot' matched pattern", (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        String candidate = "baiduspider-dspace-test.crawl.baidu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
        candidate = "baiduspiDer-dSPace-test.crawl.baIDu.com";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)this.spiderDetectorService.isSpider((HttpServletRequest)req));
    }

    @After
    public void cleanup() throws Exception {
        this.spiderDetectorService = null;
        this.configurationService.setProperty("usage-statistics.bots.case-insensitive", (Object)false);
    }
}

