/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.access.status;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.access.status.DefaultAccessStatusHelper;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAccessStatusHelperTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(DefaultAccessStatusHelperTest.class);
    private Collection collection;
    private Community owningCommunity;
    private Item itemWithoutBundle;
    private Item itemWithoutBitstream;
    private Item itemWithBitstream;
    private Item itemWithEmbargo;
    private Item itemWithDateRestriction;
    private Item itemWithGroupRestriction;
    private Item itemWithoutPolicy;
    private Item itemWithoutPrimaryBitstream;
    private Item itemWithPrimaryAndMultipleBitstreams;
    private Item itemWithoutPrimaryAndMultipleBitstreams;
    private DefaultAccessStatusHelper helper;
    private Date threshold;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.itemWithoutBundle = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutBitstream = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithBitstream = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithEmbargo = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithDateRestriction = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithGroupRestriction = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutPolicy = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutPrimaryBitstream = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithPrimaryAndMultipleBitstreams = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutPrimaryAndMultipleBitstreams = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        this.helper = new DefaultAccessStatusHelper();
        this.threshold = this.dateFrom(10000, 1, 1);
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutBundle);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutBitstream);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithBitstream);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithEmbargo);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithDateRestriction);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithGroupRestriction);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutPolicy);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutPrimaryBitstream);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithPrimaryAndMultipleBitstreams);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutPrimaryAndMultipleBitstreams);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.restoreAuthSystemState();
        this.itemWithoutBundle = null;
        this.itemWithoutBitstream = null;
        this.itemWithBitstream = null;
        this.itemWithEmbargo = null;
        this.itemWithDateRestriction = null;
        this.itemWithGroupRestriction = null;
        this.itemWithoutPolicy = null;
        this.itemWithoutPrimaryBitstream = null;
        this.itemWithPrimaryAndMultipleBitstreams = null;
        this.itemWithoutPrimaryAndMultipleBitstreams = null;
        this.collection = null;
        this.owningCommunity = null;
        this.helper = null;
        this.threshold = null;
        this.communityService = null;
        this.collectionService = null;
        this.itemService = null;
        this.workspaceItemService = null;
        this.installItemService = null;
        this.bundleService = null;
        this.bitstreamService = null;
        this.resourcePolicyService = null;
        this.groupService = null;
        try {
            super.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testWithNullItem() throws Exception {
        String status = this.helper.getAccessStatusFromItem(this.context, null, this.threshold);
        MatcherAssert.assertThat((String)"testWithNullItem 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"unknown"));
    }

    @Test
    public void testWithoutBundle() throws Exception {
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutBundle, this.threshold);
        MatcherAssert.assertThat((String)"testWithoutBundle 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"metadata.only"));
    }

    @Test
    public void testWithoutBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundleService.create(this.context, this.itemWithoutBitstream, "ORIGINAL");
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutBitstream, this.threshold);
        MatcherAssert.assertThat((String)"testWithoutBitstream 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"metadata.only"));
    }

    @Test
    public void testWithBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithBitstream, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithBitstream, this.threshold);
        MatcherAssert.assertThat((String)"testWithBitstream 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
    }

    @Test
    public void testWithEmbargo() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithEmbargo, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        policy.setRpName("Embargo");
        Group group = this.groupService.findByName(this.context, "Anonymous");
        policy.setGroup(group);
        policy.setAction(0);
        policy.setStartDate(this.dateFrom(9999, 12, 31));
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithEmbargo, this.threshold);
        MatcherAssert.assertThat((String)"testWithEmbargo 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        String embargoDate = this.helper.getEmbargoFromItem(this.context, this.itemWithEmbargo, this.threshold);
        MatcherAssert.assertThat((String)"testWithEmbargo 1", (Object)embargoDate, (Matcher)CoreMatchers.equalTo((Object)policy.getStartDate().toString()));
    }

    @Test
    public void testWithDateRestriction() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithDateRestriction, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        policy.setRpName("Restriction");
        Group group = this.groupService.findByName(this.context, "Anonymous");
        policy.setGroup(group);
        policy.setAction(0);
        policy.setStartDate(this.dateFrom(10000, 1, 1));
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithDateRestriction, this.threshold);
        MatcherAssert.assertThat((String)"testWithDateRestriction 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
    }

    @Test
    public void testWithGroupRestriction() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithGroupRestriction, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        policy.setRpName("Restriction");
        Group group = this.groupService.findByName(this.context, "Administrator");
        policy.setGroup(group);
        policy.setAction(0);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithGroupRestriction, this.threshold);
        MatcherAssert.assertThat((String)"testWithGroupRestriction 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
    }

    @Test
    public void testWithoutPolicy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithoutPolicy, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutPolicy, this.threshold);
        MatcherAssert.assertThat((String)"testWithoutPolicy 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
    }

    @Test
    public void testWithoutPrimaryBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithoutPrimaryBitstream, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "first");
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutPrimaryBitstream, this.threshold);
        MatcherAssert.assertThat((String)"testWithoutPrimaryBitstream 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
    }

    @Test
    public void testWithPrimaryAndMultipleBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithPrimaryAndMultipleBitstreams, "ORIGINAL");
        this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        Bitstream primaryBitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bundle.setPrimaryBitstreamID(primaryBitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        policy.setRpName("Embargo");
        Group group = this.groupService.findByName(this.context, "Anonymous");
        policy.setGroup(group);
        policy.setAction(0);
        policy.setStartDate(this.dateFrom(9999, 12, 31));
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)primaryBitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)primaryBitstream);
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithPrimaryAndMultipleBitstreams, this.threshold);
        MatcherAssert.assertThat((String)"testWithPrimaryAndMultipleBitstreams 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        String embargoDate = this.helper.getEmbargoFromItem(this.context, this.itemWithPrimaryAndMultipleBitstreams, this.threshold);
        MatcherAssert.assertThat((String)"testWithPrimaryAndMultipleBitstreams 1", (Object)embargoDate, (Matcher)CoreMatchers.equalTo((Object)policy.getStartDate().toString()));
    }

    @Test
    public void testWithNoPrimaryAndMultipleBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithoutPrimaryAndMultipleBitstreams, "ORIGINAL");
        this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        Bitstream anotherBitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        policy.setRpName("Embargo");
        Group group = this.groupService.findByName(this.context, "Anonymous");
        policy.setGroup(group);
        policy.setAction(0);
        policy.setStartDate(this.dateFrom(9999, 12, 31));
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)anotherBitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)anotherBitstream);
        this.context.restoreAuthSystemState();
        String status = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutPrimaryAndMultipleBitstreams, this.threshold);
        MatcherAssert.assertThat((String)"testWithNoPrimaryAndMultipleBitstreams 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        String embargoDate = this.helper.getEmbargoFromItem(this.context, this.itemWithEmbargo, this.threshold);
        MatcherAssert.assertThat((String)"testWithNoPrimaryAndMultipleBitstreams 1", (Object)embargoDate, (Matcher)CoreMatchers.equalTo(null));
    }

    private Date dateFrom(int year, int month, int day) {
        return Date.from(LocalDate.of(year, month, day).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }
}

