/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemExportCLIIT
extends AbstractIntegrationTestWithDatabase {
    private static final String zipFileName = "saf-export.zip";
    private static final String title = "A Tale of Two Cities";
    private static final String dateIssued = "1990";
    private static final String titleAlternative = "J'aime les Printemps";
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private Collection collection;
    private Path tempDir;
    private Path workDir;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withEntityType("Publication").build();
        this.context.restoreAuthSystemState();
        this.tempDir = Files.createTempDirectory("safExportTest", new FileAttribute[0]);
        File file = new File(this.configurationService.getProperty("org.dspace.app.itemexport.work.dir"));
        if (!file.exists()) {
            Files.createDirectory(Path.of(file.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        this.workDir = Path.of(file.getAbsolutePath(), new String[0]);
    }

    @Override
    @After
    public void destroy() throws Exception {
        PathUtils.deleteOnExit((Path)this.tempDir);
        for (Path path : Files.list(this.workDir).collect(Collectors.toList())) {
            PathUtils.deleteOnExit((Path)path);
        }
        super.destroy();
    }

    @Test
    public void exportCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item1 = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        Item item2 = ItemBuilder.createItem(this.context, this.collection).withTitle("A Tale of Two Cities 2").withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "COLLECTION", "-i", this.collection.getHandle(), "-d", this.tempDir.toString(), "-n", "1"};
        this.perfomExportScript(args);
        this.checkDir();
    }

    @Test
    public void exportZipCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item1 = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        Item item2 = ItemBuilder.createItem(this.context, this.collection).withTitle("A Tale of Two Cities 2").withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "COLLECTION", "-i", this.collection.getHandle(), "-d", this.tempDir.toString(), "-z", zipFileName, "-n", "1"};
        this.perfomExportScript(args);
        this.checkDir();
        this.checkZip(zipFileName);
    }

    @Test
    public void exportItemWithMetadataOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "ITEM", "-i", item.getHandle(), "-d", this.tempDir.toString(), "-n", "1"};
        this.perfomExportScript(args);
        this.checkDir();
    }

    @Test
    public void exportItemWithBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        String bitstreamContent = "TEST TEST TEST";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream = BitstreamBuilder.createBitstream(this.context, item, is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "ITEM", "-i", item.getHandle(), "-d", this.tempDir.toString(), "-n", "1"};
        this.perfomExportScript(args);
        this.checkDir();
    }

    @Test
    public void exportItemWithAnotherMetadataSchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).withMetadata("dcterms", "title", "", title).build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "ITEM", "-i", item.getHandle(), "-d", this.tempDir.toString(), "-n", "1"};
        this.perfomExportScript(args);
        this.checkDir();
    }

    @Test
    public void exportZipItemWithBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        String bitstreamContent = "TEST TEST TEST";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream = BitstreamBuilder.createBitstream(this.context, item, is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "ITEM", "-i", item.getHandle(), "-d", this.tempDir.toString(), "-z", zipFileName, "-n", "1"};
        this.perfomExportScript(args);
        this.checkDir();
        this.checkZip(zipFileName);
    }

    @Test
    public void migrateCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item1 = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        Item item2 = ItemBuilder.createItem(this.context, this.collection).withTitle("A Tale of Two Cities 2").withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "COLLECTION", "-i", this.collection.getHandle(), "-d", this.tempDir.toString(), "-n", "1", "-m"};
        this.perfomExportScript(args);
        this.checkDir();
        this.checkCollectionMigration();
        this.checkItemMigration(item1);
        this.checkItemMigration(item2);
    }

    @Test
    public void migrateItemWithMetadataOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "ITEM", "-i", item.getHandle(), "-d", this.tempDir.toString(), "-n", "1", "-m"};
        this.perfomExportScript(args);
        this.checkDir();
        this.checkItemMigration(item);
    }

    @Test
    public void migrateItemWithBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        String bitstreamContent = "TEST TEST TEST";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream = BitstreamBuilder.createBitstream(this.context, item, is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "ITEM", "-i", item.getHandle(), "-d", this.tempDir.toString(), "-n", "1", "-m"};
        this.perfomExportScript(args);
        this.checkDir();
        this.checkItemMigration(item);
    }

    @Test
    public void migrateItemWithAnotherMetadataSchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).withMetadata("dcterms", "title", "", title).build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"export", "-t", "ITEM", "-i", item.getHandle(), "-d", this.tempDir.toString(), "-n", "1", "-m"};
        this.perfomExportScript(args);
        this.checkDir();
        this.checkItemMigration(item);
    }

    private void checkDir() throws Exception {
        Assert.assertTrue((boolean)Files.list(this.tempDir).findAny().isPresent());
    }

    private void checkZip(String zipFileName) throws Exception {
        Assert.assertEquals((long)1L, (long)Files.list(this.tempDir).filter(b -> StringUtils.equals((CharSequence)b.getFileName().toString(), (CharSequence)zipFileName)).count());
    }

    private void checkCollectionMigration() throws Exception {
        Assert.assertNotNull((Object)this.collectionService.find(this.context, this.collection.getID()));
    }

    private void checkItemMigration(Item item) throws Exception {
        Assert.assertNotNull((Object)this.itemService.find(this.context, item.getID()));
    }

    private void perfomExportScript(String[] args) throws Exception {
        this.runDSpaceScript(args);
    }
}

