/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemHelpdeskStrategy;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class RequestItemHelpdeskStrategyTest
extends AbstractUnitTest {
    private static final String HELPDESK_ADDRESS = "helpdesk@example.com";
    private static final String AUTHOR_ADDRESS = "john.doe@example.com";
    private static ConfigurationService configurationService;
    private static EPersonService epersonService;
    private static EPerson johnDoe;
    private Item item;

    @BeforeClass
    public static void setUpClass() throws SQLException {
        AbstractBuilder.init();
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        epersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Context ctx = new Context();
        ctx.turnOffAuthorisationSystem();
        johnDoe = EPersonBuilder.createEPerson(ctx).withEmail(AUTHOR_ADDRESS).withNameInMetadata("John", "Doe").build();
        ctx.restoreAuthSystemState();
        ctx.complete();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        AbstractBuilder.cleanupObjects();
        AbstractBuilder.destroy();
    }

    @Before
    public void setUp() {
        this.context = new Context();
        this.context.setCurrentUser(johnDoe);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        this.item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(null);
    }

    @Test
    public void testGetRequestItemAuthor() throws Exception {
        RequestItemHelpdeskStrategy instance = new RequestItemHelpdeskStrategy();
        instance.configurationService = configurationService;
        instance.ePersonService = epersonService;
        configurationService.setProperty("request.item.helpdesk.override", (Object)"true");
        configurationService.setProperty("mail.helpdesk", (Object)HELPDESK_ADDRESS);
        List authors = instance.getRequestItemAuthor(this.context, this.item);
        Assert.assertEquals((String)"Wrong author address", (Object)HELPDESK_ADDRESS, (Object)((RequestItemAuthor)authors.get(0)).getEmail());
        configurationService.setProperty("request.item.helpdesk.override", (Object)"false");
        authors = instance.getRequestItemAuthor(this.context, this.item);
        Assert.assertEquals((String)"Wrong author address", (Object)AUTHOR_ADDRESS, (Object)((RequestItemAuthor)authors.get(0)).getEmail());
    }

    @Ignore
    @Test
    public void testGetHelpDeskPerson() throws Exception {
    }
}

