/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.alerts.service.SystemWideAlertService;
import org.dspace.app.ldn.factory.NotifyServiceFactory;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.ldn.service.NotifyPatternToTriggerService;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.app.suggestion.SolrSuggestionStorageService;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.util.AbstractBuilderCleanupUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.SiteService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.IndexingService;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.eperson.service.RegistrationDataService;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.service.OrcidHistoryService;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.service.ProcessService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.dspace.supervision.factory.SupervisionOrderServiceFactory;
import org.dspace.supervision.service.SupervisionOrderService;
import org.dspace.utils.DSpace;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.InProgressUserService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.WorkflowItemRoleService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;

public abstract class AbstractBuilder<T, S> {
    static CommunityService communityService;
    static CollectionService collectionService;
    static ItemService itemService;
    static InstallItemService installItemService;
    static WorkspaceItemService workspaceItemService;
    static XmlWorkflowItemService workflowItemService;
    static XmlWorkflowService workflowService;
    static EPersonService ePersonService;
    static GroupService groupService;
    static BundleService bundleService;
    static BitstreamService bitstreamService;
    static BitstreamFormatService bitstreamFormatService;
    static AuthorizeService authorizeService;
    static ResourcePolicyService resourcePolicyService;
    static IndexingService indexingService;
    static RegistrationDataService registrationDataService;
    static VersionHistoryService versionHistoryService;
    static ClaimedTaskService claimedTaskService;
    static InProgressUserService inProgressUserService;
    static PoolTaskService poolTaskService;
    static WorkflowItemRoleService workflowItemRoleService;
    static MetadataFieldService metadataFieldService;
    static MetadataSchemaService metadataSchemaService;
    static SiteService siteService;
    static RelationshipService relationshipService;
    static RelationshipTypeService relationshipTypeService;
    static EntityTypeService entityTypeService;
    static ProcessService processService;
    static RequestItemService requestItemService;
    static VersioningService versioningService;
    static OrcidHistoryService orcidHistoryService;
    static OrcidQueueService orcidQueueService;
    static OrcidTokenService orcidTokenService;
    static SystemWideAlertService systemWideAlertService;
    static SubmissionConfigService submissionConfigService;
    static SubscribeService subscribeService;
    static SupervisionOrderService supervisionOrderService;
    static NotifyService notifyService;
    static NotifyServiceInboundPatternService inboundPatternService;
    static NotifyPatternToTriggerService notifyPatternToTriggerService;
    static QAEventService qaEventService;
    static SolrSuggestionStorageService solrSuggestionService;
    static LDNMessageService ldnMessageService;
    protected Context context;
    private static final AbstractBuilderCleanupUtil abstractBuilderCleanupUtil;
    private static final Logger log;

    protected AbstractBuilder(Context context) {
        this.context = context;
        abstractBuilderCleanupUtil.addToMap(this);
    }

    public static void init() {
        communityService = ContentServiceFactory.getInstance().getCommunityService();
        collectionService = ContentServiceFactory.getInstance().getCollectionService();
        itemService = ContentServiceFactory.getInstance().getItemService();
        installItemService = ContentServiceFactory.getInstance().getInstallItemService();
        workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
        workflowItemService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowItemService();
        workflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
        ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        groupService = EPersonServiceFactory.getInstance().getGroupService();
        bundleService = ContentServiceFactory.getInstance().getBundleService();
        bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
        authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
        indexingService = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
        registrationDataService = EPersonServiceFactory.getInstance().getRegistrationDataService();
        versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
        metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
        metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
        siteService = ContentServiceFactory.getInstance().getSiteService();
        relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
        relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
        processService = ScriptServiceFactory.getInstance().getProcessService();
        requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();
        versioningService = (VersioningService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(VersioningService.class.getName(), VersioningService.class);
        claimedTaskService = XmlWorkflowServiceFactory.getInstance().getClaimedTaskService();
        inProgressUserService = XmlWorkflowServiceFactory.getInstance().getInProgressUserService();
        poolTaskService = XmlWorkflowServiceFactory.getInstance().getPoolTaskService();
        workflowItemRoleService = XmlWorkflowServiceFactory.getInstance().getWorkflowItemRoleService();
        orcidHistoryService = OrcidServiceFactory.getInstance().getOrcidHistoryService();
        orcidQueueService = OrcidServiceFactory.getInstance().getOrcidQueueService();
        orcidTokenService = OrcidServiceFactory.getInstance().getOrcidTokenService();
        systemWideAlertService = (SystemWideAlertService)DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SystemWideAlertService.class).get(0);
        try {
            submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();
        }
        catch (SubmissionConfigReaderException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        subscribeService = ContentServiceFactory.getInstance().getSubscribeService();
        supervisionOrderService = SupervisionOrderServiceFactory.getInstance().getSupervisionOrderService();
        notifyService = NotifyServiceFactory.getInstance().getNotifyService();
        inboundPatternService = NotifyServiceFactory.getInstance().getNotifyServiceInboundPatternService();
        notifyPatternToTriggerService = NotifyServiceFactory.getInstance().getNotifyPatternToTriggerService();
        qaEventService = (QAEventService)new DSpace().getSingletonService(QAEventService.class);
        solrSuggestionService = (SolrSuggestionStorageService)new DSpace().getSingletonService(SolrSuggestionStorageService.class);
        ldnMessageService = NotifyServiceFactory.getInstance().getLDNMessageService();
    }

    public static void destroy() {
        communityService = null;
        collectionService = null;
        itemService = null;
        installItemService = null;
        workspaceItemService = null;
        ePersonService = null;
        groupService = null;
        bundleService = null;
        bitstreamService = null;
        authorizeService = null;
        resourcePolicyService = null;
        indexingService = null;
        bitstreamFormatService = null;
        registrationDataService = null;
        versionHistoryService = null;
        claimedTaskService = null;
        inProgressUserService = null;
        poolTaskService = null;
        workflowItemRoleService = null;
        metadataFieldService = null;
        metadataSchemaService = null;
        siteService = null;
        relationshipService = null;
        relationshipTypeService = null;
        entityTypeService = null;
        processService = null;
        requestItemService = null;
        versioningService = null;
        orcidTokenService = null;
        systemWideAlertService = null;
        submissionConfigService = null;
        subscribeService = null;
        supervisionOrderService = null;
        notifyService = null;
        inboundPatternService = null;
        notifyPatternToTriggerService = null;
        qaEventService = null;
        ldnMessageService = null;
    }

    public static void cleanupObjects() throws Exception {
        abstractBuilderCleanupUtil.cleanupBuilders();
        try (Context c = new Context();){
            List bitstreams = bitstreamService.findAll(c);
            for (Bitstream bitstream : CollectionUtils.emptyIfNull((Collection)bitstreams)) {
                AbstractBuilder.expungeBitstream(c, bitstream);
            }
            c.complete();
        }
    }

    public static void cleanupBuilderCache() {
        abstractBuilderCleanupUtil.cleanupMap();
    }

    public abstract void cleanup() throws Exception;

    public abstract T build() throws SQLException, AuthorizeException;

    public abstract void delete(Context var1, T var2) throws Exception;

    protected abstract S getService();

    protected <B> B handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return null;
    }

    static void expungeBitstream(Context c, Bitstream bit) throws Exception {
        bit = (Bitstream)c.reloadEntity((ReloadableEntity)bit);
        c.turnOffAuthorisationSystem();
        if (bit != null) {
            bitstreamService.expunge(c, bit);
        }
    }

    static {
        abstractBuilderCleanupUtil = new AbstractBuilderCleanupUtil();
        log = LogManager.getLogger();
    }
}

