/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.time.Period;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.Group;

public class BitstreamBuilder
extends AbstractDSpaceObjectBuilder<Bitstream> {
    private Bitstream bitstream;
    private Item item;
    private Group readerGroup;

    protected BitstreamBuilder(Context context) {
        super(context);
    }

    public static BitstreamBuilder createBitstream(Context context, Item item, InputStream is) throws SQLException, AuthorizeException, IOException {
        BitstreamBuilder builder = new BitstreamBuilder(context);
        return builder.create(context, item, is);
    }

    public static BitstreamBuilder createBitstream(Context context, Bundle bundle, InputStream is) throws SQLException, AuthorizeException, IOException {
        BitstreamBuilder builder = new BitstreamBuilder(context);
        return builder.create(context, bundle, is);
    }

    public static BitstreamBuilder createBitstream(Context context, Item item, InputStream is, String bundleName) throws SQLException, AuthorizeException, IOException {
        BitstreamBuilder builder = new BitstreamBuilder(context);
        return builder.createInRequestedBundle(context, item, is, bundleName);
    }

    public static BitstreamBuilder createBitstream(Context context, Item item, InputStream is, String bundleName, boolean iiifEnabled) throws SQLException, AuthorizeException, IOException {
        BitstreamBuilder builder = new BitstreamBuilder(context);
        return builder.createInRequestedBundleWithIiifDisabled(context, item, is, bundleName, iiifEnabled);
    }

    private BitstreamBuilder create(Context context, Item item, InputStream is) throws SQLException, AuthorizeException, IOException {
        this.context = context;
        this.item = item;
        Bundle originalBundle = this.getOriginalBundle(item);
        this.bitstream = bitstreamService.create(context, originalBundle, is);
        return this;
    }

    private BitstreamBuilder create(Context context, Bundle bundle, InputStream is) throws SQLException, AuthorizeException, IOException {
        this.context = context;
        this.item = (Item)bundle.getItems().get(0);
        this.bitstream = bitstreamService.create(context, bundle, is);
        return this;
    }

    private BitstreamBuilder createInRequestedBundle(Context context, Item item, InputStream is, String bundleName) throws SQLException, AuthorizeException, IOException {
        this.context = context;
        this.item = item;
        Bundle bundle = this.getBundleByName(item, bundleName);
        this.bitstream = bitstreamService.create(context, bundle, is);
        return this;
    }

    private BitstreamBuilder createInRequestedBundleWithIiifDisabled(Context context, Item item, InputStream is, String bundleName, boolean iiifEnabled) throws SQLException, AuthorizeException, IOException {
        this.context = context;
        this.item = item;
        Bundle bundle = this.getBundleByNameAndIiiEnabled(item, bundleName, iiifEnabled);
        this.bitstream = bitstreamService.create(context, bundle, is);
        return this;
    }

    private Bundle getBundleByNameAndIiiEnabled(Item item, String bundleName, boolean iiifEnabled) throws SQLException, AuthorizeException {
        List bundles = itemService.getBundles(item, bundleName);
        Bundle targetBundle = null;
        if (bundles.size() < 1) {
            targetBundle = bundleService.create(this.context, item, bundleName);
            MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
            MetadataField iiifEnabledField = metadataFieldService.findByString(this.context, "dspace.iiif.enabled", '.');
            MetadataValue metadataValue = metadataValueService.create(this.context, (DSpaceObject)targetBundle, iiifEnabledField);
            metadataValue.setValue(String.valueOf(iiifEnabled));
        } else {
            targetBundle = (Bundle)bundles.iterator().next();
        }
        return targetBundle;
    }

    private Bundle getBundleByName(Item item, String bundleName) throws SQLException, AuthorizeException {
        List bundles = itemService.getBundles(item, bundleName);
        Bundle targetBundle = null;
        targetBundle = bundles.size() < 1 ? bundleService.create(this.context, item, bundleName) : (Bundle)bundles.iterator().next();
        return targetBundle;
    }

    public BitstreamBuilder withName(String name) throws SQLException {
        this.bitstream.setName(this.context, name);
        return this;
    }

    public BitstreamBuilder withDescription(String description) throws SQLException {
        this.bitstream.setDescription(this.context, description);
        return this;
    }

    public BitstreamBuilder withMimeType(String mimeType) throws SQLException {
        BitstreamFormat bf = bitstreamFormatService.findByMIMEType(this.context, mimeType);
        if (bf != null) {
            this.bitstream.setFormat(this.context, bf);
        }
        return this;
    }

    public BitstreamBuilder guessFormat() throws SQLException {
        this.bitstream.setFormat(this.context, bitstreamFormatService.guessFormat(this.context, this.bitstream));
        return this;
    }

    public BitstreamBuilder withFormat(String format) throws SQLException {
        bitstreamService.addMetadata(this.context, (DSpaceObject)this.bitstream, "dc", "format", null, null, format);
        return this;
    }

    public BitstreamBuilder withProvenance(String provenance) throws SQLException {
        bitstreamService.addMetadata(this.context, (DSpaceObject)this.bitstream, "dc", "description", "provenance", null, provenance);
        return this;
    }

    public BitstreamBuilder withIIIFDisabled() throws SQLException {
        bitstreamService.addMetadata(this.context, (DSpaceObject)this.bitstream, "dspace", "iiif", "enabled", null, "false");
        return this;
    }

    public BitstreamBuilder withIIIFLabel(String label) throws SQLException {
        bitstreamService.addMetadata(this.context, (DSpaceObject)this.bitstream, "iiif", "label", null, null, label);
        return this;
    }

    public BitstreamBuilder withIIIFCanvasWidth(int i) throws SQLException {
        bitstreamService.addMetadata(this.context, (DSpaceObject)this.bitstream, "iiif", "image", "width", null, String.valueOf(i));
        return this;
    }

    public BitstreamBuilder withIIIFCanvasHeight(int i) throws SQLException {
        bitstreamService.addMetadata(this.context, (DSpaceObject)this.bitstream, "iiif", "image", "height", null, String.valueOf(i));
        return this;
    }

    public BitstreamBuilder withIIIFToC(String toc) throws SQLException {
        bitstreamService.addMetadata(this.context, (DSpaceObject)this.bitstream, "iiif", "toc", null, null, toc);
        return this;
    }

    private Bundle getOriginalBundle(Item item) throws SQLException, AuthorizeException {
        List bundles = itemService.getBundles(item, "ORIGINAL");
        Bundle targetBundle = null;
        targetBundle = bundles.size() < 1 ? bundleService.create(this.context, item, "ORIGINAL") : (Bundle)bundles.iterator().next();
        return targetBundle;
    }

    public BitstreamBuilder withEmbargoPeriod(Period embargoPeriod) {
        return (BitstreamBuilder)this.setEmbargo(embargoPeriod, (DSpaceObject)this.bitstream);
    }

    public BitstreamBuilder withReaderGroup(Group group) {
        this.readerGroup = group;
        return this;
    }

    @Override
    public Bitstream build() {
        try {
            bitstreamService.update(this.context, (DSpaceObject)this.bitstream);
            itemService.update(this.context, (DSpaceObject)this.item);
            if (this.readerGroup != null) {
                this.setOnlyReadPermission((DSpaceObject)this.bitstream, this.readerGroup, null);
            }
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            return null;
        }
        return this.bitstream;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.bitstream = (Bitstream)c.reloadEntity((ReloadableEntity)this.bitstream);
            if (this.bitstream != null) {
                this.delete(c, this.bitstream);
                c.complete();
            }
        }
    }

    @Override
    protected DSpaceObjectService<Bitstream> getService() {
        return bitstreamService;
    }
}

