/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.builder.AbstractBuilder;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class LDNMessageBuilder
extends AbstractBuilder<LDNMessageEntity, LDNMessageService> {
    private static final Logger log = LogManager.getLogger();
    private LDNMessageEntity ldnMessageEntity;

    protected LDNMessageBuilder(Context context) {
        super(context);
    }

    @Override
    protected LDNMessageService getService() {
        return ldnMessageService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.ldnMessageEntity = (LDNMessageEntity)c.reloadEntity((ReloadableEntity)this.ldnMessageEntity);
            if (this.ldnMessageEntity != null) {
                this.delete(this.ldnMessageEntity);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, LDNMessageEntity ldnMessageEntity) throws Exception {
        if (ldnMessageEntity != null) {
            this.getService().delete(c, ldnMessageEntity);
        }
    }

    @Override
    public LDNMessageEntity build() {
        try {
            ldnMessageService.update(this.context, this.ldnMessageEntity);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SQLException | SearchServiceException e) {
            log.error((Object)e);
        }
        return this.ldnMessageEntity;
    }

    public void delete(LDNMessageEntity ldnMessageEntity) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            LDNMessageEntity nsEntity = (LDNMessageEntity)c.reloadEntity((ReloadableEntity)ldnMessageEntity);
            if (nsEntity != null) {
                this.getService().delete(c, nsEntity);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static LDNMessageBuilder createNotifyServiceBuilder(Context context, String id) {
        LDNMessageBuilder ldnMessageServiceBuilder = new LDNMessageBuilder(context);
        return ldnMessageServiceBuilder.create(context, id);
    }

    public static LDNMessageBuilder createNotifyServiceBuilder(Context context, Notification notification) {
        LDNMessageBuilder ldnMessageServiceBuilder = new LDNMessageBuilder(context);
        return ldnMessageServiceBuilder.create(context, notification);
    }

    private LDNMessageBuilder create(Context context, String id) {
        try {
            this.context = context;
            this.ldnMessageEntity = ldnMessageService.create(context, id);
        }
        catch (SQLException e) {
            log.warn("Failed to create the NotifyService", (Throwable)e);
        }
        return this;
    }

    private LDNMessageBuilder create(Context context, Notification notification) {
        try {
            this.context = context;
            this.ldnMessageEntity = ldnMessageService.create(context, notification, "127.0.0.1");
        }
        catch (SQLException e) {
            log.warn("Failed to create the NotifyService", (Throwable)e);
        }
        return this;
    }
}

