/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.builder.AbstractBuilder;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class NotifyServiceBuilder
extends AbstractBuilder<NotifyServiceEntity, NotifyService> {
    private static final Logger log = LogManager.getLogger();
    private NotifyServiceEntity notifyServiceEntity;

    protected NotifyServiceBuilder(Context context) {
        super(context);
    }

    @Override
    protected NotifyService getService() {
        return notifyService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.notifyServiceEntity = (NotifyServiceEntity)c.reloadEntity((ReloadableEntity)this.notifyServiceEntity);
            if (this.notifyServiceEntity != null) {
                this.delete(this.notifyServiceEntity);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, NotifyServiceEntity notifyServiceEntity) throws Exception {
        if (notifyServiceEntity != null) {
            this.getService().delete(c, notifyServiceEntity);
        }
    }

    @Override
    public NotifyServiceEntity build() {
        try {
            notifyService.update(this.context, this.notifyServiceEntity);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SQLException | SearchServiceException e) {
            log.error((Object)e);
        }
        return this.notifyServiceEntity;
    }

    public void delete(NotifyServiceEntity notifyServiceEntity) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            NotifyServiceEntity nsEntity = (NotifyServiceEntity)c.reloadEntity((ReloadableEntity)notifyServiceEntity);
            if (nsEntity != null) {
                this.getService().delete(c, nsEntity);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static NotifyServiceBuilder createNotifyServiceBuilder(Context context, String name) {
        NotifyServiceBuilder notifyServiceBuilder = new NotifyServiceBuilder(context);
        return notifyServiceBuilder.create(context, name);
    }

    private NotifyServiceBuilder create(Context context, String name) {
        try {
            this.context = context;
            this.notifyServiceEntity = notifyService.create(context, name);
        }
        catch (SQLException e) {
            log.warn("Failed to create the NotifyService", (Throwable)e);
        }
        return this;
    }

    public NotifyServiceBuilder withDescription(String description) {
        this.notifyServiceEntity.setDescription(description);
        return this;
    }

    public NotifyServiceBuilder withUrl(String url) {
        this.notifyServiceEntity.setUrl(url);
        return this;
    }

    public NotifyServiceBuilder withLdnUrl(String ldnUrl) {
        this.notifyServiceEntity.setLdnUrl(ldnUrl);
        return this;
    }

    public NotifyServiceBuilder withScore(BigDecimal score) {
        this.notifyServiceEntity.setScore(score);
        return this;
    }

    public NotifyServiceBuilder isEnabled(boolean enabled) {
        this.notifyServiceEntity.setEnabled(enabled);
        return this;
    }

    public NotifyServiceBuilder withLowerIp(String lowerIp) {
        this.notifyServiceEntity.setLowerIp(lowerIp);
        return this;
    }

    public NotifyServiceBuilder withUpperIp(String upperIp) {
        this.notifyServiceEntity.setUpperIp(upperIp);
        return this;
    }

    public static void deleteNotifyService(Integer id) throws SQLException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            NotifyServiceEntity notifyServiceEntity = notifyService.find(c, id);
            if (notifyServiceEntity != null) {
                notifyService.delete(c, notifyServiceEntity);
            }
            c.complete();
        }
    }
}

