/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DuplicateDetectionService;
import org.dspace.content.virtual.PotentialDuplicate;
import org.dspace.discovery.SearchServiceException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DuplicateDetectionTest
extends AbstractIntegrationTestWithDatabase {
    private DuplicateDetectionService duplicateDetectionService = ContentServiceFactory.getInstance().getDuplicateDetectionService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private Collection col;
    private Collection workflowCol;
    private Item item1;
    private Item item2;
    private Item item3;
    private final String item1IssueDate = "2011-10-17";
    private final String item1Subject = "ExtraEntry 1";
    private final String item1Title = "Public item I";
    private final String item1Author = "Smith, Donald";
    private static final Logger log = LogManager.getLogger();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("duplicate.enable", (Object)true);
        this.configurationService.setProperty("duplicate.comparison.distance", (Object)1);
        this.configurationService.setProperty("duplicate.comparison.normalise.lowercase", (Object)true);
        this.configurationService.setProperty("duplicate.comparison.normalise.whitespace", (Object)true);
        this.configurationService.setProperty("duplicate.comparison.solr.field", (Object)"deduplication_keyword");
        this.configurationService.setProperty("duplicate.comparison.metadata.field", (Object)new String[]{"dc.title"});
        this.configurationService.setProperty("duplicate.preview.metadata.field", (Object)new String[]{"dc.date.issued", "dc.subject"});
        this.context.turnOffAuthorisationSystem();
        this.context.setDispatcher("default");
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.col = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").build();
        this.workflowCol = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Workflow Collection").withWorkflowGroup("reviewer", this.admin).build();
        this.item1 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item I").withIssueDate("2011-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry 1").build();
        this.item2 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item II").withIssueDate("2012-10-17").withAuthor("Smith, Donald X.").withSubject("ExtraEntry 2").build();
        this.item3 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item III").withIssueDate("2013-10-17").withAuthor("Smith, Donald Y.").withSubject("ExtraEntry 3").build();
    }

    @Test
    public void testPotentialDuplicateInstantatation() {
        PotentialDuplicate potentialDuplicate = new PotentialDuplicate();
        TestCase.assertEquals((String)"Metadata value list size should be 0", (int)0, (int)potentialDuplicate.getMetadataValueList().size());
        TestCase.assertNull((String)"Title should be null", (Object)potentialDuplicate.getTitle());
    }

    @Test
    public void testPotentialDuplicateInstantiationWithItem() {
        PotentialDuplicate potentialDuplicate = new PotentialDuplicate(this.item1);
        TestCase.assertEquals((String)"UUID should match item1 uuid", (Object)this.item1.getID(), (Object)potentialDuplicate.getUuid());
        TestCase.assertEquals((String)"Title should match item1 title", (String)"Public item I", (String)potentialDuplicate.getTitle());
        TestCase.assertEquals((String)"Owning collection should match item1 owning collection", (String)this.item1.getOwningCollection().getName(), (String)potentialDuplicate.getOwningCollectionName());
        TestCase.assertEquals((String)"Metadata value list size should be 0", (int)0, (int)potentialDuplicate.getMetadataValueList().size());
    }

    @Test
    public void testSearchDuplicates() throws Exception {
        List potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(this.context, this.item1);
        int size = 1;
        TestCase.assertEquals((String)("Potential duplicates of item1 should have size " + size), (int)size, (int)potentialDuplicates.size());
        TestCase.assertEquals((String)"Item II should be be the detected duplicate", (Object)this.item2.getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(0)).getUuid());
        potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(this.context, this.item2);
        potentialDuplicates.sort(Comparator.comparing(PotentialDuplicate::getTitle));
        size = 2;
        TestCase.assertEquals((String)("Potential duplicates of item2 should have size " + size), (int)size, (int)potentialDuplicates.size());
        TestCase.assertEquals((String)"item1 should be the first detected duplicate", (Object)this.item1.getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(0)).getUuid());
        TestCase.assertEquals((String)"item3 should be be the second detected duplicate", (Object)this.item3.getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(1)).getUuid());
        Optional<String> foundDate = ((PotentialDuplicate)potentialDuplicates.get(0)).getMetadataValueList().stream().filter(metadataValue -> metadataValue.getMetadataField().toString('.').equals("dc.date.issued")).map(MetadataValue::getValue).findFirst();
        MatcherAssert.assertThat((String)"There should be an issue date found", (boolean)foundDate.isPresent());
        TestCase.assertEquals((String)"item1 issue date should match the duplicate obj metadata issue date", (String)"2011-10-17", (String)foundDate.get());
        Optional<String> foundSubject = ((PotentialDuplicate)potentialDuplicates.get(0)).getMetadataValueList().stream().filter(metadataValue -> metadataValue.getMetadataField().toString('.').equals("dc.subject")).map(MetadataValue::getValue).findFirst();
        MatcherAssert.assertThat((String)"There should be a subject found", (boolean)foundSubject.isPresent());
        TestCase.assertEquals((String)"item1 subject should match the duplicate obj metadata subject", (String)"ExtraEntry 1", (String)foundSubject.get());
        Optional<String> foundAuthor = ((PotentialDuplicate)potentialDuplicates.get(0)).getMetadataValueList().stream().filter(metadataValue -> metadataValue.getMetadataField().toString('.').equals("dc.contributor.author")).map(MetadataValue::getValue).findFirst();
        MatcherAssert.assertThat((String)"There should NOT be an author found", (boolean)foundAuthor.isEmpty());
    }

    @Test
    public void testSearchDuplicatesWithReservedSolrCharacters() throws Exception {
        Item item4 = ItemBuilder.createItem(this.context, this.col).withTitle("Testing: An Important Development Step").withIssueDate("2011-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry 1").build();
        Item item5 = ItemBuilder.createItem(this.context, this.col).withTitle("Testing an important development step").withIssueDate("2012-10-17").withAuthor("Smith, Donald X.").withSubject("ExtraEntry 2").build();
        List potentialDuplicates = new ArrayList();
        try {
            potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(this.context, item4);
        }
        catch (SearchServiceException e) {
            Assert.fail((String)("Duplicate search with special characters should NOT result in search exception (" + e.getMessage() + ")"));
        }
        int size = 1;
        TestCase.assertEquals((String)("Potential duplicates of item4 (special characters) should have size " + size), (int)size, (int)potentialDuplicates.size());
        TestCase.assertEquals((String)"Item 5 should be be the detected duplicate", (Object)item5.getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(0)).getUuid());
    }

    @Test
    public void testSearchDuplicatesWithVeryLongTitle() throws Exception {
        Item item6 = ItemBuilder.createItem(this.context, this.col).withTitle("Testing: This title is over 200 characters long and should behave just the same as a shorter title, with or without reserved characters. This integration test will prove that long titles are detected as potential duplicates.").withIssueDate("2011-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry 1").build();
        Item item7 = ItemBuilder.createItem(this.context, this.col).withTitle("Testing: This title is over 200 characters long and should behave just the same as a shorter title with or without reserved characters. This integration test will prove that long titles are detected as potential duplicates.").withIssueDate("2012-10-17").withAuthor("Smith, Donald X.").withSubject("ExtraEntry 2").build();
        List potentialDuplicates = new ArrayList();
        try {
            potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(this.context, item6);
        }
        catch (SearchServiceException e) {
            Assert.fail((String)("Duplicate search with special characters (long title) should NOT result in search exception (" + e.getMessage() + ")"));
        }
        int size = 1;
        TestCase.assertEquals((String)("Potential duplicates of item6 (long title) should have size " + size), (int)size, (int)potentialDuplicates.size());
        TestCase.assertEquals((String)"Item 7's long title should match Item 6 as a potential duplicate", (Object)item7.getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(0)).getUuid());
    }

    @Test
    public void testSearchDuplicatesExactMatch() throws Exception {
        this.configurationService.setProperty("duplicate.comparison.distance", (Object)0);
        Item item8 = ItemBuilder.createItem(this.context, this.col).withTitle("This integration test will prove that the edit distance of 0 results in an exact match").withIssueDate("2011-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry 1").build();
        Item item9 = ItemBuilder.createItem(this.context, this.col).withTitle("This integration test will prove that the edit distance of 0 results in an exact match").withIssueDate("2012-10-17").withAuthor("Smith, Donald X.").withSubject("ExtraEntry").build();
        Item item10 = ItemBuilder.createItem(this.context, this.col).withTitle("This integration test will prove that the edit distance of 0 results in an exact match.").withIssueDate("2012-10-17").withAuthor("Smith, Donald X.").withSubject("ExtraEntry").build();
        List potentialDuplicates = new ArrayList();
        try {
            potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(this.context, item8);
        }
        catch (SearchServiceException e) {
            Assert.fail((String)("Duplicate search with special characters (long title) should NOT result in search exception (" + e.getMessage() + ")"));
        }
        int size = 1;
        TestCase.assertEquals((String)("ONLY one exact match should be found (item 9) " + size), (int)size, (int)potentialDuplicates.size());
        TestCase.assertEquals((String)"Item 9 should match Item 8 as a potential duplicate", (Object)item9.getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(0)).getUuid());
    }

    @Test
    public void testSearchDuplicatesInWorkflow() throws Exception {
        this.context.turnOffAuthorisationSystem();
        XmlWorkflowItem workflowItem1 = WorkflowItemBuilder.createWorkflowItem(this.context, this.workflowCol).withTitle("Unique title").withSubmitter(this.eperson).build();
        XmlWorkflowItem workflowItem2 = WorkflowItemBuilder.createWorkflowItem(this.context, this.workflowCol).withTitle("Unique title").withSubmitter(this.eperson).build();
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(this.admin);
        List potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(this.context, workflowItem1.getItem());
        int size = 1;
        TestCase.assertEquals((String)("Potential duplicates of item1 should have size " + size), (int)size, (int)potentialDuplicates.size());
        TestCase.assertEquals((String)"Workflow item 2 should be be the detected duplicate", (Object)workflowItem2.getItem().getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(0)).getUuid());
    }

    @Test
    public void testSearchDuplicatesWithMultipleFields() throws Exception {
        this.configurationService.setProperty("duplicate.comparison.metadata.field", (Object)new String[]{"dc.title", "dc.contributor.author"});
        Item item10 = ItemBuilder.createItem(this.context, this.col).withTitle("Compare both title and author").withIssueDate("2011-10-17").withAuthor("Surname, F.").withSubject("ExtraEntry 1").build();
        Item item11 = ItemBuilder.createItem(this.context, this.col).withTitle("Compare both title and author").withIssueDate("2012-10-17").withAuthor("Surname, F.").withSubject("ExtraEntry 2").build();
        Item item12 = ItemBuilder.createItem(this.context, this.col).withTitle("Compare both title and author").withIssueDate("2012-10-17").withAuthor("Lastname, First.").withSubject("ExtraEntry 2").build();
        List potentialDuplicates = new ArrayList();
        try {
            potentialDuplicates = this.duplicateDetectionService.getPotentialDuplicates(this.context, item10);
        }
        catch (SearchServiceException e) {
            Assert.fail((String)("Duplicate search with title and author (" + e.getMessage() + ")"));
        }
        int size = 1;
        TestCase.assertEquals((String)("Potential duplicates of item10 (title + author) should have size " + size), (int)size, (int)potentialDuplicates.size());
        TestCase.assertEquals((String)"Item 11 should be be the detected duplicate", (Object)item11.getID(), (Object)((PotentialDuplicate)potentialDuplicates.get(0)).getUuid());
    }
}

