/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.List;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.RelationshipMetadataServiceIT;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class LeftTiltedRelationshipMetadataServiceIT
extends RelationshipMetadataServiceIT {
    @Override
    protected void initPublicationAuthor() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType authorEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Author").build();
        this.leftItem = ItemBuilder.createItem(this.context, this.col).build();
        this.rightItem = ItemBuilder.createItem(this.context, this.col2).withPersonIdentifierLastName("familyName").withPersonIdentifierFirstName("firstName").build();
        this.isAuthorOfPublicationRelationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publicationEntityType, authorEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null).build();
        this.isAuthorOfPublicationRelationshipType.setTilted(RelationshipType.Tilted.LEFT);
        this.relationshipTypeService.update(this.context, (Object)this.isAuthorOfPublicationRelationshipType);
        this.relationship = RelationshipBuilder.createRelationshipBuilder(this.context, this.leftItem, this.rightItem, this.isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
    }

    @Override
    @Test
    public void testGetAuthorRelationshipMetadata() throws Exception {
        this.initPublicationAuthor();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        List leftRelationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        MatcherAssert.assertThat((Object)leftRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)leftRelationshipMetadataList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        List leftList = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        MatcherAssert.assertThat((Object)leftList.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isAuthorOfPublication"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"latestForDiscovery"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(2)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(2)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(2)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isAuthorOfPublication"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(2)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(2)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        List rightRelationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.rightItem, MetadataSchemaEnum.RELATION.getName(), "isPublicationOfAuthor", null, "*");
        MatcherAssert.assertThat((Object)rightRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List rightList = this.relationshipMetadataService.getRelationshipMetadata(this.rightItem, true);
        MatcherAssert.assertThat((Object)rightList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }
}

