/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractIntegrationTest;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelationshipTypeDAOImplIT
extends AbstractIntegrationTest {
    private static final Logger log = LogManager.getLogger(RelationshipTypeDAOImplIT.class);
    private Relationship relationship;
    private Item itemOne;
    private Item itemTwo;
    private Collection collection;
    private Community owningCommunity;
    private RelationshipType relationshipType;
    private List<RelationshipType> relationshipTypeList = new ArrayList<RelationshipType>();
    private EntityType entityTypeOne;
    private EntityType entityTypeTwo;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    protected RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    protected EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
            WorkspaceItem workspaceItemTwo = this.workspaceItemService.create(this.context, this.collection, false);
            this.itemOne = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            this.itemTwo = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItemTwo);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.itemOne, "dspace", "entity", "type", "*", "Publication");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.itemTwo, "dspace", "entity", "type", "*", "Person");
            this.itemService.update(this.context, (DSpaceObject)this.itemOne);
            this.itemService.update(this.context, (DSpaceObject)this.itemTwo);
            this.entityTypeOne = this.entityTypeService.create(this.context, "Person");
            this.entityTypeTwo = this.entityTypeService.create(this.context, "Publication");
            this.relationshipType = this.relationshipTypeService.create(this.context, this.entityTypeTwo, this.entityTypeOne, "isAuthorOfPublication", "isPublicationOfAuthor", Integer.valueOf(0), Integer.valueOf(10), Integer.valueOf(0), Integer.valueOf(10));
            this.relationship = this.relationshipService.create(this.context, this.itemOne, this.itemTwo, this.relationshipType, 0, 0);
            this.relationshipService.update(this.context, (Object)this.relationship);
            this.relationshipTypeList.add(this.relationshipType);
            this.context.restoreAuthSystemState();
        }
        catch (Exception e) {
            log.error((Object)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.relationshipService.delete(this.context, (Object)this.relationship);
            this.relationshipTypeService.delete(this.context, (Object)this.relationshipType);
            this.entityTypeService.delete(this.context, (Object)this.entityTypeTwo);
            this.entityTypeService.delete(this.context, (Object)this.entityTypeOne);
            this.itemService.delete(this.context, (DSpaceObject)this.itemOne);
            this.itemService.delete(this.context, (DSpaceObject)this.itemTwo);
        }
        catch (Exception e) {
            log.error((Object)e);
            Assert.fail((String)e.getMessage());
        }
        super.destroy();
    }

    @Test
    public void testFindByTypesAndLabels() throws Exception {
        Assert.assertEquals((String)"TestFindbyTypesAndLabels 0", (Object)this.relationshipType, (Object)this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeTwo, this.entityTypeOne, "isAuthorOfPublication", "isPublicationOfAuthor"));
    }

    @Test
    public void testFindByLeftOrRightLabel() throws Exception {
        Assert.assertEquals((String)"TestFindByLeftOrRightLabel 0", this.relationshipTypeList, (Object)this.relationshipTypeService.findByLeftwardOrRightwardTypeName(this.context, "isAuthorOfPublication", Integer.valueOf(-1), Integer.valueOf(-1)));
    }

    @Test
    public void testFindByEntityType() throws Exception {
        Assert.assertEquals((String)"TestFindByEntityType 0", this.relationshipTypeList, (Object)this.relationshipTypeService.findByEntityType(this.context, this.entityTypeOne));
    }
}

