/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.script;

import eu.dnetlib.broker.BrokerClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.matcher.QAEventMatcher;
import org.dspace.matcher.QASourceMatcher;
import org.dspace.matcher.QATopicMatcher;
import org.dspace.qaevent.service.OpenaireClientFactory;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.qaevent.service.impl.OpenaireClientFactoryImpl;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jdom2.Document;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OpenaireEventsImportIT
extends AbstractIntegrationTestWithDatabase {
    private static final String ORDER_FIELD = "topic";
    private static final String BASE_JSON_DIR_PATH = "org/dspace/app/openaire-events/";
    private QAEventService qaEventService = (QAEventService)new DSpace().getSingletonService(QAEventService.class);
    private Collection collection;
    private BrokerClient brokerClient = OpenaireClientFactory.getInstance().getBrokerClient();
    private BrokerClient mockBrokerClient = (BrokerClient)Mockito.mock(BrokerClient.class);
    private ConfigurationService configurationService = new DSpace().getConfigurationService();

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("qaevents.sources", (Object)new String[]{"openaire"});
        ((OpenaireClientFactoryImpl)OpenaireClientFactory.getInstance()).setBrokerClient(this.mockBrokerClient);
    }

    @After
    public void after() {
        ((OpenaireClientFactoryImpl)OpenaireClientFactory.getInstance()).setBrokerClient(this.brokerClient);
    }

    @Test
    public void testWithoutParameters() throws Exception {
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.empty());
        Exception exception = handler.getException();
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"One parameter between the location of the file and the email must be entered to proceed with the import."));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testWithBothFileAndEmailParameters() throws Exception {
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-f", this.getFileLocation("events.json"), "-e", "test@user.com"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.empty());
        Exception exception = handler.getException();
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Only one parameter between the location of the file and the email must be entered to proceed with the import."));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testManyEventsImportFromFile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item firstItem = this.createItem("Test item", "123456789/99998");
        Item secondItem = this.createItem("Test item 2", "123456789/99999");
        this.context.restoreAuthSystemState();
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-f", this.getFileLocation("events.json")};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Trying to read the QA events from the provided file", "Found 5 events in the given file"}));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("openaire", 5L)));
        List topicList = this.qaEventService.findAllTopicsBySource(this.context, "openaire", 0L, 20L, ORDER_FIELD, false);
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MORE/PROJECT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MORE/PID", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/PID", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/PROJECT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/ABSTRACT", 1L)));
        String projectMessage = "{\"projects[0].acronym\":\"PAThs\",\"projects[0].code\":\"687567\",\"projects[0].funder\":\"EC\",\"projects[0].fundingProgram\":\"H2020\",\"projects[0].jurisdiction\":\"EU\",\"projects[0].openaireId\":\"40|corda__h2020::6e32f5eb912688f2424c68b851483ea4\",\"projects[0].title\":\"Tracking Papyrus and Parchment Paths\"}";
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MORE/PROJECT", 0L, 20, ORDER_FIELD, true), (Matcher)Matchers.contains((Matcher)QAEventMatcher.pendingOpenaireEventWith("oai:www.openstarts.units.it:123456789/99998", firstItem, "Egypt, crossroad of translations and literary interweavings", projectMessage, "ENRICH/MORE/PROJECT", 1.0)));
        String abstractMessage = "{\"abstracts[0]\":\"Missing Abstract\"}";
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MISSING/ABSTRACT", 0L, 20, ORDER_FIELD, true), (Matcher)Matchers.contains((Matcher)QAEventMatcher.pendingOpenaireEventWith("oai:www.openstarts.units.it:123456789/99999", secondItem, "Test Publication", abstractMessage, "ENRICH/MISSING/ABSTRACT", 1.0)));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testManyEventsImportFromFileWithUnknownHandle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = this.createItem("Test item", "123456789/99999");
        this.context.restoreAuthSystemState();
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-f", this.getFileLocation("events.json")};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.contains((Object[])new String[]{"An error occurs storing the event with id 406fb9c5656c7f11cac8995abb746887: Skipped event 406fb9c5656c7f11cac8995abb746887 related to the oai record oai:www.openstarts.units.it:123456789/99998 as the record was not found", "An error occurs storing the event with id eafd747feee49cca7603d30ba4e768dc: Skipped event eafd747feee49cca7603d30ba4e768dc related to the oai record oai:www.openstarts.units.it:123456789/99998 as the record was not found"}));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Trying to read the QA events from the provided file", "Found 5 events in the given file"}));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("openaire", 3L)));
        List topicList = this.qaEventService.findAllTopicsBySource(this.context, "openaire", 0L, 20L, ORDER_FIELD, false);
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/ABSTRACT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/PROJECT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MORE/PID", 1L)));
        String abstractMessage = "{\"abstracts[0]\":\"Missing Abstract\"}";
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MISSING/ABSTRACT", 0L, 20, ORDER_FIELD, false), (Matcher)Matchers.contains((Matcher)QAEventMatcher.pendingOpenaireEventWith("oai:www.openstarts.units.it:123456789/99999", item, "Test Publication", abstractMessage, "ENRICH/MISSING/ABSTRACT", 1.0)));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testManyEventsImportFromFileWithUnknownTopic() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createItem("Test item", "123456789/99999");
        Item secondItem = this.createItem("Test item 2", "123456789/999991");
        this.context.restoreAuthSystemState();
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-f", this.getFileLocation("unknown-topic-events.json")};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.contains((Object[])new String[]{"An error occurs storing the event with id 8307aa56769deba961faed7162d91aab: Skipped event 8307aa56769deba961faed7162d91aab related to the oai record oai:www.openstarts.units.it:123456789/99998 as the record was not found"}));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Trying to read the QA events from the provided file", "Found 2 events in the given file"}));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("openaire", 1L)));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllTopicsBySource(this.context, "openaire", 0L, 20L, ORDER_FIELD, false), (Matcher)Matchers.contains((Matcher)QATopicMatcher.with("ENRICH/MISSING/ABSTRACT", 1L)));
        String abstractMessage = "{\"abstracts[0]\":\"Missing Abstract\"}";
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MISSING/ABSTRACT", 0L, 20, ORDER_FIELD, false), (Matcher)Matchers.contains((Matcher)QAEventMatcher.pendingOpenaireEventWith("oai:www.openstarts.units.it:123456789/999991", secondItem, "Test Publication 2", abstractMessage, "ENRICH/MISSING/ABSTRACT", 1.0)));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testImportFromFileWithoutEvents() throws Exception {
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-f", this.getFileLocation("empty-file.json")};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.contains((Matcher)Matchers.containsString((String)"A not recoverable error occurs during OPENAIRE events import")));
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Trying to read the QA events from the provided file"}));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("openaire", 0L)));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllTopics(this.context, 0L, 20L, ORDER_FIELD, false), (Matcher)Matchers.empty());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testImportFromOpenaireBroker() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item firstItem = this.createItem("Test item", "123456789/99998");
        Item secondItem = this.createItem("Test item 2", "123456789/99999");
        Item thirdItem = this.createItem("Test item 3", "123456789/999991");
        this.context.restoreAuthSystemState();
        URL openaireURL = new URL("http://api.openaire.eu/broker");
        Mockito.when((Object)this.mockBrokerClient.listSubscriptions(openaireURL, "user@test.com")).thenReturn(List.of("sub1", "sub2", "sub3"));
        ((BrokerClient)Mockito.doAnswer(i -> this.writeToOutputStream((OutputStream)i.getArgument(2, OutputStream.class), "events.json")).when((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub1"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.doAnswer(i -> this.writeToOutputStream((OutputStream)i.getArgument(2, OutputStream.class), "empty-events-list.json")).when((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub2"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.doAnswer(i -> this.writeToOutputStream((OutputStream)i.getArgument(2, OutputStream.class), "unknown-topic-events.json")).when((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub3"), (OutputStream)ArgumentMatchers.any());
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-e", "user@test.com"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Event for topic ENRICH/MORE/UNKNOWN is not allowed in the qaevents.cfg"}));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Trying to read the QA events from the OPENAIRE broker", "Found 3 subscriptions related to the given email", "Found 5 events from the subscription sub1", "Found 0 events from the subscription sub2", "Found 2 events from the subscription sub3"}));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("openaire", 6L)));
        List topicList = this.qaEventService.findAllTopicsBySource(this.context, "openaire", 0L, 20L, ORDER_FIELD, false);
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MORE/PROJECT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MORE/PID", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/PID", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/PROJECT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/ABSTRACT", 2L)));
        String projectMessage = "{\"projects[0].acronym\":\"PAThs\",\"projects[0].code\":\"687567\",\"projects[0].funder\":\"EC\",\"projects[0].fundingProgram\":\"H2020\",\"projects[0].jurisdiction\":\"EU\",\"projects[0].openaireId\":\"40|corda__h2020::6e32f5eb912688f2424c68b851483ea4\",\"projects[0].title\":\"Tracking Papyrus and Parchment Paths\"}";
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MORE/PROJECT", 0L, 20, ORDER_FIELD, false), (Matcher)Matchers.contains((Matcher)QAEventMatcher.pendingOpenaireEventWith("oai:www.openstarts.units.it:123456789/99998", firstItem, "Egypt, crossroad of translations and literary interweavings", projectMessage, "ENRICH/MORE/PROJECT", 1.0)));
        String abstractMessage = "{\"abstracts[0]\":\"Missing Abstract\"}";
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MISSING/ABSTRACT", 0L, 20, ORDER_FIELD, false), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.pendingOpenaireEventWith("oai:www.openstarts.units.it:123456789/99999", secondItem, "Test Publication", abstractMessage, "ENRICH/MISSING/ABSTRACT", 1.0), QAEventMatcher.pendingOpenaireEventWith("oai:www.openstarts.units.it:123456789/999991", thirdItem, "Test Publication 2", abstractMessage, "ENRICH/MISSING/ABSTRACT", 1.0)}));
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).listSubscriptions(openaireURL, "user@test.com");
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub1"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub2"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub3"), (OutputStream)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testImportFromOpenaireBrokerWithErrorDuringListSubscription() throws Exception {
        URL openaireURL = new URL("http://api.openaire.eu/broker");
        Mockito.when((Object)this.mockBrokerClient.listSubscriptions(openaireURL, "user@test.com")).thenThrow(new Throwable[]{new RuntimeException("Connection refused")});
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-e", "user@test.com"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"A not recoverable error occurs during OPENAIRE events import: Connection refused"}));
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Trying to read the QA events from the OPENAIRE broker"}));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("openaire", 0L)));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllTopics(this.context, 0L, 20L, ORDER_FIELD, false), (Matcher)Matchers.empty());
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).listSubscriptions(openaireURL, "user@test.com");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    public void testImportFromOpenaireBrokerWithErrorDuringEventsDownload() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createItem("Test item", "123456789/99998");
        this.createItem("Test item 2", "123456789/99999");
        this.createItem("Test item 3", "123456789/999991");
        this.context.restoreAuthSystemState();
        URL openaireURL = new URL("http://api.openaire.eu/broker");
        Mockito.when((Object)this.mockBrokerClient.listSubscriptions(openaireURL, "user@test.com")).thenReturn(List.of("sub1", "sub2", "sub3"));
        ((BrokerClient)Mockito.doAnswer(i -> this.writeToOutputStream((OutputStream)i.getArgument(2, OutputStream.class), "events.json")).when((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub1"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Invalid subscription id")}).when((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub2"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.doAnswer(i -> this.writeToOutputStream((OutputStream)i.getArgument(2, OutputStream.class), "unknown-topic-events.json")).when((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub3"), (OutputStream)ArgumentMatchers.any());
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-e", "user@test.com"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"An error occurs downloading the events related to the subscription sub2: Invalid subscription id"}));
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Event for topic ENRICH/MORE/UNKNOWN is not allowed in the qaevents.cfg"}));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Trying to read the QA events from the OPENAIRE broker", "Found 3 subscriptions related to the given email", "Found 5 events from the subscription sub1", "Found 0 events from the subscription sub2", "Found 2 events from the subscription sub3"}));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("openaire", 6L)));
        List topicList = this.qaEventService.findAllTopicsBySource(this.context, "openaire", 0L, 20L, ORDER_FIELD, false);
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MORE/PROJECT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/PID", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MORE/PID", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/PROJECT", 1L)));
        MatcherAssert.assertThat((Object)topicList, (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with("ENRICH/MISSING/ABSTRACT", 2L)));
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MORE/PROJECT", 0L, 20, ORDER_FIELD, false), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.qaEventService.findEventsByTopic(this.context, "openaire", "ENRICH/MISSING/ABSTRACT", 0L, 20, ORDER_FIELD, false), (Matcher)Matchers.hasSize((int)2));
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).listSubscriptions(openaireURL, "user@test.com");
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub1"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub2"), (OutputStream)ArgumentMatchers.any());
        ((BrokerClient)Mockito.verify((Object)this.mockBrokerClient)).downloadEvents((URL)ArgumentMatchers.eq((Object)openaireURL), (String)ArgumentMatchers.eq((Object)"sub3"), (OutputStream)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    @Test
    @Ignore
    public void testImportFromFileEventMoreReview() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item firstItem = this.createItem("Test item", "123456789/99998");
        Item secondItem = this.createItem("Test item 2", "123456789/99999");
        this.context.restoreAuthSystemState();
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"import-openaire-events", "-f", this.getFileLocation("event-more-review.json")};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat((Object)this.qaEventService.findAllTopicsBySource(this.context, "coar-notify", 0L, 20L, ORDER_FIELD, false), (Matcher)Matchers.contains((Matcher)QATopicMatcher.with("ENRICH/MORE/REVIEW", 1L)));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with("coar-notify", 1L)));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockBrokerClient});
    }

    private Item createItem(String title, String handle) {
        return ItemBuilder.createItem(this.context, this.collection).withTitle(title).withHandle(handle).build();
    }

    private Void writeToOutputStream(OutputStream outputStream, String fileName) {
        try {
            byte[] fileContent = this.getFileContent(fileName);
            IOUtils.write((byte[])fileContent, (OutputStream)outputStream);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getFileContent(String fileName) throws Exception {
        String fileLocation = this.getFileLocation(fileName);
        try (FileInputStream fis = new FileInputStream(new File(fileLocation));){
            byte[] byArray = IOUtils.toByteArray((InputStream)fis);
            return byArray;
        }
    }

    private String getFileLocation(String fileName) throws Exception {
        URL resource = this.getClass().getClassLoader().getResource(BASE_JSON_DIR_PATH + fileName);
        if (resource == null) {
            throw new IllegalStateException("No resource found named org/dspace/app/openaire-events/" + fileName);
        }
        return new File(resource.getFile()).getAbsolutePath();
    }
}

