/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.util.ArrayList;
import org.dspace.AbstractUnitTest;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DSpaceCommandLineParameterTest
extends AbstractUnitTest {
    @Test
    public void constructorTest() {
        String key = "-c";
        String value = "test";
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(key, value);
        MatcherAssert.assertThat((String)"constructorTest 0", (Object)dSpaceCommandLineParameter.getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)"constructorTest 1", (Object)dSpaceCommandLineParameter.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void constructorTestNullValue() {
        String key = "-c";
        String value = null;
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(key, value);
        MatcherAssert.assertThat((String)"constructorTest 0", (Object)dSpaceCommandLineParameter.getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)"constructorTest 1", (Object)dSpaceCommandLineParameter.getValue(), (Matcher)CoreMatchers.equalTo(value));
    }

    @Test
    public void singleParameterConstructorTest() {
        String parameter = "-c test";
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(parameter);
        MatcherAssert.assertThat((String)"singleParameterConstructorTest 0", (Object)dSpaceCommandLineParameter.getName(), (Matcher)CoreMatchers.equalTo((Object)"-c"));
        MatcherAssert.assertThat((String)"singleParameterConstructorTest 1", (Object)dSpaceCommandLineParameter.getValue(), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    @Test
    public void singleParameterConstructorTestNoValue() {
        String parameter = "-c";
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(parameter);
        MatcherAssert.assertThat((String)"singleParameterConstructorTest 0", (Object)dSpaceCommandLineParameter.getName(), (Matcher)CoreMatchers.equalTo((Object)"-c"));
        MatcherAssert.assertThat((String)"singleParameterConstructorTest 1", (Object)dSpaceCommandLineParameter.getValue(), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void toStringTest() {
        String key = "-c";
        String value = "test";
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(key, value);
        MatcherAssert.assertThat((String)"toStringTest 0", (Object)dSpaceCommandLineParameter.getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)"toStringTest 1", (Object)dSpaceCommandLineParameter.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        MatcherAssert.assertThat((String)"toStringTest 2", (Object)dSpaceCommandLineParameter.toString(), (Matcher)CoreMatchers.equalTo((Object)"-c test"));
    }

    @Test
    public void toStringTestNullValue() {
        String key = "-c";
        String value = null;
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(key, value);
        MatcherAssert.assertThat((String)"toStringTest 0", (Object)dSpaceCommandLineParameter.getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)"toStringTest 1", (Object)dSpaceCommandLineParameter.getValue(), (Matcher)CoreMatchers.equalTo(value));
        MatcherAssert.assertThat((String)"toStringTest 2", (Object)dSpaceCommandLineParameter.toString(), (Matcher)CoreMatchers.equalTo((Object)"-c"));
    }

    @Test
    public void equalsTest() {
        String key = "-c";
        String value = "test";
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(key, value);
        DSpaceCommandLineParameter dSpaceCommandLineParameter1 = new DSpaceCommandLineParameter(key, value);
        MatcherAssert.assertThat((String)"toStringTest 0", (Object)dSpaceCommandLineParameter.getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)"toStringTest 1", (Object)dSpaceCommandLineParameter.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        MatcherAssert.assertThat((String)"toStringTest 0", (Object)dSpaceCommandLineParameter1.getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)"toStringTest 1", (Object)dSpaceCommandLineParameter1.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        Assert.assertTrue((boolean)dSpaceCommandLineParameter.equals((Object)dSpaceCommandLineParameter1));
    }

    @Test
    public void concatenateTest() {
        String key = "-c";
        String value = "test";
        DSpaceCommandLineParameter dSpaceCommandLineParameter = new DSpaceCommandLineParameter(key, value);
        DSpaceCommandLineParameter dSpaceCommandLineParameter1 = new DSpaceCommandLineParameter(key, value);
        String key2 = "-r";
        String value2 = "testing";
        DSpaceCommandLineParameter dSpaceCommandLineParameter2 = new DSpaceCommandLineParameter(key2, value2);
        String key3 = "-t";
        String value3 = null;
        DSpaceCommandLineParameter dSpaceCommandLineParameter3 = new DSpaceCommandLineParameter(key3, value3);
        ArrayList<DSpaceCommandLineParameter> dSpaceCommandLineParameterList = new ArrayList<DSpaceCommandLineParameter>();
        dSpaceCommandLineParameterList.add(dSpaceCommandLineParameter);
        dSpaceCommandLineParameterList.add(dSpaceCommandLineParameter1);
        dSpaceCommandLineParameterList.add(dSpaceCommandLineParameter2);
        dSpaceCommandLineParameterList.add(dSpaceCommandLineParameter3);
        String concatenedString = DSpaceCommandLineParameter.concatenate(dSpaceCommandLineParameterList);
        MatcherAssert.assertThat((String)"concatenateTest", (Object)concatenedString, (Matcher)CoreMatchers.equalTo((Object)(dSpaceCommandLineParameter.toString() + DSpaceCommandLineParameter.SEPARATOR + dSpaceCommandLineParameter1.toString() + DSpaceCommandLineParameter.SEPARATOR + dSpaceCommandLineParameter2.toString() + DSpaceCommandLineParameter.SEPARATOR + dSpaceCommandLineParameter3.toString())));
    }
}

