/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.service.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.AbstractDSpaceTest;
import org.dspace.service.impl.HttpConnectionPoolService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mockserver.client.MockServerClient;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;

public class HttpConnectionPoolServiceTest
extends AbstractDSpaceTest {
    private static ConfigurationService configurationService;
    @Rule
    public MockServerRule mockServerRule = new MockServerRule((Object)this);
    private MockServerClient mockServerClient;

    @BeforeClass
    public static void initClass() {
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    @Test
    public void testGetClient() throws IOException, URISyntaxException {
        System.out.println("getClient");
        configurationService.setProperty("solr.client.maxTotalConnections", (Object)2);
        configurationService.setProperty("solr.client.maxPerRoute", (Object)2);
        HttpConnectionPoolService instance = new HttpConnectionPoolService("solr");
        instance.configurationService = configurationService;
        instance.init();
        String testPath = "/test";
        this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath("/test")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        try (CloseableHttpClient httpClient = instance.getClient();){
            Assert.assertNotNull((String)"getClient should always return a client", (Object)httpClient);
            URI uri = new URIBuilder().setScheme("http").setHost("localhost").setPort(this.mockServerClient.getPort().intValue()).setPath("/test").build();
            System.out.println(uri.toString());
            HttpUriRequest request = RequestBuilder.get((URI)uri).build();
            try (CloseableHttpResponse response = httpClient.execute(request);){
                Assert.assertEquals((String)"Response status should be OK", (long)200L, (long)response.getStatusLine().getStatusCode());
            }
        }
    }
}

