/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.dspace.core.Context;
import org.dspace.statistics.export.OpenURLTracker;
import org.dspace.statistics.export.service.FailedOpenURLTrackerService;
import org.dspace.statistics.export.service.OpenUrlServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class OpenUrlServiceImplTest {
    private OpenUrlServiceImpl openUrlService;
    @Mock
    private FailedOpenURLTrackerService failedOpenURLTrackerService;
    @Mock
    private HttpClient httpClient;

    @Before
    public void setUp() throws Exception {
        this.openUrlService = (OpenUrlServiceImpl)Mockito.spy(OpenUrlServiceImpl.class);
        this.openUrlService.failedOpenUrlTrackerService = this.failedOpenURLTrackerService;
        ((OpenUrlServiceImpl)Mockito.doReturn((Object)this.httpClient).when((Object)this.openUrlService)).getHttpClient((RequestConfig)ArgumentMatchers.any());
    }

    protected HttpResponse createMockHttpResponse(int statusCode) {
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)statusCode);
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        return httpResponse;
    }

    protected OpenURLTracker createMockTracker(String url) {
        OpenURLTracker tracker = (OpenURLTracker)Mockito.mock(OpenURLTracker.class);
        Mockito.when((Object)tracker.getUrl()).thenReturn((Object)url);
        return tracker;
    }

    @Test
    public void testProcessUrl() throws IOException, SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        ((HttpClient)Mockito.doReturn((Object)this.createMockHttpResponse(200)).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        this.openUrlService.processUrl(context, "test-url");
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService, (VerificationMode)Mockito.times((int)0))).logfailed(context, "test-url");
    }

    @Test
    public void testProcessUrlOnFail() throws IOException, SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        ((HttpClient)Mockito.doReturn((Object)this.createMockHttpResponse(500)).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        ((OpenUrlServiceImpl)Mockito.doNothing().when((Object)this.openUrlService)).logfailed((Context)ArgumentMatchers.any(Context.class), ArgumentMatchers.anyString());
        this.openUrlService.processUrl(context, "test-url");
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService, (VerificationMode)Mockito.times((int)1))).logfailed(context, "test-url");
    }

    @Test
    public void testReprocessFailedQueue() throws IOException, SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        List<OpenURLTracker> trackers = List.of(this.createMockTracker("tacker1"), this.createMockTracker("tacker2"), this.createMockTracker("tacker3"));
        Mockito.when((Object)this.failedOpenURLTrackerService.findAll((Context)ArgumentMatchers.any(Context.class))).thenReturn(trackers);
        ((HttpClient)Mockito.doReturn((Object)this.createMockHttpResponse(500), (Object[])new Object[]{this.createMockHttpResponse(404), this.createMockHttpResponse(200)}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        this.openUrlService.reprocessFailedQueue(context);
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService, (VerificationMode)Mockito.times((int)3))).tryReprocessFailed((Context)ArgumentMatchers.any(Context.class), (OpenURLTracker)ArgumentMatchers.any(OpenURLTracker.class));
        ((FailedOpenURLTrackerService)Mockito.verify((Object)this.failedOpenURLTrackerService, (VerificationMode)Mockito.times((int)0))).remove((Context)ArgumentMatchers.any(Context.class), (OpenURLTracker)ArgumentMatchers.eq((Object)trackers.get(0)));
        ((FailedOpenURLTrackerService)Mockito.verify((Object)this.failedOpenURLTrackerService, (VerificationMode)Mockito.times((int)0))).remove((Context)ArgumentMatchers.any(Context.class), (OpenURLTracker)ArgumentMatchers.eq((Object)trackers.get(1)));
        ((FailedOpenURLTrackerService)Mockito.verify((Object)this.failedOpenURLTrackerService, (VerificationMode)Mockito.times((int)1))).remove((Context)ArgumentMatchers.any(Context.class), (OpenURLTracker)ArgumentMatchers.eq((Object)trackers.get(2)));
    }

    @Test
    public void testLogfailed() throws SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        OpenURLTracker tracker1 = (OpenURLTracker)Mockito.mock(OpenURLTracker.class);
        Mockito.when((Object)this.failedOpenURLTrackerService.create((Context)ArgumentMatchers.any(Context.class))).thenReturn((Object)tracker1);
        String failedUrl = "failed-url";
        this.openUrlService.logfailed(context, failedUrl);
        ((OpenURLTracker)Mockito.verify((Object)tracker1)).setUrl(failedUrl);
        ArgumentCaptor dateArgCaptor = ArgumentCaptor.forClass(Date.class);
        ((OpenURLTracker)Mockito.verify((Object)tracker1)).setUploadDate((Date)dateArgCaptor.capture());
        MatcherAssert.assertThat((Object)new BigDecimal(((Date)dateArgCaptor.getValue()).getTime()), (Matcher)Matchers.closeTo((BigDecimal)new BigDecimal(new Date().getTime()), (BigDecimal)new BigDecimal(5000)));
    }

    @Test
    public void testTimeout() throws IOException, SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        ((HttpClient)Mockito.doReturn((Object)this.createMockHttpResponse(200)).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        this.openUrlService.processUrl(context, "test-url");
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService)).getHttpClient((RequestConfig)ArgumentMatchers.any());
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService)).getHttpClientRequestConfig();
        MatcherAssert.assertThat((Object)this.openUrlService.getHttpClientRequestConfig().getConnectTimeout(), (Matcher)CoreMatchers.is((Object)10000));
    }
}

