/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectMetadata;
import io.findify.s3mock.S3Mock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.storage.bitstore.S3BitStoreService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class S3BitStoreServiceIT
extends AbstractIntegrationTestWithDatabase {
    private static final String DEFAULT_BUCKET_NAME = "dspace-asset-localhost";
    private S3BitStoreService s3BitStoreService;
    private AmazonS3 amazonS3Client;
    private S3Mock s3Mock;
    private Collection collection;
    private File s3Directory;
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Before
    public void setup() throws Exception {
        this.configurationService.setProperty("assetstore.s3.enabled", (Object)"true");
        this.s3Directory = new File(System.getProperty("java.io.tmpdir"), "s3");
        this.s3Mock = S3Mock.create((int)8001, (String)this.s3Directory.getAbsolutePath());
        this.s3Mock.start();
        this.amazonS3Client = this.createAmazonS3Client();
        this.s3BitStoreService = new S3BitStoreService(this.amazonS3Client);
        this.s3BitStoreService.setEnabled(BooleanUtils.toBoolean((String)this.configurationService.getProperty("assetstore.s3.enabled")));
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).build();
        this.context.restoreAuthSystemState();
    }

    @After
    public void cleanUp() throws IOException {
        FileUtils.deleteDirectory((File)this.s3Directory);
        this.s3Mock.shutdown();
    }

    @Test
    public void testBitstreamPutAndGetWithAlreadyPresentBucket() throws IOException {
        String bucketName = "testbucket";
        this.amazonS3Client.createBucket(bucketName);
        this.s3BitStoreService.setBucketName(bucketName);
        this.s3BitStoreService.init();
        MatcherAssert.assertThat((Object)this.amazonS3Client.listBuckets(), (Matcher)Matchers.contains(this.bucketNamed(bucketName)));
        this.context.turnOffAuthorisationSystem();
        String content = "Test bitstream content";
        Bitstream bitstream = this.createBitstream(content);
        this.context.restoreAuthSystemState();
        this.s3BitStoreService.put(bitstream, this.toInputStream(content));
        String expectedChecksum = Utils.toHex((byte[])this.generateChecksum(content));
        MatcherAssert.assertThat((Object)bitstream.getSizeBytes(), (Matcher)Matchers.is((Object)content.length()));
        MatcherAssert.assertThat((Object)bitstream.getChecksum(), (Matcher)Matchers.is((Object)expectedChecksum));
        MatcherAssert.assertThat((Object)bitstream.getChecksumAlgorithm(), (Matcher)Matchers.is((Object)"MD5"));
        InputStream inputStream = this.s3BitStoreService.get(bitstream);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)content));
        String key = this.s3BitStoreService.getFullKey(bitstream.getInternalId());
        ObjectMetadata objectMetadata = this.amazonS3Client.getObjectMetadata(bucketName, key);
        MatcherAssert.assertThat((Object)objectMetadata.getContentMD5(), (Matcher)Matchers.is((Object)expectedChecksum));
    }

    @Test
    public void testBitstreamPutAndGetWithoutSpecifingBucket() throws IOException {
        this.s3BitStoreService.init();
        MatcherAssert.assertThat((Object)this.s3BitStoreService.getBucketName(), (Matcher)Matchers.is((Object)DEFAULT_BUCKET_NAME));
        MatcherAssert.assertThat((Object)this.amazonS3Client.listBuckets(), (Matcher)Matchers.contains(this.bucketNamed(DEFAULT_BUCKET_NAME)));
        this.context.turnOffAuthorisationSystem();
        String content = "Test bitstream content";
        Bitstream bitstream = this.createBitstream(content);
        this.context.restoreAuthSystemState();
        this.s3BitStoreService.put(bitstream, this.toInputStream(content));
        String expectedChecksum = Utils.toHex((byte[])this.generateChecksum(content));
        MatcherAssert.assertThat((Object)bitstream.getSizeBytes(), (Matcher)Matchers.is((Object)content.length()));
        MatcherAssert.assertThat((Object)bitstream.getChecksum(), (Matcher)Matchers.is((Object)expectedChecksum));
        MatcherAssert.assertThat((Object)bitstream.getChecksumAlgorithm(), (Matcher)Matchers.is((Object)"MD5"));
        InputStream inputStream = this.s3BitStoreService.get(bitstream);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)content));
        String key = this.s3BitStoreService.getFullKey(bitstream.getInternalId());
        ObjectMetadata objectMetadata = this.amazonS3Client.getObjectMetadata(DEFAULT_BUCKET_NAME, key);
        MatcherAssert.assertThat((Object)objectMetadata.getContentMD5(), (Matcher)Matchers.is((Object)expectedChecksum));
    }

    @Test
    public void testBitstreamPutAndGetWithSubFolder() throws IOException {
        this.s3BitStoreService.setSubfolder("test/DSpace7/");
        this.s3BitStoreService.init();
        this.context.turnOffAuthorisationSystem();
        String content = "Test bitstream content";
        Bitstream bitstream = this.createBitstream(content);
        this.context.restoreAuthSystemState();
        this.s3BitStoreService.put(bitstream, this.toInputStream(content));
        InputStream inputStream = this.s3BitStoreService.get(bitstream);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)content));
        String key = this.s3BitStoreService.getFullKey(bitstream.getInternalId());
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.startsWith((String)"test/DSpace7/"));
        ObjectMetadata objectMetadata = this.amazonS3Client.getObjectMetadata(DEFAULT_BUCKET_NAME, key);
        MatcherAssert.assertThat((Object)objectMetadata, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBitstreamDeletion() throws IOException {
        this.s3BitStoreService.init();
        this.context.turnOffAuthorisationSystem();
        String content = "Test bitstream content";
        Bitstream bitstream = this.createBitstream(content);
        this.context.restoreAuthSystemState();
        this.s3BitStoreService.put(bitstream, this.toInputStream(content));
        MatcherAssert.assertThat((Object)this.s3BitStoreService.get(bitstream), (Matcher)Matchers.notNullValue());
        this.s3BitStoreService.remove(bitstream);
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> this.s3BitStoreService.get(bitstream));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)Matchers.instanceOf(AmazonS3Exception.class));
        MatcherAssert.assertThat((Object)((AmazonS3Exception)exception.getCause()).getStatusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void testAbout() throws IOException {
        this.s3BitStoreService.init();
        this.context.turnOffAuthorisationSystem();
        String content = "Test bitstream content";
        Bitstream bitstream = this.createBitstream(content);
        this.context.restoreAuthSystemState();
        this.s3BitStoreService.put(bitstream, this.toInputStream(content));
        Map about = this.s3BitStoreService.about(bitstream, List.of());
        MatcherAssert.assertThat((Object)about.size(), (Matcher)Matchers.is((Object)0));
        about = this.s3BitStoreService.about(bitstream, List.of("size_bytes"));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Object)"size_bytes", (Object)22L));
        MatcherAssert.assertThat((Object)about.size(), (Matcher)Matchers.is((Object)1));
        about = this.s3BitStoreService.about(bitstream, List.of("size_bytes", "modified"));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Object)"size_bytes", (Object)22L));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"modified"), (Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)about.size(), (Matcher)Matchers.is((Object)2));
        String expectedChecksum = Utils.toHex((byte[])this.generateChecksum(content));
        about = this.s3BitStoreService.about(bitstream, List.of("size_bytes", "modified", "checksum"));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Object)"size_bytes", (Object)22L));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"modified"), (Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Object)"checksum", (Object)expectedChecksum));
        MatcherAssert.assertThat((Object)about.size(), (Matcher)Matchers.is((Object)3));
        about = this.s3BitStoreService.about(bitstream, List.of("size_bytes", "modified", "checksum", "checksum_algorithm"));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Object)"size_bytes", (Object)22L));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"modified"), (Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Object)"checksum", (Object)expectedChecksum));
        MatcherAssert.assertThat((Object)about, (Matcher)Matchers.hasEntry((Object)"checksum_algorithm", (Object)"MD5"));
        MatcherAssert.assertThat((Object)about.size(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void handleRegisteredIdentifierPrefixInS3() {
        String trueBitStreamId = "012345";
        Objects.requireNonNull(this.s3BitStoreService);
        String registeredBitstreamId = "-R" + trueBitStreamId;
        Assert.assertTrue((boolean)this.s3BitStoreService.isRegisteredBitstream(registeredBitstreamId));
    }

    @Test
    public void stripRegisteredBitstreamPrefixWhenCalculatingPath() {
        String s3Path = "UNIQUE_S3_PATH/test/bitstream.pdf";
        Objects.requireNonNull(this.s3BitStoreService);
        String registeredBitstreamId = "-R" + s3Path;
        String relativeRegisteredPath = this.s3BitStoreService.getRelativePath(registeredBitstreamId);
        Assert.assertEquals((Object)s3Path, (Object)relativeRegisteredPath);
    }

    @Test
    public void givenBitStreamIdentifierLongerThanPossibleWhenIntermediatePathIsComputedThenIsSplittedAndTruncated() {
        String path = "01234567890123456789";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "45" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenBitStreamIdentifierShorterThanAFolderLengthWhenIntermediatePathIsComputedThenIsSingleFolder() {
        String path = "0";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "0" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenPartialBitStreamIdentifierWhenIntermediatePathIsComputedThenIsCompletlySplitted() {
        String path = "01234";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "4" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenMaxLengthBitStreamIdentifierWhenIntermediatePathIsComputedThenIsSplittedAllAsSubfolder() {
        String path = "012345";
        String computedPath = this.s3BitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "45" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenBitStreamIdentifierWhenIntermediatePathIsComputedThenNotEndingDoubleSlash() throws IOException {
        StringBuilder path = new StringBuilder("01");
        String computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        int slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("2");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("3");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("4");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("56789");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
    }

    @Test
    public void givenBitStreamIdentidierWhenIntermediatePathIsComputedThenMustBeSplitted() throws IOException {
        StringBuilder path = new StringBuilder("01");
        String computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        int slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("2");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("3");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("4");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("56789");
        computedPath = this.s3BitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
    }

    @Test
    public void givenBitStreamIdentifierWithSlashesWhenSanitizedThenSlashesMustBeRemoved() {
        String sInternalId = "01" + File.separator + "22" + File.separator + "33" + File.separator + "4455";
        String computedPath = this.s3BitStoreService.sanitizeIdentifier(sInternalId);
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)File.separator)));
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)File.separator)));
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)File.separator)));
    }

    @Test
    public void testDoNotInitializeConfigured() throws Exception {
        String assetstores3enabledOldValue = this.configurationService.getProperty("assetstore.s3.enabled");
        this.configurationService.setProperty("assetstore.s3.enabled", (Object)"false");
        this.s3BitStoreService = new S3BitStoreService(this.amazonS3Client);
        this.s3BitStoreService.init();
        Assert.assertFalse((boolean)this.s3BitStoreService.isInitialized());
        Assert.assertFalse((boolean)this.s3BitStoreService.isEnabled());
        this.configurationService.setProperty("assetstore.s3.enabled", (Object)assetstores3enabledOldValue);
    }

    private byte[] generateChecksum(String content) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(content.getBytes());
            return m.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private AmazonS3 createAmazonS3Client() {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("http://127.0.0.1:8001", Regions.DEFAULT_REGION.getName()))).build();
    }

    private Item createItem() {
        return ItemBuilder.createItem(this.context, this.collection).withTitle("Test item").build();
    }

    private Bitstream createBitstream(String content) {
        try {
            return BitstreamBuilder.createBitstream(this.context, this.createItem(), this.toInputStream(content)).build();
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }

    private Matcher<? super Bucket> bucketNamed(String name) {
        return LambdaMatcher.matches(bucket -> bucket.getName().equals(name));
    }

    private InputStream toInputStream(String content) {
        return IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);
    }

    private int computeSlashes(String internalId) {
        int minimum = internalId.length();
        int slashesPerLevel = minimum / 2;
        int odd = Math.min(1, minimum % 2);
        int slashes = slashesPerLevel + odd;
        return Math.min(slashes, 3);
    }
}

