/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionProvider;
import org.dspace.app.suggestion.SuggestionService;
import org.dspace.app.suggestion.SuggestionSource;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.core.Context;
import org.springframework.stereotype.Service;

@Service
public class SuggestionServiceImpl
implements SuggestionService {
    private static final Logger log = LogManager.getLogger(SuggestionServiceImpl.class);
    @Resource(name="suggestionProviders")
    private Map<String, SuggestionProvider> providersMap;

    @Override
    public List<SuggestionProvider> getSuggestionProviders() {
        if (this.providersMap != null) {
            return this.providersMap.values().stream().collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public SuggestionTarget find(Context context, String source, UUID id) {
        if (this.providersMap.containsKey(source)) {
            return this.providersMap.get(source).findTarget(context, id);
        }
        return null;
    }

    @Override
    public long countAll(Context context, String source) {
        if (this.providersMap.containsKey(source)) {
            return this.providersMap.get(source).countAllTargets(context);
        }
        return 0L;
    }

    @Override
    public List<SuggestionTarget> findAllTargets(Context context, String source, int pageSize, long offset) {
        if (this.providersMap.containsKey(source)) {
            return this.providersMap.get(source).findAllTargets(context, pageSize, offset);
        }
        return null;
    }

    @Override
    public long countAllByTarget(Context context, UUID target) {
        int count = 0;
        for (String provider : this.providersMap.keySet()) {
            if (this.providersMap.get(provider).countUnprocessedSuggestionByTarget(context, target) <= 0L) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<SuggestionTarget> findByTarget(Context context, UUID target, int pageSize, long offset) {
        ArrayList<SuggestionTarget> fullSourceTargets = new ArrayList<SuggestionTarget>();
        for (String source : this.providersMap.keySet()) {
            SuggestionTarget sTarget = this.providersMap.get(source).findTarget(context, target);
            if (sTarget == null || sTarget.getTotal() <= 0) continue;
            fullSourceTargets.add(sTarget);
        }
        fullSourceTargets.sort(new Comparator<SuggestionTarget>(){

            @Override
            public int compare(SuggestionTarget arg0, SuggestionTarget arg1) {
                return -(arg0.getTotal() - arg1.getTotal());
            }
        });
        return fullSourceTargets.stream().skip(offset).limit(pageSize).collect(Collectors.toList());
    }

    @Override
    public long countSources(Context context) {
        return this.providersMap.size();
    }

    @Override
    public SuggestionSource findSource(Context context, String source) {
        if (this.providersMap.containsKey(source)) {
            SuggestionSource ssource = new SuggestionSource(source);
            ssource.setTotal((int)this.providersMap.get(source).countAllTargets(context));
            return ssource;
        }
        return null;
    }

    @Override
    public List<SuggestionSource> findAllSources(Context context, int pageSize, long offset) {
        List<SuggestionSource> fullSources = this.getSources(context).stream().skip(offset).limit(pageSize).collect(Collectors.toList());
        return fullSources;
    }

    private List<SuggestionSource> getSources(Context context) {
        ArrayList<SuggestionSource> results = new ArrayList<SuggestionSource>();
        for (String source : this.providersMap.keySet()) {
            SuggestionSource ssource = new SuggestionSource(source);
            ssource.setTotal((int)this.providersMap.get(source).countAllTargets(context));
            results.add(ssource);
        }
        return results;
    }

    @Override
    public long countAllByTargetAndSource(Context context, String source, UUID target) {
        if (this.providersMap.containsKey(source)) {
            return this.providersMap.get(source).countUnprocessedSuggestionByTarget(context, target);
        }
        return 0L;
    }

    @Override
    public List<Suggestion> findByTargetAndSource(Context context, UUID target, String source, int pageSize, long offset, boolean ascending) {
        if (this.providersMap.containsKey(source)) {
            return this.providersMap.get(source).findAllUnprocessedSuggestions(context, target, pageSize, offset, ascending);
        }
        return null;
    }

    @Override
    public Suggestion findUnprocessedSuggestion(Context context, String id) {
        String[] split;
        String source = null;
        UUID target = null;
        String idPart = null;
        try {
            split = id.split(":", 3);
            source = split[0];
            target = UUID.fromString(split[1]);
            idPart = split[2];
        }
        catch (Exception e) {
            log.warn("findSuggestion got an invalid id " + id + ", return null");
            return null;
        }
        if (split.length != 3) {
            return null;
        }
        if (this.providersMap.containsKey(source)) {
            return this.providersMap.get(source).findUnprocessedSuggestion(context, target, idPart);
        }
        return null;
    }

    @Override
    public void rejectSuggestion(Context context, String id) {
        String[] split;
        String source = null;
        UUID target = null;
        String idPart = null;
        try {
            split = id.split(":", 3);
            source = split[0];
            target = UUID.fromString(split[1]);
            idPart = split[2];
        }
        catch (Exception e) {
            log.warn("rejectSuggestion got an invalid id " + id + ", doing nothing");
            return;
        }
        if (split.length != 3) {
            return;
        }
        if (this.providersMap.containsKey(source)) {
            this.providersMap.get(source).rejectSuggestion(context, target, idPart);
        }
    }
}

