/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Site;
import org.dspace.content.authority.Choices;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.ParameterizedDisseminationCrosswalk;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Verifier;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.JDOMResult;
import org.jdom2.transform.JDOMSource;

public class XSLTDisseminationCrosswalk
extends XSLTCrosswalk
implements ParameterizedDisseminationCrosswalk {
    private static final Logger LOG = LogManager.getLogger();
    private static Context context;
    private static final String DIRECTION = "dissemination";
    protected static final CommunityService communityService;
    protected static final CollectionService collectionService;
    protected static final ItemService itemService;
    protected static final ConfigurationService configurationService;
    private static final String[] aliases;
    private String schemaLocation = null;
    private Namespace[] namespaces = null;
    private boolean preferList = false;

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    private void init() throws CrosswalkInternalException {
        if (this.namespaces != null || this.schemaLocation != null) {
            return;
        }
        String myAlias = this.getPluginInstanceName();
        if (myAlias == null) {
            LOG.error("Must use PluginService to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
            throw new CrosswalkInternalException("Must use PluginService to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
        }
        String prefix = "crosswalk.dissemination." + myAlias + ".";
        this.schemaLocation = configurationService.getProperty(prefix + "schemaLocation");
        if (this.schemaLocation == null) {
            LOG.warn("No schemaLocation for crosswalk={}, key={}schemaLocation", (Object)myAlias, (Object)prefix);
        } else if (this.schemaLocation.length() > 0 && this.schemaLocation.indexOf(32) < 0) {
            LOG.warn("Possible INVALID schemaLocation (no space found) for crosswalk={}, key={}schemaLocation\n\tCorrect format is \"{namespace} {schema-URL}\"", (Object)myAlias, (Object)prefix);
        }
        String nsPrefix = prefix + "namespace.";
        List configKeys = configurationService.getPropertyKeys(nsPrefix);
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        for (String key : configKeys) {
            nsList.add(Namespace.getNamespace((String)key.substring(nsPrefix.length()), (String)configurationService.getProperty(key)));
        }
        this.namespaces = nsList.toArray(new Namespace[nsList.size()]);
        this.preferList = configurationService.getBooleanProperty(prefix + "preferList", false);
    }

    @Override
    public Namespace[] getNamespaces() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            LOG.error(e::toString);
        }
        return (Namespace[])ArrayUtils.clone((Object[])this.namespaces);
    }

    @Override
    public String getSchemaLocation() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            LOG.error(e::toString);
        }
        return this.schemaLocation;
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        return this.disseminateElement(context, dso, new HashMap<String, String>());
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso, Map<String, String> parameters) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type != 2 && type != 3 && type != 4) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk items, collections, and communities.");
        }
        this.init();
        Transformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = parameter::getKey;
            supplierArray[1] = parameter::getValue;
            LOG.debug("Setting parameter {} to {}", supplierArray);
            xform.setParameter(parameter.getKey(), parameter.getValue());
        }
        try {
            Document ddim = new Document(XSLTDisseminationCrosswalk.createDIM(dso));
            JDOMResult result = new JDOMResult();
            xform.transform((Source)new JDOMSource(ddim), (Result)result);
            Element root = result.getDocument().getRootElement();
            root.detach();
            return root;
        }
        catch (TransformerException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::toString;
            LOG.error("Got error: ()", supplierArray);
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString(), e);
        }
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type != 2 && type != 3 && type != 4) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk a items, collections, and communities.");
        }
        this.init();
        Transformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            JDOMResult result = new JDOMResult();
            xform.transform((Source)new JDOMSource(XSLTDisseminationCrosswalk.createDIM(dso).getChildren()), (Result)result);
            List contentList = result.getResult();
            List<Element> elementList = contentList.stream().filter(obj -> obj instanceof Element).map(Element.class::cast).collect(Collectors.toList());
            return elementList;
        }
        catch (TransformerException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::toString;
            LOG.error("Got error: {}", supplierArray);
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString(), e);
        }
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    @Override
    public boolean preferList() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            LOG.error(e::toString);
        }
        return this.preferList;
    }

    public static Element createDIM(DSpaceObject dso, List<MetadataValueDTO> dcvs) {
        Element dim = new Element("dim", DIM_NS);
        String type = Constants.typeText[dso.getType()];
        dim.setAttribute("dspaceType", type);
        for (int i = 0; i < dcvs.size(); ++i) {
            MetadataValueDTO dcv = dcvs.get(i);
            Element field = XSLTDisseminationCrosswalk.createField(dcv.getSchema(), dcv.getElement(), dcv.getQualifier(), dcv.getLanguage(), dcv.getValue(), dcv.getAuthority(), dcv.getConfidence());
            dim.addContent((Content)field);
        }
        return dim;
    }

    public static Element createDIM(DSpaceObject dso) {
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            return XSLTDisseminationCrosswalk.createDIM(dso, XSLTDisseminationCrosswalk.item2Metadata(item));
        }
        Element dim = new Element("dim", DIM_NS);
        String type = Constants.typeText[dso.getType()];
        dim.setAttribute("dspaceType", type);
        if (dso.getType() == 3) {
            Collection collection = (Collection)dso;
            String description = collectionService.getMetadataFirstValue(collection, CollectionService.MD_INTRODUCTORY_TEXT, "*");
            String description_abstract = collectionService.getMetadataFirstValue(collection, CollectionService.MD_SHORT_DESCRIPTION, "*");
            String description_table = collectionService.getMetadataFirstValue(collection, CollectionService.MD_SIDEBAR_TEXT, "*");
            String identifier_uri = "hdl:" + collection.getHandle();
            String provenance = collectionService.getMetadataFirstValue(collection, CollectionService.MD_PROVENANCE_DESCRIPTION, "*");
            String rights = collectionService.getMetadataFirstValue(collection, CollectionService.MD_COPYRIGHT_TEXT, "*");
            String rights_license = collectionService.getMetadataFirstValue(collection, CollectionService.MD_LICENSE, "*");
            String title = collectionService.getMetadataFirstValue(collection, CollectionService.MD_NAME, "*");
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", null, null, description));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "abstract", null, description_abstract));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "tableofcontents", null, description_table));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "provenance", null, null, provenance));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", null, null, rights));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", "license", null, rights_license));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        } else if (dso.getType() == 4) {
            Community community = (Community)dso;
            String description = communityService.getMetadataFirstValue(community, CommunityService.MD_INTRODUCTORY_TEXT, "*");
            String description_abstract = communityService.getMetadataFirstValue(community, CommunityService.MD_SHORT_DESCRIPTION, "*");
            String description_table = communityService.getMetadataFirstValue(community, CommunityService.MD_SIDEBAR_TEXT, "*");
            String identifier_uri = "hdl:" + community.getHandle();
            String rights = communityService.getMetadataFirstValue(community, CommunityService.MD_COPYRIGHT_TEXT, "*");
            String title = communityService.getMetadataFirstValue(community, CommunityService.MD_NAME, "*");
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", null, null, description));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "abstract", null, description_abstract));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "tableofcontents", null, description_table));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", null, null, rights));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        } else if (dso.getType() == 5) {
            Site site = (Site)dso;
            String identifier_uri = "hdl:" + site.getHandle();
            String title = site.getName();
            String url = site.getURL();
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, url));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        }
        return dim;
    }

    protected static List<MetadataValueDTO> item2Metadata(Item item) {
        List<MetadataValue> dcvs = itemService.getMetadata(item, "*", "*", "*", "*");
        ArrayList<MetadataValueDTO> result = new ArrayList<MetadataValueDTO>();
        for (MetadataValue metadataValue : dcvs) {
            result.add(new MetadataValueDTO(metadataValue));
        }
        return result;
    }

    private static Element createField(String schema, String element, String qualifier, String language, String value) {
        return XSLTDisseminationCrosswalk.createField(schema, element, qualifier, language, value, null, -1);
    }

    private static Element createField(String schema, String element, String qualifier, String language, String value, String authority, int confidence) {
        Element field = new Element("field", DIM_NS);
        field.setAttribute("mdschema", schema);
        field.setAttribute("element", element);
        if (qualifier != null) {
            field.setAttribute("qualifier", qualifier);
        }
        if (language != null) {
            field.setAttribute("lang", language);
        }
        field.setText(XSLTDisseminationCrosswalk.checkedString(value));
        if (authority != null) {
            field.setAttribute("authority", authority);
            field.setAttribute("confidence", Choices.getConfidenceText(confidence));
        }
        return field;
    }

    private static String checkedString(String value) {
        if (value == null) {
            return null;
        }
        String reason = Verifier.checkCharacterData((String)value);
        if (reason == null) {
            return value;
        }
        LOG.debug("Filtering out non-XML characters in string, reason={}", (Object)reason);
        StringBuilder result = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Verifier.isXMLCharacter((int)c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static void main(String[] argv) throws Exception {
        CharArrayWriter traceWriter;
        DisseminationCrosswalk xwalk;
        LOG.error("started.");
        if (argv.length < 2 || argv.length > 3) {
            System.err.println("Usage:  java XSLTDisseminationCrosswalk <crosswalk-name> <handle> [output-file]");
            LOG.error("You started Dissemination Crosswalk Test/Export with a wrong number of parameters.");
            System.exit(1);
        }
        String xwalkname = argv[0];
        String handle = argv[1];
        OutputStream out = System.out;
        if (argv.length > 2) {
            try {
                out = new FileOutputStream(argv[2]);
            }
            catch (FileNotFoundException e) {
                System.err.format("Can't write to the specified file: %s%n", e.getMessage());
                System.err.println("Will write output to stdout.");
            }
        }
        if ((xwalk = (DisseminationCrosswalk)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(DisseminationCrosswalk.class, xwalkname)) == null) {
            System.err.format("Error: Cannot find a DisseminationCrosswalk plugin for: \"%s\"%n", xwalkname);
            LOG.error("Cannot find the Dissemination Crosswalk plugin.");
            System.exit(1);
        }
        context = new Context();
        context.turnOffAuthorisationSystem();
        DSpaceObject dso = null;
        try {
            dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, handle);
        }
        catch (SQLException e) {
            System.err.println("Error: A problem with the database connection occurred, check logs for further information.");
            System.exit(1);
        }
        if (null == dso) {
            System.err.format("Can't find a DSpaceObject with the handle \"%s\"%n", handle);
            System.exit(1);
        }
        if (!xwalk.canDisseminate(dso)) {
            System.err.println("Dissemination Crosswalk can't disseminate this DSpaceObject.");
            LOG.error("Dissemination Crosswalk can't disseminate this DSpaceObject.");
            System.exit(1);
        }
        Element root = null;
        try {
            root = xwalk.disseminateElement(context, dso);
        }
        catch (IOException | SQLException | AuthorizeException | CrosswalkException e) {
            System.err.println("An error occurred while processing the dissemination crosswalk.");
            System.err.println("=== Error Message ===");
            System.err.println(e.getMessage());
            System.err.println("===  Stack Trace  ===");
            e.printStackTrace(System.err);
            System.err.println("=====================");
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::toString;
            LOG.error("Caught: {}.", supplierArray);
            LOG.error(e::getMessage);
            traceWriter = new CharArrayWriter(2048);
            e.printStackTrace(new PrintWriter(traceWriter));
            LOG.error(traceWriter::toString);
            System.exit(1);
        }
        try {
            XMLOutputter xmlout = new XMLOutputter(Format.getPrettyFormat());
            xmlout.output(new Document(root), out);
        }
        catch (IOException e) {
            System.err.println("An error occurred after processing the dissemination crosswalk.");
            System.err.println("The error occurred while trying to print the generated XML.");
            System.err.println("=== Error Message ===");
            System.err.println(e.getMessage());
            System.err.println("===  Stack Trace  ===");
            e.printStackTrace(System.err);
            System.err.println("=====================");
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::toString;
            LOG.error("Caught: {}.", supplierArray);
            LOG.error(e::getMessage);
            traceWriter = new CharArrayWriter(2048);
            e.printStackTrace(new PrintWriter(traceWriter));
            LOG.error(traceWriter::toString);
            System.exit(1);
        }
        context.complete();
        if (out instanceof FileOutputStream) {
            out.close();
        }
    }

    static {
        communityService = ContentServiceFactory.getInstance().getCommunityService();
        collectionService = ContentServiceFactory.getInstance().getCollectionService();
        itemService = ContentServiceFactory.getInstance().getItemService();
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        aliases = XSLTDisseminationCrosswalk.makeAliases(DIRECTION);
    }
}

