/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic.condition;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Item;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.logic.condition.AbstractCondition;
import org.dspace.core.Constants;
import org.dspace.core.Context;

public class ReadableByGroupCondition
extends AbstractCondition {
    private static final Logger log = LogManager.getLogger();
    AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    @Override
    public boolean getResult(Context context, Item item) throws LogicalStatementException {
        String group = (String)this.getParameters().get("group");
        String action = (String)this.getParameters().get("action");
        try {
            List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, item, Constants.getActionID(action));
            for (ResourcePolicy policy : policies) {
                if (!policy.getGroup().getName().equals(group)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            log.error("Error trying to read policies for " + item.getHandle() + ": " + e.getMessage());
            throw new LogicalStatementException(e);
        }
        log.debug("item " + item.getHandle() + " not readable by anonymous group");
        return false;
    }
}

