/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import edu.harvard.hul.ois.mets.AmdSec;
import edu.harvard.hul.ois.mets.BinData;
import edu.harvard.hul.ois.mets.Checksumtype;
import edu.harvard.hul.ois.mets.DigiprovMD;
import edu.harvard.hul.ois.mets.Div;
import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.FLocat;
import edu.harvard.hul.ois.mets.FileGrp;
import edu.harvard.hul.ois.mets.FileSec;
import edu.harvard.hul.ois.mets.Fptr;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.MdRef;
import edu.harvard.hul.ois.mets.MdWrap;
import edu.harvard.hul.ois.mets.Mdtype;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.Mptr;
import edu.harvard.hul.ois.mets.RightsMD;
import edu.harvard.hul.ois.mets.SourceMD;
import edu.harvard.hul.ois.mets.StructMap;
import edu.harvard.hul.ois.mets.TechMD;
import edu.harvard.hul.ois.mets.XmlData;
import edu.harvard.hul.ois.mets.helper.Base64;
import edu.harvard.hul.ois.mets.helper.MdSec;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.PreformedXML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.AbstractPackagerWrappingCrosswalk;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.StreamDisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.AbstractPackageDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.SiteService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.license.factory.LicenseServiceFactory;
import org.dspace.license.service.CreativeCommonsService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractMETSDisseminator
extends AbstractPackageDisseminator {
    private static final Logger log = LogManager.getLogger(AbstractMETSDisseminator.class);
    protected static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
    protected final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected final SiteService siteService = ContentServiceFactory.getInstance().getSiteService();
    protected final CreativeCommonsService creativeCommonsService = LicenseServiceFactory.getInstance().getCreativeCommonsService();
    protected final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected int idCounter = 1;
    protected static final long DEFAULT_MODIFIED_DATE = 1036368000000L;
    protected static final String TEMPLATE_TYPE_SUFFIX = " Template";

    protected synchronized String gensym(String prefix) {
        return prefix + "_" + String.valueOf(this.idCounter++);
    }

    protected synchronized void resetCounter() {
        this.idCounter = 1;
    }

    @Override
    public String getMIMEType(PackageParameters params) {
        return params != null && params.getBooleanProperty("manifestOnly", false) ? "text/xml" : "application/zip";
    }

    @Override
    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        this.resetCounter();
        try (FileOutputStream outStream = null;){
            if (!pkgFile.exists()) {
                PackageUtils.createFile(pkgFile);
            }
            outStream = new FileOutputStream(pkgFile);
            if (params != null && params.getBooleanProperty("manifestOnly", false)) {
                Mets manifest = this.makeManifest(context, dso, params, null);
                if (params.getBooleanProperty("validate", true)) {
                    manifest.validate(new MetsValidator());
                }
                manifest.write(new MetsWriter((OutputStream)outStream));
            } else {
                this.writeZipPackage(context, dso, params, outStream);
            }
            log.info(LogHelper.getHeader(context, "package_disseminate", "Disseminated package file=" + pkgFile.getName() + " for Object, type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", dbID=" + String.valueOf(dso.getID())));
        }
    }

    protected void writeZipPackage(Context context, DSpaceObject dso, PackageParameters params, OutputStream pkg) throws PackageValidationException, CrosswalkException, MetsException, AuthorizeException, SQLException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long lmTime = 0L;
        if (dso.getType() == 2) {
            lmTime = ((Item)dso).getLastModified().getTime();
        }
        MdStreamCache extraStreams = new MdStreamCache();
        ZipOutputStream zip = new ZipOutputStream(pkg);
        zip.setComment("METS archive created by DSpace " + Util.getSourceVersion());
        Mets manifest = this.makeManifest(context, dso, params, extraStreams);
        for (Map.Entry<MdRef, InputStream> ment : extraStreams.getMap().entrySet()) {
            MdRef ref = ment.getKey();
            this.linkLicenseRefsToBitstreams(context, params, dso, ref);
            if (ref.getXlinkHref() != null && !ref.getXlinkHref().isEmpty()) continue;
            InputStream is = ment.getValue();
            String fname = this.gensym("metadata");
            ref.setXlinkHref(fname);
            if (log.isDebugEnabled()) {
                log.debug("Writing EXTRA stream to Zip: " + fname);
            }
            ZipEntry ze = new ZipEntry(fname);
            if (lmTime != 0L) {
                ze.setTime(lmTime);
            } else {
                ze.setTime(1036368000000L);
            }
            zip.putNextEntry(ze);
            Utils.copy(is, zip);
            zip.closeEntry();
            is.close();
        }
        ZipEntry me = new ZipEntry("mets.xml");
        if (lmTime != 0L) {
            me.setTime(lmTime);
        } else {
            me.setTime(1036368000000L);
        }
        zip.putNextEntry(me);
        if (params.getBooleanProperty("validate", true)) {
            manifest.validate(new MetsValidator());
        }
        manifest.write(new MetsWriter((OutputStream)zip));
        zip.closeEntry();
        this.addBitstreamsToZip(context, dso, params, zip);
        zip.close();
    }

    protected void addBitstreamsToZip(Context context, DSpaceObject dso, PackageParameters params, ZipOutputStream zip) throws PackageValidationException, AuthorizeException, SQLException, IOException {
        String unauth;
        String string = unauth = params == null ? null : params.getProperty("unauthorized");
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            long lmTime = ((Item)dso).getLastModified().getTime();
            List<Bundle> bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                if (!this.includeBundle(bundle)) continue;
                if (!this.authorizeService.authorizeActionBoolean(context, bundle, 0)) {
                    if (unauth != null && unauth.equalsIgnoreCase("skip")) {
                        log.warn("Skipping Bundle[\"" + bundle.getName() + "\"] because you are not authorized to read it.");
                        continue;
                    }
                    throw new AuthorizeException("Not authorized to read Bundle named \"" + bundle.getName() + "\"");
                }
                List<Bitstream> bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    boolean auth = this.authorizeService.authorizeActionBoolean(context, bitstream, 0);
                    if (auth || unauth != null && unauth.equalsIgnoreCase("zero")) {
                        String zname = this.makeBitstreamURL(context, bitstream, params);
                        ZipEntry ze = new ZipEntry(zname);
                        if (log.isDebugEnabled()) {
                            log.debug("Writing CONTENT stream of bitstream(" + bitstream.getID() + ") to Zip: " + zname + ", size=" + bitstream.getSizeBytes());
                        }
                        if (lmTime != 0L) {
                            ze.setTime(lmTime);
                        } else {
                            ze.setTime(1036368000000L);
                        }
                        ze.setSize(auth ? bitstream.getSizeBytes() : 0L);
                        zip.putNextEntry(ze);
                        if (auth) {
                            InputStream input = this.bitstreamService.retrieve(context, bitstream);
                            Utils.copy(input, zip);
                            input.close();
                        } else {
                            log.warn("Adding zero-length file for Bitstream, uuid=" + String.valueOf(bitstream.getID()) + ", not authorized for READ.");
                        }
                        zip.closeEntry();
                        continue;
                    }
                    if (unauth != null && unauth.equalsIgnoreCase("skip")) {
                        log.warn("Skipping Bitstream, uuid=" + String.valueOf(bitstream.getID()) + ", not authorized for READ.");
                        continue;
                    }
                    throw new AuthorizeException("Not authorized to read Bitstream, uuid=" + String.valueOf(bitstream.getID()));
                }
            }
        } else if (dso.getType() == 3 || dso.getType() == 4) {
            Bitstream logoBs;
            Bitstream bitstream = logoBs = dso.getType() == 3 ? ((Collection)dso).getLogo() : ((Community)dso).getLogo();
            if (logoBs != null) {
                String zname = this.makeBitstreamURL(context, logoBs, params);
                ZipEntry ze = new ZipEntry(zname);
                if (log.isDebugEnabled()) {
                    log.debug("Writing CONTENT stream of bitstream({}) to Zip: {}, size={}", (Object)String.valueOf(logoBs.getID()), (Object)zname, (Object)String.valueOf(logoBs.getSizeBytes()));
                }
                ze.setSize(logoBs.getSizeBytes());
                ze.setTime(1036368000000L);
                zip.putNextEntry(ze);
                Utils.copy(this.bitstreamService.retrieve(context, logoBs), zip);
                zip.closeEntry();
            }
        }
    }

    protected void setMdType(MdWrap mdWrap, String mdtype) {
        try {
            mdWrap.setMDTYPE(Mdtype.parse((String)mdtype));
        }
        catch (MetsException e) {
            mdWrap.setMDTYPE(Mdtype.OTHER);
            mdWrap.setOTHERMDTYPE(mdtype);
        }
    }

    protected void setMdType(MdRef mdRef, String mdtype) {
        try {
            mdRef.setMDTYPE(Mdtype.parse((String)mdtype));
        }
        catch (MetsException e) {
            mdRef.setMDTYPE(Mdtype.OTHER);
            mdRef.setOTHERMDTYPE(mdtype);
        }
    }

    protected MdSec makeMdSec(Context context, DSpaceObject dso, Class mdSecClass, String typeSpec, PackageParameters params, MdStreamCache extraStreams) throws SQLException, PackageValidationException, CrosswalkException, IOException, AuthorizeException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            String xwalkName;
            String metsName;
            MdSec mdSec = (MdSec)mdSecClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            mdSec.setID(this.gensym(mdSec.getLocalName()));
            String[] parts = typeSpec.split(":", 2);
            if (parts.length > 1) {
                metsName = parts[0];
                xwalkName = parts[1];
            } else {
                metsName = typeSpec;
                xwalkName = typeSpec;
            }
            PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();
            boolean xwalkFound = pluginService.hasNamedPlugin(DisseminationCrosswalk.class, xwalkName);
            if (xwalkFound) {
                DisseminationCrosswalk xwalk = (DisseminationCrosswalk)pluginService.getNamedPlugin(DisseminationCrosswalk.class, xwalkName);
                if (xwalk.canDisseminate(dso)) {
                    if (xwalk instanceof AbstractPackagerWrappingCrosswalk) {
                        AbstractPackagerWrappingCrosswalk wrapper = (AbstractPackagerWrappingCrosswalk)((Object)xwalk);
                        wrapper.setPackagingParameters(params);
                    }
                    MdWrap mdWrap = new MdWrap();
                    this.setMdType(mdWrap, metsName);
                    XmlData xmlData = new XmlData();
                    if (this.crosswalkToMetsElement(context, xwalk, dso, (MetsElement)xmlData) != null) {
                        mdWrap.getContent().add(xmlData);
                        mdSec.getContent().add(mdWrap);
                        return mdSec;
                    }
                    return null;
                }
                return null;
            }
            StreamDisseminationCrosswalk sxwalk = (StreamDisseminationCrosswalk)pluginService.getNamedPlugin(StreamDisseminationCrosswalk.class, xwalkName);
            if (sxwalk != null) {
                if (sxwalk.canDisseminate(context, dso)) {
                    if (sxwalk instanceof AbstractPackagerWrappingCrosswalk) {
                        AbstractPackagerWrappingCrosswalk wrapper = (AbstractPackagerWrappingCrosswalk)((Object)sxwalk);
                        wrapper.setPackagingParameters(params);
                    }
                    ByteArrayOutputStream disseminateOutput = new ByteArrayOutputStream();
                    sxwalk.disseminate(context, dso, disseminateOutput);
                    ByteArrayInputStream crosswalkedStream = new ByteArrayInputStream(disseminateOutput.toByteArray());
                    if (extraStreams != null) {
                        MdRef mdRef = new MdRef();
                        extraStreams.addStream(mdRef, crosswalkedStream);
                        mdRef.setMIMETYPE(sxwalk.getMIMEType());
                        this.setMdType(mdRef, metsName);
                        mdRef.setLOCTYPE(Loctype.URL);
                        mdSec.getContent().add(mdRef);
                    } else {
                        MdWrap mdWrap = new MdWrap();
                        mdWrap.setMIMETYPE(sxwalk.getMIMEType());
                        this.setMdType(mdWrap, metsName);
                        BinData binData = new BinData();
                        Base64 base64 = new Base64((InputStream)crosswalkedStream);
                        binData.getContent().add(base64);
                        mdWrap.getContent().add(binData);
                        mdSec.getContent().add(mdWrap);
                    }
                    return mdSec;
                }
                return null;
            }
            throw new PackageValidationException("Cannot find " + xwalkName + " crosswalk plugin, either DisseminationCrosswalk or StreamDisseminationCrosswalk");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PackageValidationException("Error instantiating Mdsec object: " + e.toString(), e);
        }
    }

    protected void addToAmdSec(AmdSec fAmdSec, String[] mdTypes, Class mdSecClass, Context context, DSpaceObject dso, PackageParameters params, MdStreamCache extraStreams) throws SQLException, PackageValidationException, CrosswalkException, IOException, AuthorizeException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (int i = 0; i < mdTypes.length; ++i) {
            MdSec md = this.makeMdSec(context, dso, mdSecClass, mdTypes[i], params, extraStreams);
            if (md == null) continue;
            fAmdSec.getContent().add(md);
        }
    }

    protected String addAmdSec(Context context, DSpaceObject dso, PackageParameters params, Mets mets, MdStreamCache extraStreams) throws SQLException, PackageValidationException, CrosswalkException, IOException, AuthorizeException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, IllegalArgumentException, InvocationTargetException {
        String[] digiprovMdTypes;
        String[] techMdTypes = this.getTechMdTypes(context, dso, params);
        String[] rightsMdTypes = this.getRightsMdTypes(context, dso, params);
        String[] sourceMdTypes = this.getSourceMdTypes(context, dso, params);
        if (techMdTypes.length + sourceMdTypes.length + (digiprovMdTypes = this.getDigiprovMdTypes(context, dso, params)).length + rightsMdTypes.length > 0) {
            String result = this.gensym("amd");
            AmdSec fAmdSec = new AmdSec();
            fAmdSec.setID(result);
            this.addToAmdSec(fAmdSec, techMdTypes, TechMD.class, context, dso, params, extraStreams);
            this.addToAmdSec(fAmdSec, rightsMdTypes, RightsMD.class, context, dso, params, extraStreams);
            this.addToAmdSec(fAmdSec, sourceMdTypes, SourceMD.class, context, dso, params, extraStreams);
            this.addToAmdSec(fAmdSec, digiprovMdTypes, DigiprovMD.class, context, dso, params, extraStreams);
            mets.getContent().add(fAmdSec);
            return result;
        }
        return null;
    }

    protected String makePersistentID(DSpaceObject dso) {
        String handle = dso.getHandle();
        if (handle == null) {
            return "DSpace_DB_" + Constants.typeText[dso.getType()] + "_" + String.valueOf(dso.getID());
        }
        return this.getHandleURN(handle);
    }

    protected Mets makeManifest(Context context, DSpaceObject dso, PackageParameters params, MdStreamCache extraStreams) throws MetsException, PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Mets mets = new Mets();
        String identifier = "DB-ID-" + dso.getID();
        mets.setID("DSpace_" + Constants.typeText[dso.getType()] + "_" + identifier);
        mets.setOBJID(this.makePersistentID(dso));
        mets.setTYPE(this.getObjectTypeString(dso));
        mets.setPROFILE(this.getProfile());
        MetsHdr metsHdr = this.makeMetsHdr(context, dso, params);
        if (metsHdr != null) {
            mets.getContent().add(metsHdr);
        }
        String[] dmdTypes = this.getDmdTypes(context, dso, params);
        String[] dmdId = new String[dmdTypes.length];
        for (int i = 0; i < dmdTypes.length; ++i) {
            MdSec dmdSec = this.makeMdSec(context, dso, DmdSec.class, dmdTypes[i], params, extraStreams);
            if (dmdSec == null) continue;
            mets.getContent().add(dmdSec);
            dmdId[i] = dmdSec.getID();
        }
        String objectAMDID = this.addAmdSec(context, dso, params, mets, extraStreams);
        StructMap structMap = new StructMap();
        structMap.setID(this.gensym("struct"));
        structMap.setTYPE("LOGICAL");
        structMap.setLABEL("DSpace Object");
        Div div0 = new Div();
        div0.setID(this.gensym("div"));
        div0.setTYPE("DSpace Object Contents");
        structMap.getContent().add(div0);
        FileSec fileSec = null;
        if (dso.getType() == 2) {
            String bitstreamIDstart = "bitstream_";
            Item item = (Item)dso;
            String string = params == null ? null : params.getProperty("unauthorized");
            fileSec = new FileSec();
            List<Bundle> bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                String techBundID;
                if (!this.includeBundle(bundle)) continue;
                if (!this.authorizeService.authorizeActionBoolean(context, bundle, 0)) {
                    if (string != null && string.equalsIgnoreCase("skip")) continue;
                    throw new AuthorizeException("Not authorized to read Bundle named \"" + bundle.getName() + "\"");
                }
                List<Bitstream> bitstreams = bundle.getBitstreams();
                FileGrp fileGrp = new FileGrp();
                String bName = bundle.getName();
                if (bName != null && !bName.equals("")) {
                    fileGrp.setUSE(this.bundleToFileGrp(bName));
                }
                if ((techBundID = this.addAmdSec(context, bundle, params, mets, extraStreams)) != null) {
                    fileGrp.setADMID(techBundID);
                }
                Bitstream primaryBitstream = null;
                boolean isContentBundle = false;
                if (bName != null && bName.equals("ORIGINAL")) {
                    isContentBundle = true;
                    primaryBitstream = bundle.getPrimaryBitstream();
                }
                for (Bitstream bitstream : bitstreams) {
                    Bitstream original;
                    boolean auth = this.authorizeService.authorizeActionBoolean(context, bitstream, 0);
                    if (!auth) {
                        if (string != null && string.equalsIgnoreCase("skip")) continue;
                        if (string == null || !string.equalsIgnoreCase("zero")) {
                            throw new AuthorizeException("Not authorized to read Bitstream, uuid=" + String.valueOf(bitstream.getID()));
                        }
                    }
                    String uuid = String.valueOf(bitstream.getID());
                    String fileID = bitstreamIDstart + uuid;
                    edu.harvard.hul.ois.mets.File file = new edu.harvard.hul.ois.mets.File();
                    file.setID(fileID);
                    file.setSEQ(bitstream.getSequenceID());
                    fileGrp.getContent().add(file);
                    if (bitstream.equals(primaryBitstream)) {
                        Fptr fptr = new Fptr();
                        fptr.setFILEID(fileID);
                        div0.getContent().add(0, fptr);
                    }
                    if (isContentBundle) {
                        div0.getContent().add(this.makeFileDiv(fileID, this.getObjectTypeString(bitstream)));
                    }
                    String groupID = "GROUP_" + bitstreamIDstart + uuid;
                    if (bundle.getName() != null && (bundle.getName().equals("THUMBNAIL") || bundle.getName().startsWith("TEXT")) && (original = this.findOriginalBitstream(item, bitstream)) != null) {
                        groupID = "GROUP_" + bitstreamIDstart + String.valueOf(original.getID());
                    }
                    file.setGROUPID(groupID);
                    file.setMIMETYPE(bitstream.getFormat(context).getMIMEType());
                    file.setSIZE(auth ? bitstream.getSizeBytes() : 0L);
                    String csType = bitstream.getChecksumAlgorithm();
                    String cs = bitstream.getChecksum();
                    if (auth && cs != null && csType != null) {
                        try {
                            file.setCHECKSUMTYPE(Checksumtype.parse((String)csType));
                            file.setCHECKSUM(cs);
                        }
                        catch (MetsException e) {
                            log.warn("Cannot set bitstream checksum type=" + csType + " in METS.");
                        }
                    }
                    FLocat flocat = new FLocat();
                    flocat.setLOCTYPE(Loctype.URL);
                    flocat.setXlinkHref(this.makeBitstreamURL(context, bitstream, params));
                    file.getContent().add(flocat);
                    String techID = this.addAmdSec(context, bitstream, params, mets, extraStreams);
                    if (techID == null) continue;
                    file.setADMID(techID);
                }
                fileSec.getContent().add(fileGrp);
            }
        } else if (dso.getType() == 3) {
            Bitstream logoBs;
            Collection collection = (Collection)dso;
            Iterator<DSpaceObject> ii = this.itemService.findByCollection(context, collection);
            while (ii.hasNext()) {
                Item item = (Item)ii.next();
                childDiv = this.makeChildDiv(this.getObjectTypeString(item), item, params);
                if (childDiv == null) continue;
                div0.getContent().add(childDiv);
            }
            Item item = collection.getTemplateItem();
            if (item != null) {
                String[] templateDmdId = new String[dmdTypes.length];
                int dmdIndex = dmdTypes.length + 1;
                for (int i = 0; i < dmdTypes.length; ++i) {
                    MdSec templateDmdSec = this.makeMdSec(context, item, DmdSec.class, dmdTypes[i], params, extraStreams);
                    if (templateDmdSec == null) continue;
                    mets.getContent().add(dmdIndex, templateDmdSec);
                    ++dmdIndex;
                    templateDmdId[i] = templateDmdSec.getID();
                }
                Div templateItemDiv = new Div();
                templateItemDiv.setID(this.gensym("div"));
                templateItemDiv.setTYPE(this.getObjectTypeString(item) + TEMPLATE_TYPE_SUFFIX);
                StringBuilder templateDmdIds = new StringBuilder();
                for (String currdmdId : templateDmdId) {
                    templateDmdIds.append(" ").append(currdmdId);
                }
                templateItemDiv.setDMDID(templateDmdIds.substring(1));
                div0.getContent().add(0, templateItemDiv);
            }
            if ((logoBs = collection.getLogo()) != null) {
                fileSec = new FileSec();
                this.addLogoBitstream(context, logoBs, fileSec, div0, params);
            }
        } else if (dso.getType() == 4) {
            List<Community> subcomms = ((Community)dso).getSubcommunities();
            for (Community community : subcomms) {
                childDiv = this.makeChildDiv(this.getObjectTypeString(community), community, params);
                if (childDiv == null) continue;
                div0.getContent().add(childDiv);
            }
            List<Collection> colls = ((Community)dso).getCollections();
            for (Collection coll : colls) {
                Div childDiv = this.makeChildDiv(this.getObjectTypeString(coll), coll, params);
                if (childDiv == null) continue;
                div0.getContent().add(childDiv);
            }
            Bitstream bitstream = ((Community)dso).getLogo();
            if (bitstream != null) {
                fileSec = new FileSec();
                this.addLogoBitstream(context, bitstream, fileSec, div0, params);
            }
        } else if (dso.getType() == 5) {
            List<Community> comms = this.communityService.findAllTop(context);
            for (Community community : comms) {
                childDiv = this.makeChildDiv(this.getObjectTypeString(community), community, params);
                if (childDiv == null) continue;
                div0.getContent().add(childDiv);
            }
        }
        if (fileSec != null && fileSec.getContent() != null && !fileSec.getContent().isEmpty()) {
            mets.getContent().add(fileSec);
        }
        mets.getContent().add(structMap);
        StringBuilder dmdIds = new StringBuilder();
        for (String currdmdId : dmdId) {
            dmdIds.append(" ").append(currdmdId);
        }
        div0.setDMDID(dmdIds.substring(1));
        if (objectAMDID != null) {
            div0.setADMID(objectAMDID);
        }
        this.addStructMap(context, dso, params, mets);
        return mets;
    }

    protected void addLogoBitstream(Context context, Bitstream logoBs, FileSec fileSec, Div div0, PackageParameters params) throws SQLException {
        edu.harvard.hul.ois.mets.File file = new edu.harvard.hul.ois.mets.File();
        String fileID = this.gensym("logo");
        file.setID(fileID);
        file.setMIMETYPE(logoBs.getFormat(context).getMIMEType());
        file.setSIZE(logoBs.getSizeBytes());
        String csType = logoBs.getChecksumAlgorithm();
        String cs = logoBs.getChecksum();
        if (cs != null && csType != null) {
            try {
                file.setCHECKSUMTYPE(Checksumtype.parse((String)csType));
                file.setCHECKSUM(cs);
            }
            catch (MetsException e) {
                log.warn("Cannot set bitstream checksum type=" + csType + " in METS.");
            }
        }
        FLocat flocat = new FLocat();
        flocat.setLOCTYPE(Loctype.URL);
        flocat.setXlinkHref(this.makeBitstreamURL(context, logoBs, params));
        file.getContent().add(flocat);
        FileGrp fileGrp = new FileGrp();
        fileGrp.setUSE("LOGO");
        fileGrp.getContent().add(file);
        fileSec.getContent().add(fileGrp);
        Fptr fptr = new Fptr();
        fptr.setFILEID(fileID);
        div0.getContent().add(0, fptr);
    }

    protected Div makeFileDiv(String fileID, String type) {
        Div div = new Div();
        div.setID(this.gensym("div"));
        div.setTYPE(type);
        Fptr fptr = new Fptr();
        fptr.setFILEID(fileID);
        div.getContent().add(fptr);
        return div;
    }

    protected Div makeChildDiv(String type, DSpaceObject dso, PackageParameters params) {
        String handle = dso.getHandle();
        Div div = new Div();
        div.setID(this.gensym("div"));
        div.setTYPE(type);
        if (handle == null || handle.length() == 0) {
            log.warn("METS Disseminator is skipping " + type + " without handle: " + dso.toString());
        } else {
            Mptr mptr = new Mptr();
            mptr.setID(this.gensym("mptr"));
            mptr.setLOCTYPE(Loctype.HANDLE);
            mptr.setXlinkHref(handle);
            div.getContent().add(mptr);
        }
        String childFileExtension = params.getBooleanProperty("manifestOnly", false) ? "xml" : "zip";
        Mptr mptr2 = new Mptr();
        mptr2.setID(this.gensym("mptr"));
        mptr2.setLOCTYPE(Loctype.URL);
        mptr2.setXlinkHref(PackageUtils.getPackageName(dso, childFileExtension));
        div.getContent().add(mptr2);
        return div;
    }

    protected String getHandleURN(String handle) {
        if (handle.startsWith("hdl:")) {
            return handle;
        }
        return "hdl:" + handle;
    }

    protected Bitstream findOriginalBitstream(Item item, Bitstream derived) throws SQLException {
        List<Bundle> bundles = item.getBundles();
        String originalFilename = derived.getName().substring(0, derived.getName().length() - 4);
        for (Bundle bundle : bundles) {
            if (bundle.getName() == null || !bundle.getName().equals("ORIGINAL")) continue;
            List<Bitstream> bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                if (!bitstream.getName().equals(originalFilename)) continue;
                return bitstream;
            }
        }
        return null;
    }

    protected MetsElement crosswalkToMetsElement(Context context, DisseminationCrosswalk xwalk, DSpaceObject dso, MetsElement me) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        try {
            String raw = xwalk.getSchemaLocation();
            String[] sloc = raw == null ? null : raw.split("\\s+");
            Namespace[] ns = xwalk.getNamespaces();
            for (int i = 0; i < ns.length; ++i) {
                String uri = ns[i].getURI();
                if (sloc != null && sloc.length > 1 && uri.equals(sloc[0])) {
                    me.setSchema(ns[i].getPrefix(), uri, sloc[1]);
                    continue;
                }
                me.setSchema(ns[i].getPrefix(), uri);
            }
            PreformedXML pXML = null;
            if (xwalk.preferList()) {
                res = xwalk.disseminateList(context, dso);
                if (res != null && !res.isEmpty()) {
                    pXML = new PreformedXML(outputter.outputString((List)res));
                }
            } else {
                res = xwalk.disseminateElement(context, dso);
                if (res != null) {
                    pXML = new PreformedXML(outputter.outputString(res));
                }
            }
            if (pXML != null) {
                me.getContent().add(pXML);
                return me;
            }
            return null;
        }
        catch (CrosswalkObjectNotSupported e) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping MDsec because of CrosswalkObjectNotSupported: dso=" + dso.toString() + ", xwalk=" + xwalk.getClass().getName());
            }
            return null;
        }
    }

    protected void linkLicenseRefsToBitstreams(Context context, PackageParameters params, DSpaceObject dso, MdRef mdRef) throws SQLException, IOException, AuthorizeException {
        Item i;
        List<Bundle> license;
        if (mdRef.getMDTYPE() != null && mdRef.getMDTYPE() == Mdtype.OTHER && mdRef.getOTHERMDTYPE() != null && mdRef.getOTHERMDTYPE().equals("DSpaceDepositLicense")) {
            Item i2 = (Item)dso;
            List<Bundle> license2 = this.itemService.getBundles(i2, "LICENSE");
            if (license2 != null && license2.size() > 0 && this.includeBundle(license2.get(0))) {
                Bitstream licenseBs = PackageUtils.findDepositLicense(context, (Item)dso);
                mdRef.setXlinkHref(this.makeBitstreamURL(context, licenseBs, params));
            }
        } else if (mdRef.getMDTYPE() != null && mdRef.getMDTYPE() == Mdtype.OTHER && mdRef.getOTHERMDTYPE() != null && mdRef.getOTHERMDTYPE().equals("CreativeCommonsText")) {
            Item i3 = (Item)dso;
            List<Bundle> license3 = this.itemService.getBundles(i3, "CC-LICENSE");
            if (license3 != null && license3.size() > 0 && this.includeBundle(license3.get(0))) {
                Bitstream ccText = this.creativeCommonsService.getLicenseTextBitstream(i3);
                mdRef.setXlinkHref(this.makeBitstreamURL(context, ccText, params));
            }
        } else if (mdRef.getMDTYPE() != null && mdRef.getMDTYPE() == Mdtype.OTHER && mdRef.getOTHERMDTYPE() != null && mdRef.getOTHERMDTYPE().equals("CreativeCommonsRDF") && (license = this.itemService.getBundles(i = (Item)dso, "CC-LICENSE")) != null && license.size() > 0 && this.includeBundle(license.get(0))) {
            Bitstream ccRdf = this.creativeCommonsService.getLicenseRdfBitstream(i);
            mdRef.setXlinkHref(this.makeBitstreamURL(context, ccRdf, params));
        }
    }

    public String getObjectTypeString(DSpaceObject dso) {
        return "DSpace " + Constants.typeText[dso.getType()];
    }

    @Override
    public String getParameterHelp() {
        return "* manifestOnly=[boolean]      If true, only export the METS manifest (mets.xml) and don't export content files (defaults to false).\n\n* unauthorized=[value]      If 'skip', skip over any files which the user doesn't have authorization to read. If 'zero', create a zero-length file for any files the user doesn't have authorization to read. By default, an AuthorizationException will be thrown for any files the user cannot read.";
    }

    public String makeBitstreamURL(Context context, Bitstream bitstream, PackageParameters params) throws SQLException {
        if (params != null && params.getBooleanProperty("manifestOnly", false)) {
            try {
                List<Item> bi;
                String handle = null;
                List<Bundle> bn = bitstream.getBundles();
                if (bn.size() > 0 && (bi = bn.get(0).getItems()).size() > 0) {
                    handle = bi.get(0).getHandle();
                }
                return this.configurationService.getProperty("dspace.ui.url") + "/bitstreams/" + String.valueOf(bitstream.getID()) + "/download";
            }
            catch (SQLException e) {
                log.error("Database problem", (Throwable)e);
                return bitstream.getName();
            }
        }
        String base = "bitstream_" + String.valueOf(bitstream.getID());
        List<String> ext = bitstream.getFormat(context).getExtensions();
        return ext.size() > 0 ? base + "." + ext.get(0) : base;
    }

    public abstract MetsHdr makeMetsHdr(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException;

    public abstract String getProfile();

    public abstract String bundleToFileGrp(String var1);

    public abstract String[] getDmdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getTechMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getSourceMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getDigiprovMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getRightsMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract void addStructMap(Context var1, DSpaceObject var2, PackageParameters var3, Mets var4) throws SQLException, IOException, AuthorizeException, MetsException;

    public abstract boolean includeBundle(Bundle var1);

    protected static class MdStreamCache {
        protected Map<MdRef, InputStream> extraFiles = new HashMap<MdRef, InputStream>();

        protected MdStreamCache() {
        }

        public void addStream(MdRef key, InputStream md) {
            this.extraFiles.put(key, md);
        }

        public Map<MdRef, InputStream> getMap() {
            return this.extraFiles;
        }

        public void close() throws IOException {
            for (InputStream is : this.extraFiles.values()) {
                is.close();
            }
        }
    }
}

