/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.output.NullOutputStream;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.curate.CurationClientOptions;
import org.dspace.curate.CurationScriptConfiguration;
import org.dspace.curate.Curator;
import org.dspace.curate.TaskQueue;
import org.dspace.curate.TaskQueueEntry;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.utils.DSpace;

public class Curation
extends DSpaceRunnable<CurationScriptConfiguration> {
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected Context context;
    private CurationClientOptions curationClientOptions;
    private String task;
    private String taskFile;
    private String id;
    private String queue;
    private String scope;
    private String reporter;
    private Map<String, String> parameters;
    private boolean verbose;

    @Override
    public void internalRun() throws Exception {
        if (this.curationClientOptions == CurationClientOptions.HELP) {
            this.printHelp();
            return;
        }
        Curator curator = this.initCurator();
        if (this.curationClientOptions == CurationClientOptions.TASK) {
            long start = System.currentTimeMillis();
            this.handleCurationTask(curator);
            this.endScript(start);
        }
        if (this.curationClientOptions == CurationClientOptions.QUEUE) {
            TaskQueue taskQueue = (TaskQueue)CoreServiceFactory.getInstance().getPluginService().getSinglePlugin(TaskQueue.class);
            if (taskQueue == null) {
                this.handler.logError("No implementation configured for queue");
                throw new UnsupportedOperationException("No queue service available");
            }
            long timeRun = this.runQueue(taskQueue, curator);
            this.endScript(timeRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCurationTask(Curator curator) throws IOException, SQLException {
        if (this.commandLine.hasOption('t')) {
            if (this.verbose) {
                this.handler.logInfo("Adding task: " + this.task);
            }
            curator.addTask(this.task);
            if (this.verbose && !curator.hasTask(this.task)) {
                this.handler.logInfo("Task: " + this.task + " not resolved");
            }
        } else if (this.commandLine.hasOption('T')) {
            try (BufferedReader reader = null;){
                String taskName;
                reader = new BufferedReader(new FileReader(this.taskFile));
                while ((taskName = reader.readLine()) != null) {
                    if (this.verbose) {
                        this.handler.logInfo("Adding task: " + taskName);
                    }
                    curator.addTask(taskName);
                }
            }
        }
        if (this.verbose) {
            this.handler.logInfo("Starting curation");
            this.handler.logInfo("Curating id: " + this.id);
        }
        if ("all".equals(this.id)) {
            curator.curate(this.context, ContentServiceFactory.getInstance().getSiteService().findSite(this.context).getHandle());
        } else {
            curator.curate(this.context, this.id);
        }
    }

    private long runQueue(TaskQueue queue, Curator curator) throws SQLException, AuthorizeException, IOException {
        long ticket = System.currentTimeMillis();
        for (TaskQueueEntry entry : queue.dequeue(this.queue, ticket)) {
            if (this.verbose) {
                this.handler.logInfo("Curating id: " + entry.getObjectId());
            }
            curator.clear();
            for (String taskName : entry.getTaskNames()) {
                curator.addTask(taskName);
            }
            curator.curate(this.context, entry.getObjectId());
        }
        queue.release(this.queue, ticket, true);
        return ticket;
    }

    private void endScript(long timeRun) throws SQLException {
        this.context.complete();
        if (this.verbose) {
            long elapsed = System.currentTimeMillis() - timeRun;
            this.handler.logInfo("Ending curation. Elapsed time: " + elapsed);
        }
    }

    private Curator initCurator() throws FileNotFoundException {
        Curator curator = new Curator(this.handler);
        Object reporterStream = null == this.reporter ? new NullOutputStream() : ("-".equals(this.reporter) ? System.out : new PrintStream(this.reporter));
        OutputStreamWriter reportWriter = new OutputStreamWriter((OutputStream)reporterStream);
        curator.setReporter(reportWriter);
        if (this.scope != null) {
            Curator.TxScope txScope = Curator.TxScope.valueOf(this.scope.toUpperCase());
            curator.setTransactionScope(txScope);
        }
        curator.addParameters(this.parameters);
        curator.setInvoked(Curator.Invoked.BATCH);
        return curator;
    }

    @Override
    public void printHelp() {
        super.printHelp();
        this.handler.logInfo("\nwhole repo: CurationCli -t estimate -i all");
        this.handler.logInfo("single item: CurationCli -t generate -i itemId");
        this.handler.logInfo("task queue: CurationCli -q monthly");
    }

    @Override
    public CurationScriptConfiguration getScriptConfiguration() {
        return (CurationScriptConfiguration)new DSpace().getServiceManager().getServiceByName("curate", CurationScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.assignCurrentUserInContext();
        this.curationClientOptions = CurationClientOptions.getClientOption(this.commandLine);
        if (this.curationClientOptions != null) {
            this.initGeneralLineOptionsAndCheckIfValid();
            if (this.curationClientOptions == CurationClientOptions.TASK) {
                this.initTaskLineOptionsAndCheckIfValid();
            } else if (this.curationClientOptions == CurationClientOptions.QUEUE) {
                this.queue = this.commandLine.getOptionValue('q');
            }
        } else {
            throw new IllegalArgumentException("[--help || --task|--taskfile <> -identifier <> || -queue <> ] must be specified");
        }
    }

    protected void assignCurrentUserInContext() throws ParseException {
        UUID currentUserUuid = this.getEpersonIdentifier();
        try {
            this.context = new Context(Context.Mode.BATCH_EDIT);
            EPerson eperson = (EPerson)this.ePersonService.find(this.context, currentUserUuid);
            if (eperson == null) {
                this.handler.logError("EPerson not found: " + currentUserUuid);
                throw new IllegalArgumentException("Unable to find a user with uuid: " + currentUserUuid);
            }
            this.assignSpecialGroupsInContext();
            this.context.setCurrentUser(eperson);
        }
        catch (SQLException e) {
            this.handler.handleException("Something went wrong trying to fetch eperson for uuid: " + currentUserUuid, e);
        }
    }

    protected void assignSpecialGroupsInContext() throws SQLException {
        for (UUID uuid : this.handler.getSpecialGroups()) {
            this.context.setSpecialGroup(uuid);
        }
    }

    private void initGeneralLineOptionsAndCheckIfValid() {
        if (this.commandLine.hasOption('r')) {
            this.reporter = this.commandLine.getOptionValue('r');
        }
        this.parameters = new HashMap<String, String>();
        if (this.commandLine.hasOption('p')) {
            for (String parameter : this.commandLine.getOptionValues('p')) {
                String[] parts = parameter.split("=", 2);
                String name = parts[0].trim();
                String value = parts.length > 1 ? parts[1].trim() : "true";
                this.parameters.put(name, value);
            }
        }
        this.verbose = false;
        if (this.commandLine.hasOption('v')) {
            this.verbose = true;
        }
        if (this.commandLine.getOptionValue('s') != null) {
            this.scope = this.commandLine.getOptionValue('s');
            if (this.scope != null && Curator.TxScope.valueOf(this.scope.toUpperCase()) == null) {
                this.handler.logError("Bad transaction scope '" + this.scope + "': only 'object', 'curation' or 'open' recognized");
                throw new IllegalArgumentException("Bad transaction scope '" + this.scope + "': only 'object', 'curation' or 'open' recognized");
            }
        }
    }

    private void initTaskLineOptionsAndCheckIfValid() {
        if (this.commandLine.hasOption('t')) {
            this.task = this.commandLine.getOptionValue('t');
            if (!CurationClientOptions.getTaskOptions().contains(this.task)) {
                this.handler.logError("-t task must be one of: " + CurationClientOptions.getTaskOptions());
                throw new IllegalArgumentException("-t task must be one of: " + CurationClientOptions.getTaskOptions());
            }
        } else if (this.commandLine.hasOption('T')) {
            this.taskFile = this.commandLine.getOptionValue('T');
            if (!new File(this.taskFile).isFile()) {
                this.handler.logError("-T taskFile must be valid file: " + this.taskFile);
                throw new IllegalArgumentException("-T taskFile must be valid file: " + this.taskFile);
            }
        }
        if (this.commandLine.hasOption('i')) {
            this.id = this.commandLine.getOptionValue('i').toLowerCase();
            if (!this.id.equalsIgnoreCase("all")) {
                DSpaceObject dso;
                HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
                try {
                    dso = handleService.resolveToObject(this.context, this.id);
                }
                catch (SQLException e) {
                    this.handler.logError("SQLException trying to resolve handle " + this.id + " to a valid dso");
                    throw new IllegalArgumentException("SQLException trying to resolve handle " + this.id + " to a valid dso");
                }
                if (dso == null) {
                    this.handler.logError("Id must be specified: a valid dso handle or 'all'; " + this.id + " could not be resolved to valid dso handle");
                    throw new IllegalArgumentException("Id must be specified: a valid dso handle or 'all'; " + this.id + " could not be resolved to valid dso handle");
                }
            }
        } else {
            this.handler.logError("Id must be specified: a handle, 'all', or no -i and a -q task queue (-h for help)");
            throw new IllegalArgumentException("Id must be specified: a handle, 'all', or no -i and a -q task queue (-h for help)");
        }
    }
}

