/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.util.SpiderDetectorService;

public class SpiderDetector {
    private static final SpiderDetectorService spiderDetectorService = StatisticsServiceFactory.getInstance().getSpiderDetectorService();

    private SpiderDetector() {
    }

    public static Set<String> getSpiderIpAddresses() {
        spiderDetectorService.loadSpiderIpAddresses();
        return spiderDetectorService.getTable().toSet();
    }

    public static Set<String> readPatterns(File patternFile) throws IOException {
        return spiderDetectorService.readPatterns(patternFile);
    }

    public static boolean isSpider(String clientIP, String proxyIPs, String hostname, String agent) {
        return spiderDetectorService.isSpider(clientIP, proxyIPs, hostname, agent);
    }

    public static boolean isSpider(HttpServletRequest request) {
        return spiderDetectorService.isSpider(request);
    }

    public static boolean isSpider(String ip) {
        return spiderDetectorService.isSpider(ip);
    }
}

