/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.consumer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.factory.SubmissionServiceFactory;

public class SubmissionConfigConsumer
implements Consumer {
    private static Logger log = LogManager.getLogger(SubmissionConfigConsumer.class);
    IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        int st = event.getSubjectType();
        int et = event.getEventType();
        if (st == 3) {
            switch (et) {
                case 4: {
                    DSpaceObject subject = event.getSubject(ctx);
                    Collection collectionFromDSOSubject = (Collection)subject;
                    this.indexer.indexContent(ctx, new IndexableCollection(collectionFromDSOSubject), true, false, false);
                    this.indexer.commit();
                    log.debug("SubmissionConfigConsumer occured: " + event.toString());
                    SubmissionServiceFactory.getInstance().getSubmissionConfigService().reload();
                    break;
                }
                default: {
                    log.debug("SubmissionConfigConsumer occured: " + event.toString());
                    SubmissionServiceFactory.getInstance().getSubmissionConfigService().reload();
                }
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

