/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents.dao.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.List;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask_;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.dao.ClaimedTaskDAO;

public class ClaimedTaskDAOImpl
extends AbstractHibernateDAO<ClaimedTask>
implements ClaimedTaskDAO {
    protected ClaimedTaskDAOImpl() {
    }

    @Override
    public List<ClaimedTask> findByWorkflowItem(Context context, XmlWorkflowItem workflowItem) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ClaimedTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ClaimedTask.class);
        Root claimedTaskRoot = criteriaQuery.from(ClaimedTask.class);
        criteriaQuery.select((Selection)claimedTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.workflowItem), (Object)workflowItem));
        return this.list(context, criteriaQuery, false, ClaimedTask.class, -1, -1);
    }

    @Override
    public ClaimedTask findByWorkflowItemAndEPerson(Context context, XmlWorkflowItem workflowItem, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ClaimedTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ClaimedTask.class);
        Root claimedTaskRoot = criteriaQuery.from(ClaimedTask.class);
        criteriaQuery.select((Selection)claimedTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.workflowItem), (Object)workflowItem), (Expression)criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.owner), (Object)ePerson)));
        return this.uniqueResult(context, criteriaQuery, false, ClaimedTask.class);
    }

    @Override
    public List<ClaimedTask> findByEperson(Context context, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ClaimedTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ClaimedTask.class);
        Root claimedTaskRoot = criteriaQuery.from(ClaimedTask.class);
        criteriaQuery.select((Selection)claimedTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.owner), (Object)ePerson));
        return this.list(context, criteriaQuery, false, ClaimedTask.class, -1, -1);
    }

    @Override
    public List<ClaimedTask> findByWorkflowItemAndStepId(Context context, XmlWorkflowItem workflowItem, String stepID) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ClaimedTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ClaimedTask.class);
        Root claimedTaskRoot = criteriaQuery.from(ClaimedTask.class);
        criteriaQuery.select((Selection)claimedTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.workflowItem), (Object)workflowItem), (Expression)criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.stepId), (Object)stepID)));
        return this.list(context, criteriaQuery, false, ClaimedTask.class, -1, -1);
    }

    @Override
    public ClaimedTask findByEPersonAndWorkflowItemAndStepIdAndActionId(Context context, EPerson ePerson, XmlWorkflowItem workflowItem, String stepID, String actionID) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ClaimedTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ClaimedTask.class);
        Root claimedTaskRoot = criteriaQuery.from(ClaimedTask.class);
        criteriaQuery.select((Selection)claimedTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.workflowItem), (Object)workflowItem), criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.stepId), (Object)stepID), criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.owner), (Object)ePerson), criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.actionId), (Object)actionID)}));
        return this.uniqueResult(context, criteriaQuery, false, ClaimedTask.class);
    }

    @Override
    public List<ClaimedTask> findByWorkflowItemAndStepIdAndActionId(Context context, XmlWorkflowItem workflowItem, String stepID, String actionID) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ClaimedTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ClaimedTask.class);
        Root claimedTaskRoot = criteriaQuery.from(ClaimedTask.class);
        criteriaQuery.select((Selection)claimedTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.workflowItem), (Object)workflowItem), criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.stepId), (Object)stepID), criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.actionId), (Object)actionID)}));
        return this.list(context, criteriaQuery, false, ClaimedTask.class, -1, -1);
    }

    @Override
    public List<ClaimedTask> findByStep(Context context, String stepID) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ClaimedTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ClaimedTask.class);
        Root claimedTaskRoot = criteriaQuery.from(ClaimedTask.class);
        criteriaQuery.select((Selection)claimedTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)claimedTaskRoot.get(ClaimedTask_.stepId), (Object)stepID));
        return this.list(context, criteriaQuery, false, ClaimedTask.class, -1, -1);
    }
}

