/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.dspace.content.Entity;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityServiceImpl
implements EntityService {
    @Autowired(required=true)
    protected EntityTypeService entityTypeService;
    @Autowired(required=true)
    protected RelationshipService relationshipService;
    @Autowired(required=true)
    protected RelationshipTypeService relationshipTypeService;
    @Autowired(required=true)
    protected ItemService itemService;

    @Override
    public Entity findByItemId(Context context, UUID itemId) throws SQLException {
        return this.findByItemId(context, itemId, -1, -1);
    }

    @Override
    public Entity findByItemId(Context context, UUID itemId, Integer limit, Integer offset) throws SQLException {
        Item item = (Item)this.itemService.find(context, itemId);
        List<Relationship> relationshipList = this.relationshipService.findByItem(context, item, limit, offset, true);
        return new Entity(item, relationshipList);
    }

    @Override
    public EntityType getType(Context context, Entity entity) throws SQLException {
        Item item = entity.getItem();
        return this.itemService.getEntityType(context, item);
    }

    @Override
    public List<Relationship> getLeftRelations(Context context, Entity entity) {
        List<Relationship> fullList = entity.getRelationships();
        LinkedList<Relationship> listToReturn = new LinkedList<Relationship>();
        for (Relationship relationship : fullList) {
            if (relationship.getLeftItem().getID() != entity.getItem().getID()) continue;
            listToReturn.add(relationship);
        }
        return listToReturn;
    }

    @Override
    public List<Relationship> getRightRelations(Context context, Entity entity) {
        List<Relationship> fullList = entity.getRelationships();
        LinkedList<Relationship> listToReturn = new LinkedList<Relationship>();
        for (Relationship relationship : fullList) {
            if (relationship.getRightItem().getID() != entity.getItem().getID()) continue;
            listToReturn.add(relationship);
        }
        return listToReturn;
    }

    @Override
    public List<Relationship> getRelationsByTypeName(Context context, String typeName) throws SQLException {
        return this.getRelationsByTypeName(context, typeName, -1, -1);
    }

    @Override
    public List<Relationship> getRelationsByTypeName(Context context, String typeName, Integer limit, Integer offset) throws SQLException {
        return this.relationshipService.findByTypeName(context, typeName, limit, offset);
    }

    @Override
    public List<RelationshipType> getAllRelationshipTypes(Context context, Entity entity) throws SQLException {
        return this.getAllRelationshipTypes(context, entity, -1, -1);
    }

    @Override
    public List<RelationshipType> getAllRelationshipTypes(Context context, Entity entity, Integer limit, Integer offset) throws SQLException {
        EntityType entityType = this.getType(context, entity);
        if (entityType != null) {
            return this.relationshipTypeService.findByEntityType(context, entityType, limit, offset);
        }
        return Collections.emptyList();
    }

    @Override
    public List<RelationshipType> getLeftRelationshipTypes(Context context, Entity entity) throws SQLException {
        return this.getLeftRelationshipTypes(context, entity, true, -1, -1);
    }

    @Override
    public List<RelationshipType> getLeftRelationshipTypes(Context context, Entity entity, boolean isLeft, Integer limit, Integer offset) throws SQLException {
        EntityType entityType = this.getType(context, entity);
        if (entityType != null) {
            return this.relationshipTypeService.findByEntityType(context, entityType, isLeft, limit, offset);
        }
        return Collections.emptyList();
    }

    @Override
    public List<RelationshipType> getRightRelationshipTypes(Context context, Entity entity) throws SQLException {
        return this.getRightRelationshipTypes(context, entity, false, -1, -1);
    }

    @Override
    public List<RelationshipType> getRightRelationshipTypes(Context context, Entity entity, boolean isLeft, Integer limit, Integer offset) throws SQLException {
        EntityType entityType = this.getType(context, entity);
        if (entityType != null) {
            return this.relationshipTypeService.findByEntityType(context, entityType, isLeft, limit, offset);
        }
        return Collections.emptyList();
    }

    @Override
    public List<RelationshipType> getRelationshipTypesByTypeName(Context context, String type) throws SQLException {
        return this.getRelationshipTypesByTypeName(context, type, -1, -1);
    }

    @Override
    public List<RelationshipType> getRelationshipTypesByTypeName(Context context, String typeName, Integer limit, Integer offset) throws SQLException {
        return this.relationshipTypeService.findByLeftwardOrRightwardTypeName(context, typeName, limit, offset);
    }
}

